/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;

public class TransportConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<TransportConfiguration> {
    public static final String DEFAULT_TRANSPORT = "org.infinispan.remoting.transport.jgroups.JGroupsTransport";
    private final ThreadsConfigurationBuilder threads;
    private final AttributeSet attributes;
    private final JGroupsConfigurationBuilder jgroupsConfigurationBuilder;
    private TypedProperties typedProperties = new TypedProperties();

    TransportConfigurationBuilder(GlobalConfigurationBuilder globalConfig, ThreadsConfigurationBuilder threads) {
        super(globalConfig);
        this.threads = threads;
        this.attributes = TransportConfiguration.attributeSet();
        this.jgroupsConfigurationBuilder = new JGroupsConfigurationBuilder(globalConfig);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public TransportConfigurationBuilder clusterName(String clusterName) {
        this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).set((Object)clusterName);
        return this;
    }

    public TransportConfigurationBuilder machineId(String machineId) {
        this.attributes.attribute(TransportConfiguration.MACHINE_ID).set((Object)machineId);
        return this;
    }

    public TransportConfigurationBuilder rackId(String rackId) {
        this.attributes.attribute(TransportConfiguration.RACK_ID).set((Object)rackId);
        return this;
    }

    public TransportConfigurationBuilder siteId(String siteId) {
        this.attributes.attribute(TransportConfiguration.SITE_ID).set((Object)siteId);
        return this;
    }

    public TransportConfigurationBuilder stack(String stack) {
        this.attributes.attribute(TransportConfiguration.STACK).set((Object)stack);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout) {
        this.attributes.attribute(TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT).set((Object)TimeQuantity.valueOf((long)distributedSyncTimeout));
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(String distributedSyncTimeout) {
        this.attributes.attribute(TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT).set((Object)TimeQuantity.valueOf((String)distributedSyncTimeout));
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout, TimeUnit unit) {
        return this.distributedSyncTimeout(unit.toMillis(distributedSyncTimeout));
    }

    public TransportConfigurationBuilder initialClusterSize(int clusterSize) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_SIZE).set((Object)clusterSize);
        return this;
    }

    public TransportConfigurationBuilder initialClusterTimeout(long initialClusterTimeout, TimeUnit unit) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_TIMEOUT).set((Object)TimeQuantity.valueOf((long)unit.toMillis(initialClusterTimeout)));
        return this;
    }

    public TransportConfigurationBuilder initialClusterTimeout(String initialClusterTimeout) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_TIMEOUT).set((Object)TimeQuantity.valueOf((String)initialClusterTimeout));
        return this;
    }

    public TransportConfigurationBuilder transport(Transport transport) {
        this.jgroupsConfigurationBuilder.transport(transport);
        return this;
    }

    public TransportConfigurationBuilder nodeName(String nodeName) {
        this.attributes.attribute(TransportConfiguration.NODE_NAME).set((Object)nodeName);
        return this;
    }

    public TransportConfigurationBuilder withProperties(Properties properties) {
        this.typedProperties = TypedProperties.toTypedProperties((Map)properties);
        return this;
    }

    public TransportConfigurationBuilder clearProperties() {
        this.typedProperties.clear();
        return this;
    }

    public TransportConfigurationBuilder addProperty(String key, Object value) {
        this.typedProperties.put((Object)key, value);
        return this;
    }

    public TransportConfigurationBuilder removeProperty(String key) {
        this.typedProperties.remove((Object)key);
        return this;
    }

    public String getProperty(String key) {
        return String.valueOf(this.typedProperties.get((Object)key));
    }

    public ThreadPoolConfigurationBuilder transportThreadPool() {
        return this.threads.transportThreadPool();
    }

    public ThreadPoolConfigurationBuilder remoteCommandThreadPool() {
        return this.threads.remoteCommandThreadPool();
    }

    public void validate() {
        if (this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).isNull()) {
            throw Log.CONFIG.requireNonNullClusterName();
        }
        this.validateRaftMembers();
    }

    public JGroupsConfigurationBuilder jgroups() {
        return this.jgroupsConfigurationBuilder;
    }

    public TransportConfiguration create() {
        return new TransportConfiguration(this.attributes.protect(), this.jgroupsConfigurationBuilder.create(), this.threads.transportThreadPool().create(), this.threads.remoteCommandThreadPool().create(), this.typedProperties);
    }

    public TransportConfigurationBuilder defaultTransport() {
        Transport transport = (Transport)Util.getInstance((String)DEFAULT_TRANSPORT, (ClassLoader)this.getGlobalConfig().getClassLoader());
        this.transport(transport);
        return this;
    }

    @Deprecated(forRemoval=true, since="11.0")
    public TransportConfigurationBuilder transportExecutor(String threadPoolName) {
        this.attributes.attribute(TransportConfiguration.TRANSPORT_EXECUTOR).set((Object)threadPoolName);
        return this;
    }

    public TransportConfigurationBuilder raftMember(String member) {
        HashSet<String> newMembers = new HashSet<String>((Collection)this.attributes.attribute(TransportConfiguration.RAFT_MEMBERS).get());
        if (newMembers.add(member)) {
            this.attributes.attribute(TransportConfiguration.RAFT_MEMBERS).set(Collections.unmodifiableSet(newMembers));
        }
        return this;
    }

    public TransportConfigurationBuilder raftMembers(String ... members) {
        return this.raftMembers(Arrays.asList(members));
    }

    public TransportConfigurationBuilder raftMembers(Collection<String> members) {
        HashSet<String> newMembers = new HashSet<String>((Collection)this.attributes.attribute(TransportConfiguration.RAFT_MEMBERS).get());
        if (newMembers.addAll(members)) {
            this.attributes.attribute(TransportConfiguration.RAFT_MEMBERS).set(Collections.unmodifiableSet(newMembers));
        }
        return this;
    }

    public TransportConfigurationBuilder read(TransportConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.jgroupsConfigurationBuilder.read(template.jgroups(), combine);
        this.typedProperties = new TypedProperties((Map)template.properties());
        if (template.transport() != null) {
            Transport transport = (Transport)Util.getInstance((String)template.transport().getClass().getName(), (ClassLoader)template.transport().getClass().getClassLoader());
            this.transport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        return this.jgroupsConfigurationBuilder.jgroupsTransport();
    }

    public String toString() {
        return "TransportConfigurationBuilder{threads=" + String.valueOf(this.threads) + ", attributes=" + String.valueOf(this.attributes) + ", jgroupsConfigurationBuilder=" + String.valueOf(this.jgroupsConfigurationBuilder) + ", typedProperties=" + String.valueOf(this.typedProperties) + "}";
    }

    private void validateRaftMembers() {
        Set raftMembers = (Set)this.attributes.attribute(TransportConfiguration.RAFT_MEMBERS).get();
        if (raftMembers.isEmpty()) {
            return;
        }
        String raftId = (String)this.attributes.attribute(TransportConfiguration.NODE_NAME).get();
        if (raftId == null || raftId.isEmpty()) {
            throw Log.CONFIG.requireNodeName();
        }
        if (!raftMembers.contains(raftId)) {
            throw Log.CONFIG.nodeNameNotInRaftMembers(String.valueOf(raftMembers));
        }
    }
}

