/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import org.infinispan.commons.util.Experimental;
import org.infinispan.functional.impl.Params;

@Experimental
public interface Param<P> {
    public int id();

    public P get();

    @Experimental
    public static enum ReplicationMode implements Param<ReplicationMode>
    {
        SYNC,
        ASYNC;

        public static final int ID = 4;
        static final ReplicationMode[] CACHED_VALUES;

        @Override
        public int id() {
            return 4;
        }

        @Override
        public ReplicationMode get() {
            return this;
        }

        public static ReplicationMode defaultValue() {
            return SYNC;
        }

        public static ReplicationMode valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        static {
            CACHED_VALUES = ReplicationMode.values();
        }
    }

    @Experimental
    public static enum StatisticsMode implements Param<StatisticsMode>
    {
        GATHER,
        SKIP;

        public static final int ID = 3;
        private static final StatisticsMode[] CACHED_VALUES;

        @Override
        public int id() {
            return 3;
        }

        @Override
        public StatisticsMode get() {
            return this;
        }

        public static StatisticsMode defaultValue() {
            return GATHER;
        }

        public static StatisticsMode valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        public static boolean isSkip(Params params) {
            return params.get(3).get() == SKIP;
        }

        static {
            CACHED_VALUES = StatisticsMode.values();
        }
    }

    @Experimental
    public static enum ExecutionMode implements Param<ExecutionMode>
    {
        ALL,
        LOCAL,
        LOCAL_SITE;

        public static final int ID = 2;
        private static final ExecutionMode[] CACHED_VALUES;

        @Override
        public int id() {
            return 2;
        }

        @Override
        public ExecutionMode get() {
            return this;
        }

        public static ExecutionMode defaultValue() {
            return ALL;
        }

        public static ExecutionMode valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        static {
            CACHED_VALUES = ExecutionMode.values();
        }
    }

    @Experimental
    public static enum LockingMode implements Param<LockingMode>
    {
        LOCK,
        SKIP,
        TRY_LOCK;

        public static final int ID = 1;
        private static final LockingMode[] CACHED_VALUES;

        @Override
        public int id() {
            return 1;
        }

        @Override
        public LockingMode get() {
            return this;
        }

        public static LockingMode defaultValue() {
            return LOCK;
        }

        public static LockingMode valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        static {
            CACHED_VALUES = LockingMode.values();
        }
    }

    @Experimental
    public static enum PersistenceMode implements Param<PersistenceMode>
    {
        LOAD_PERSIST,
        SKIP_PERSIST,
        SKIP_LOAD,
        SKIP;

        public static final int ID = 0;
        private static final PersistenceMode[] CACHED_VALUES;

        @Override
        public int id() {
            return 0;
        }

        @Override
        public PersistenceMode get() {
            return this;
        }

        public static PersistenceMode defaultValue() {
            return LOAD_PERSIST;
        }

        public static PersistenceMode valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        static {
            CACHED_VALUES = PersistenceMode.values();
        }
    }
}

