/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import jakarta.transaction.Transaction;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.transaction.xa.XAException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class TransactionCoordinator {
    private static final Log log = LogFactory.getLog(TransactionCoordinator.class);
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    ComponentRef<InvocationContextFactory> icf;
    @Inject
    ComponentRef<AsyncInterceptorChain> invoker;
    @Inject
    ComponentRef<TransactionTable> txTable;
    @Inject
    ComponentRef<RecoveryManager> recoveryManager;
    @Inject
    Configuration configuration;
    private CommandCreator commandCreator;
    private volatile boolean shuttingDown = false;
    private boolean defaultOnePhaseCommit;
    private boolean use1PcForAutoCommitTransactions;
    private static final CompletableFuture<Integer> XA_OKAY_STAGE = CompletableFuture.completedFuture(0);
    private static final Function<Object, Integer> XA_RDONLY_APPLY = ignore -> 3;

    @Start
    void setStartStatus() {
        this.shuttingDown = false;
    }

    @Stop
    void setStopStatus() {
        this.shuttingDown = true;
    }

    @Start
    public void start() {
        this.use1PcForAutoCommitTransactions = this.configuration.transaction().use1PcForAutoCommitTransactions();
        this.defaultOnePhaseCommit = Configurations.isOnePhaseCommit(this.configuration);
        this.commandCreator = Configurations.isTxVersioned(this.configuration) ? new CommandCreator(){

            @Override
            public CommitCommand createCommitCommand(GlobalTransaction gtx) {
                return TransactionCoordinator.this.commandsFactory.buildVersionedCommitCommand(gtx);
            }

            @Override
            public PrepareCommand createPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
                return TransactionCoordinator.this.commandsFactory.buildVersionedPrepareCommand(gtx, modifications, onePhaseCommit);
            }
        } : new CommandCreator(){

            @Override
            public CommitCommand createCommitCommand(GlobalTransaction gtx) {
                return TransactionCoordinator.this.commandsFactory.buildCommitCommand(gtx);
            }

            @Override
            public PrepareCommand createPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
                return TransactionCoordinator.this.commandsFactory.buildPrepareCommand(gtx, modifications, onePhaseCommit);
            }
        };
    }

    public final CompletionStage<Integer> prepare(LocalTransaction localTransaction) {
        return this.prepare(localTransaction, false);
    }

    public final CompletionStage<Integer> prepare(LocalTransaction localTransaction, boolean replayEntryWrapping) {
        CompletionStage<Integer> markRollbackStage = this.validateNotMarkedForRollback(localTransaction);
        if (markRollbackStage != null) {
            return markRollbackStage;
        }
        if (this.isOnePhaseCommit(localTransaction)) {
            if (log.isTraceEnabled()) {
                log.tracef("Received prepare for tx: %s. Skipping call as 1PC will be used.", localTransaction);
            }
            return XA_OKAY_STAGE;
        }
        PrepareCommand prepareCommand = this.commandCreator.createPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), false);
        if (log.isTraceEnabled()) {
            log.tracef("Sending prepare command through the chain: %s", prepareCommand);
        }
        LocalTxInvocationContext ctx = this.icf.running().createTxInvocationContext(localTransaction);
        prepareCommand.setReplayEntryWrapping(replayEntryWrapping);
        CompletableFuture<Object> prepareStage = this.invoker.running().invokeAsync(ctx, prepareCommand);
        return CompletionStages.handleAndCompose(prepareStage, (ignore, prepareThrowable) -> {
            if (prepareThrowable != null) {
                if (this.shuttingDown) {
                    log.trace("Exception while preparing back, probably because we're shutting down.");
                } else {
                    log.errorProcessingPrepare((Throwable)prepareThrowable);
                }
                return CompletionStages.handleAndCompose(this.rollback(localTransaction), (ignore2, rollbackThrowable) -> {
                    XAException xe = new XAException(100);
                    if (rollbackThrowable != null) {
                        rollbackThrowable.addSuppressed((Throwable)prepareThrowable);
                        xe.initCause((Throwable)rollbackThrowable);
                    } else {
                        xe.initCause((Throwable)prepareThrowable);
                    }
                    return CompletableFuture.failedFuture(xe);
                });
            }
            if (localTransaction.isReadOnly()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Readonly transaction: %s", localTransaction.getGlobalTransaction());
                }
                return this.commitInternal(ctx).thenApply(XA_RDONLY_APPLY);
            }
            this.txTable.running().localTransactionPrepared(localTransaction);
            return XA_OKAY_STAGE;
        });
    }

    public CompletionStage<Boolean> commit(LocalTransaction localTransaction, boolean isOnePhase) {
        if (log.isTraceEnabled()) {
            log.tracef("Committing transaction %s", localTransaction.getGlobalTransaction());
        }
        LocalTxInvocationContext ctx = this.icf.running().createTxInvocationContext(localTransaction);
        if (this.isOnePhaseCommit(localTransaction) || isOnePhase) {
            CompletionStage<Boolean> markRollbackStage = this.validateNotMarkedForRollback(localTransaction);
            if (markRollbackStage != null) {
                return markRollbackStage;
            }
            if (log.isTraceEnabled()) {
                log.trace("Doing an 1PC prepare call on the interceptor chain");
            }
            List<WriteCommand> modifications = localTransaction.getModifications();
            PrepareCommand command = this.commandCreator.createPrepareCommand(localTransaction.getGlobalTransaction(), modifications, true);
            return CompletionStages.handleAndCompose(this.invoker.running().invokeAsync(ctx, command), (ignore, t) -> {
                if (t != null) {
                    return this.handleCommitFailure((Throwable)t, true, ctx);
                }
                return CompletableFutures.completedTrue();
            });
        }
        if (!localTransaction.isReadOnly()) {
            return this.commitInternal(ctx);
        }
        return CompletableFutures.completedFalse();
    }

    public CompletionStage<Void> rollback(LocalTransaction localTransaction) {
        if (localTransaction.hasRolledBack()) {
            return CompletableFutures.completedNull();
        }
        return CompletionStages.handleAndCompose(this.rollbackInternal(this.icf.running().createTxInvocationContext(localTransaction)), (ignore, t) -> {
            localTransaction.markAsRolledBack();
            if (t != null) {
                return this.handleRollbackFailure((Throwable)t, localTransaction);
            }
            return CompletableFutures.completedNull();
        });
    }

    private <T> CompletionStage<T> handleRollbackFailure(Throwable t, LocalTransaction localTransaction) {
        if (this.shuttingDown) {
            log.trace("Exception while rolling back, probably because we're shutting down.");
        } else {
            log.errorRollingBack(t);
        }
        Transaction transaction = localTransaction.getTransaction();
        if (transaction != null) {
            this.txTable.running().failureCompletingTransaction(transaction);
        }
        XAException xe = new XAException(-3);
        xe.initCause(t);
        return CompletableFuture.failedFuture(t);
    }

    private <T> CompletionStage<T> handleCommitFailure(Throwable e, boolean onePhaseCommit, LocalTxInvocationContext ctx) {
        if (log.isTraceEnabled()) {
            log.tracef("Couldn't commit transaction %s, trying to rollback.", ctx.getCacheTransaction());
        }
        if (onePhaseCommit) {
            log.errorProcessing1pcPrepareCommand(e);
        } else {
            log.errorProcessing2pcCommitCommand(e);
        }
        boolean isRecoveryEnabled = this.recoveryManager.running() != null;
        CompletionStage<Object> stage = !isRecoveryEnabled ? this.rollbackInternal(ctx) : CompletableFutures.completedNull();
        return stage.handle((ignore, t) -> {
            this.txTable.running().failureCompletingTransaction(ctx.getTransaction());
            if (t != null) {
                log.couldNotRollbackPrepared1PcTransaction((LocalTransaction)ctx.getCacheTransaction(), (Throwable)t);
                XAException xe = new XAException(-3);
                xe.initCause((Throwable)t);
                xe.addSuppressed(e);
                throw new CompletionException(xe);
            }
            XAException xe = new XAException(6);
            xe.initCause(e);
            throw new CompletionException(xe);
        });
    }

    private CompletionStage<Boolean> commitInternal(LocalTxInvocationContext ctx) {
        CommitCommand commitCommand = this.commandCreator.createCommitCommand(ctx.getGlobalTransaction());
        CompletableFuture<Object> commitStage = this.invoker.running().invokeAsync(ctx, commitCommand);
        return CompletionStages.handleAndCompose(commitStage, (ignore, t) -> {
            if (t != null) {
                return this.handleCommitFailure((Throwable)t, false, ctx);
            }
            this.txTable.running().removeLocalTransaction((LocalTransaction)ctx.getCacheTransaction());
            return CompletableFutures.completedFalse();
        });
    }

    private CompletionStage<Void> rollbackInternal(LocalTxInvocationContext ctx) {
        if (log.isTraceEnabled()) {
            log.tracef("rollback transaction %s ", ctx.getGlobalTransaction());
        }
        RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(ctx.getGlobalTransaction());
        return this.invoker.running().invokeAsync(ctx, rollbackCommand).thenRun(() -> this.txTable.running().removeLocalTransaction((LocalTransaction)ctx.getCacheTransaction()));
    }

    private <T> CompletionStage<T> validateNotMarkedForRollback(LocalTransaction localTransaction) {
        if (localTransaction.isMarkedForRollback()) {
            if (log.isTraceEnabled()) {
                log.tracef("Transaction already marked for rollback. Forcing rollback for %s", localTransaction);
            }
            return this.rollback(localTransaction).thenApply(ignore -> {
                throw CompletableFutures.asCompletionException((Throwable)new XAException(100));
            });
        }
        return null;
    }

    public boolean is1PcForAutoCommitTransaction(LocalTransaction localTransaction) {
        return this.use1PcForAutoCommitTransactions && localTransaction.isImplicitTransaction();
    }

    private boolean isOnePhaseCommit(LocalTransaction localTransaction) {
        return this.defaultOnePhaseCommit || this.is1PcForAutoCommitTransaction(localTransaction);
    }

    private static interface CommandCreator {
        public CommitCommand createCommitCommand(GlobalTransaction var1);

        public PrepareCommand createPrepareCommand(GlobalTransaction var1, List<WriteCommand> var2, boolean var3);
    }
}

