/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class StateTransferConfiguration
extends ConfigurationElement<StateTransferConfiguration> {
    public static final AttributeDefinition<Boolean> AWAIT_INITIAL_TRANSFER = AttributeDefinition.builder((Enum)Attribute.AWAIT_INITIAL_TRANSFER, (Object)true).global(false).build();
    public static final AttributeDefinition<Boolean> FETCH_IN_MEMORY_STATE = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)true).immutable().build();
    public static final AttributeDefinition<Long> TIMEOUT = AttributeDefinition.builder((Enum)Attribute.TIMEOUT, (Object)TimeUnit.MINUTES.toMillis(4L)).immutable().build();
    public static final AttributeDefinition<Integer> CHUNK_SIZE = AttributeDefinition.builder((Enum)Attribute.CHUNK_SIZE, (Object)512).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> awaitInitialTransfer;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> fetchInMemoryState;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> timeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> chunkSize;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(StateTransferConfiguration.class, new AttributeDefinition[]{FETCH_IN_MEMORY_STATE, TIMEOUT, CHUNK_SIZE, AWAIT_INITIAL_TRANSFER});
    }

    StateTransferConfiguration(AttributeSet attributes) {
        super((Enum)Element.STATE_TRANSFER, attributes, new ConfigurationElement[0]);
        this.awaitInitialTransfer = attributes.attribute(AWAIT_INITIAL_TRANSFER);
        this.fetchInMemoryState = attributes.attribute(FETCH_IN_MEMORY_STATE);
        this.timeout = attributes.attribute(TIMEOUT);
        this.chunkSize = attributes.attribute(CHUNK_SIZE);
    }

    public boolean fetchInMemoryState() {
        return (Boolean)this.fetchInMemoryState.get();
    }

    public long timeout() {
        return (Long)this.timeout.get();
    }

    @Deprecated(forRemoval=true, since="12.1")
    public StateTransferConfiguration timeout(long l) {
        this.timeout.set((Object)l);
        return this;
    }

    public int chunkSize() {
        return (Integer)this.chunkSize.get();
    }

    public boolean awaitInitialTransfer() {
        return (Boolean)this.awaitInitialTransfer.get();
    }

    private boolean originalAwaitInitialTransfer() {
        return !this.awaitInitialTransfer.isModified();
    }
}

