package org.infinispan.xsite;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.processing.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationParameterMetadata;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.lifecycle.ModuleLifecycle;

/**
 * @api.private 
 */
@Generated(value = "org.infinispan.component.processor.Generator", date = "2023-04-06T16:24:42.679323481Z")
public final class CorePackageImpl {
   public static void registerMetadata(ModuleMetadataBuilder.ModuleBuilder builder) {
//start org.infinispan.xsite.NoOpBackupSender
      builder.registerComponentAccessor("org.infinispan.xsite.NoOpBackupSender",
         Collections.emptyList(),
         new ComponentAccessor<NoOpBackupSender>("org.infinispan.xsite.NoOpBackupSender",
            1, false, null,
            Collections.emptyList()));

//start org.infinispan.xsite.BackupReceiver
      builder.registerComponentAccessor("org.infinispan.xsite.BackupReceiver",
         Collections.emptyList(),
         new ComponentAccessor<BackupReceiver>("org.infinispan.xsite.BackupReceiver",
            1, false, null,
            Collections.emptyList()));

//start org.infinispan.xsite.ClusteredCacheBackupReceiver
      builder.registerComponentAccessor("org.infinispan.xsite.ClusteredCacheBackupReceiver",
         Collections.emptyList(),
         new ComponentAccessor<ClusteredCacheBackupReceiver>("org.infinispan.xsite.ClusteredCacheBackupReceiver",
            1, false, null,
            Arrays.asList("org.infinispan.Cache", "org.infinispan.commons.time.TimeService", "org.infinispan.commands.CommandsFactory", "org.infinispan.distribution.ch.KeyPartitioner", "org.infinispan.cache.impl.InvocationHelper", "org.infinispan.context.InvocationContextFactory", "org.infinispan.remoting.rpc.RpcManager", "org.infinispan.interceptors.locking.ClusteringDependentLogic")) {
         protected void wire(ClusteredCacheBackupReceiver instance, WireContext context, boolean start) {
            instance.cache = context.get("org.infinispan.Cache", org.infinispan.Cache.class, start);
            instance.timeService = context.get("org.infinispan.commons.time.TimeService", org.infinispan.commons.time.TimeService.class, start);
            instance.commandsFactory = context.get("org.infinispan.commands.CommandsFactory", org.infinispan.commands.CommandsFactory.class, start);
            instance.keyPartitioner = context.get("org.infinispan.distribution.ch.KeyPartitioner", org.infinispan.distribution.ch.KeyPartitioner.class, start);
            instance.invocationHelper = context.get("org.infinispan.cache.impl.InvocationHelper", org.infinispan.cache.impl.InvocationHelper.class, start);
            instance.invocationContextFactory = context.get("org.infinispan.context.InvocationContextFactory", org.infinispan.context.InvocationContextFactory.class, start);
            instance.rpcManager = context.get("org.infinispan.remoting.rpc.RpcManager", org.infinispan.remoting.rpc.RpcManager.class, start);
            instance.clusteringDependentLogic = context.get("org.infinispan.interceptors.locking.ClusteringDependentLogic", org.infinispan.interceptors.locking.ClusteringDependentLogic.class, start);
         }

         protected void start(ClusteredCacheBackupReceiver instance) throws Exception {
            instance.start();
         }

      });

//start org.infinispan.xsite.BackupSenderImpl
      builder.registerComponentAccessor("org.infinispan.xsite.BackupSenderImpl",
         Collections.emptyList(),
         new ComponentAccessor<BackupSenderImpl>("org.infinispan.xsite.BackupSenderImpl",
            1, false, null,
            Arrays.asList("org.infinispan.remoting.rpc.RpcManager", "org.infinispan.configuration.cache.Configuration", "org.infinispan.transaction.impl.TransactionTable", "org.infinispan.commons.time.TimeService", "org.infinispan.commands.CommandsFactory", "org.infinispan.util.logging.events.EventLogManager", "org.infinispan.configuration.global.GlobalConfiguration", "org.infinispan.distribution.ch.KeyPartitioner", "org.infinispan.xsite.status.TakeOfflineManager")) {
         protected void wire(BackupSenderImpl instance, WireContext context, boolean start) {
            instance.cache = context.getLazy("org.infinispan.Cache", org.infinispan.Cache.class, start);
            instance.rpcManager = context.get("org.infinispan.remoting.rpc.RpcManager", org.infinispan.remoting.rpc.RpcManager.class, start);
            instance.config = context.get("org.infinispan.configuration.cache.Configuration", org.infinispan.configuration.cache.Configuration.class, start);
            instance.txTable = context.get("org.infinispan.transaction.impl.TransactionTable", org.infinispan.transaction.impl.TransactionTable.class, start);
            instance.timeService = context.get("org.infinispan.commons.time.TimeService", org.infinispan.commons.time.TimeService.class, start);
            instance.commandsFactory = context.get("org.infinispan.commands.CommandsFactory", org.infinispan.commands.CommandsFactory.class, start);
            instance.eventLogManager = context.get("org.infinispan.util.logging.events.EventLogManager", org.infinispan.util.logging.events.EventLogManager.class, start);
            instance.globalConfig = context.get("org.infinispan.configuration.global.GlobalConfiguration", org.infinispan.configuration.global.GlobalConfiguration.class, start);
            instance.keyPartitioner = context.get("org.infinispan.distribution.ch.KeyPartitioner", org.infinispan.distribution.ch.KeyPartitioner.class, start);
            instance.takeOfflineManager = context.get("org.infinispan.xsite.status.TakeOfflineManager", org.infinispan.xsite.status.TakeOfflineManager.class, start);
         }

         protected void start(BackupSenderImpl instance) throws Exception {
            instance.start();
         }

      });

//start org.infinispan.xsite.XSiteAdminOperations
      builder.registerComponentAccessor("org.infinispan.xsite.XSiteAdminOperations",
         Collections.emptyList(),
         new ComponentAccessor<XSiteAdminOperations>("org.infinispan.xsite.XSiteAdminOperations",
            1, true, null,
            Arrays.asList("org.infinispan.remoting.rpc.RpcManager", "org.infinispan.xsite.statetransfer.XSiteStateTransferManager", "org.infinispan.commands.CommandsFactory", "org.infinispan.xsite.status.TakeOfflineManager", "org.infinispan.security.impl.Authorizer")) {
         protected void wire(XSiteAdminOperations instance, WireContext context, boolean start) {
            instance.rpcManager = context.get("org.infinispan.remoting.rpc.RpcManager", org.infinispan.remoting.rpc.RpcManager.class, start);
            instance.stateTransferManager = context.get("org.infinispan.xsite.statetransfer.XSiteStateTransferManager", org.infinispan.xsite.statetransfer.XSiteStateTransferManager.class, start);
            instance.commandsFactory = context.get("org.infinispan.commands.CommandsFactory", org.infinispan.commands.CommandsFactory.class, start);
            instance.takeOfflineManager = context.get("org.infinispan.xsite.status.TakeOfflineManager", org.infinispan.xsite.status.TakeOfflineManager.class, start);
            instance.authorizer = context.get("org.infinispan.security.impl.Authorizer", org.infinispan.security.impl.Authorizer.class, start);
         }

      });

      builder.registerMBeanMetadata("org.infinispan.xsite.XSiteAdminOperations",
         MBeanMetadata.of("XSiteAdmin", "Exposes tooling for handling backing up data to remote sites.", null,
            new OperationMetadata("siteStatus", "", "Check whether the given backup site is offline or not.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("status", "", "Returns the the status(offline/online) of all the configured backup sites.", "java.lang.String"
            ),
            new OperationMetadata("takeSiteOffline", "", "Takes this site offline in all nodes in the cluster.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("setTakeOfflineAfterFailures", "", "Amends the values for 'afterFailures' for the 'TakeOffline' functionality on all the nodes in the cluster.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site"),
               new OperationParameterMetadata("afterFailures", "int", "The number of failures after which the site will be taken offline")
            ),
            new OperationMetadata("setTakeOfflineMinTimeToWait", "", "Amends the values for 'minTimeToWait' for the 'TakeOffline' functionality on all the nodes in the cluster.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site"),
               new OperationParameterMetadata("minTimeToWait", "long", "The minimum amount of time in milliseconds to wait before taking a site offline")
            ),
            new OperationMetadata("amendTakeOffline", "", "Amends the values for 'TakeOffline' functionality on all the nodes in the cluster.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site"),
               new OperationParameterMetadata("afterFailures", "int", "The number of failures after which the site will be taken offline"),
               new OperationParameterMetadata("minTimeToWait", "long", "The minimum amount of time in milliseconds to wait before taking a site offline")
            ),
            new OperationMetadata("getTakeOfflineMinTimeToWait", "", "Returns the value of the 'minTimeToWait' for the 'TakeOffline' functionality.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("getTakeOfflineAfterFailures", "", "Returns the value of the 'afterFailures' for the 'TakeOffline' functionality.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("bringSiteOnline", "", "Brings the given site back online on all the cluster.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("pushState", "pushState", "Pushes the state of this cache to the remote site. The remote site will be bring back online", "java.lang.String",
               new OperationParameterMetadata("SiteName", "java.lang.String", "The destination site name")
            ),
            new OperationMetadata("getPushStateStatus", "PushStateStatus", "Shows a map with destination site name and the state transfer status.", "java.util.Map"
            ),
            new OperationMetadata("clearPushStateStatus", "ClearPushStateStatus", "Clears the state transfer status.", "java.lang.String"
            ),
            new OperationMetadata("cancelPushState", "CancelPushState", "Cancels the push state to remote site.", "java.lang.String",
               new OperationParameterMetadata("SiteName", "java.lang.String", "The destination site name")
            ),
            new OperationMetadata("cancelReceiveState", "CancelReceiveState", "Cancels the push state to this site. All the state received from state transfer will be ignored.", "java.lang.String",
               new OperationParameterMetadata("SiteName", "java.lang.String", "The sending site name")
            ),
            new OperationMetadata("getSendingSiteName", "SendingSiteName", "Returns the site name from which this site is receiving state.", "java.lang.String"
            ),
            new OperationMetadata("getStateTransferMode", "GetStateTransferMode", "Returns the cross-site replication state transfer mode.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "null")
            ),
            new OperationMetadata("setStateTransferMode", "SetStateTransferMode", "Sets the cross-site state transfer mode.", "boolean",
               new OperationParameterMetadata("site", "java.lang.String", "null"),
               new OperationParameterMetadata("mode", "java.lang.String", "null")
            )
      ));

//start org.infinispan.xsite.GlobalXSiteAdminOperations
      builder.registerComponentAccessor("org.infinispan.xsite.GlobalXSiteAdminOperations",
         Collections.emptyList(),
         new ComponentAccessor<GlobalXSiteAdminOperations>("org.infinispan.xsite.GlobalXSiteAdminOperations",
            0, false, null,
            Arrays.asList("org.infinispan.manager.EmbeddedCacheManager")) {
         protected void wire(GlobalXSiteAdminOperations instance, WireContext context, boolean start) {
            instance.cacheManager = context.get("org.infinispan.manager.EmbeddedCacheManager", org.infinispan.manager.EmbeddedCacheManager.class, start);
         }

      });

      builder.registerMBeanMetadata("org.infinispan.xsite.GlobalXSiteAdminOperations",
         MBeanMetadata.of("GlobalXSiteAdminOperations", "Exposes tooling for handling backing up data to remote sites.", null,
            new OperationMetadata("takeSiteOffline", "", "Takes this site offline in all caches in the cluster.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("bringSiteOnline", "", "Brings the given site back online on all the caches.", "java.lang.String",
               new OperationParameterMetadata("site", "java.lang.String", "The name of the backup site")
            ),
            new OperationMetadata("pushState", "pushState", "Pushes the state of all caches to the corresponding remote site if the cache backups to it. The remote site will be bring back online", "java.lang.String",
               new OperationParameterMetadata("SiteName", "java.lang.String", "The destination site name")
            ),
            new OperationMetadata("cancelPushState", "CancelPushState", "Cancels the push state on all the caches to remote site.", "java.lang.String",
               new OperationParameterMetadata("SiteName", "java.lang.String", "The destination site name")
            )
      ));

//end
   }
}
