/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.file.SecurityActions;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteNamedCache;
import org.reactivestreams.Publisher;

@ConfiguredBy(value=SingleFileStoreConfiguration.class)
public class SingleFileStore<K, V>
implements NonBlockingStore<K, V> {
    private static final Log log = LogFactory.getLog(SingleFileStore.class);
    public static final byte[] MAGIC_BEFORE_11 = new byte[]{70, 67, 83, 49};
    public static final byte[] MAGIC_11_0 = new byte[]{70, 67, 83, 50};
    public static final byte[] MAGIC_12_0 = new byte[]{70, 67, 83, 51};
    public static final byte[] MAGIC_12_1 = new byte[]{70, 67, 83, 52};
    public static final byte[] MAGIC_LATEST = MAGIC_12_1;
    private static final byte[] ZERO_INT = new byte[]{0, 0, 0, 0};
    private static final int KEYLEN_POS = 4;
    public static final int KEY_POS_BEFORE_11 = 24;
    public static final int KEY_POS_11_0 = 28;
    public static final int KEY_POS_LATEST = 28;
    private static final int TIMESTAMP_BYTES = 16;
    private static final int SMALLEST_ENTRY_SIZE = 128;
    private SingleFileStoreConfiguration configuration;
    protected InitializationContext ctx;
    private FileChannel channel;
    @GuardedBy(value="resizeLock")
    private Map<K, FileEntry>[] entries;
    private SortedSet<FileEntry> freeList;
    private long filePos;
    private File file;
    private float fragmentationFactor = 0.75f;
    private final StampedLock resizeLock = new StampedLock();
    private TimeService timeService;
    private MarshallableEntryFactory<K, V> entryFactory;
    private KeyPartitioner keyPartitioner;
    private BlockingManager blockingManager;
    private boolean segmented;
    private int actualNumSegments;
    private int maxEntries;

    public static File getStoreFile(String directoryPath, String cacheName) {
        return new File(new File(directoryPath), cacheName + ".dat");
    }

    @Override
    public CompletionStage<Void> start(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (SingleFileStoreConfiguration)ctx.getConfiguration();
        this.timeService = ctx.getTimeService();
        this.entryFactory = ctx.getMarshallableEntryFactory();
        this.blockingManager = ctx.getBlockingManager();
        this.keyPartitioner = ctx.getKeyPartitioner();
        this.maxEntries = this.configuration.maxEntries();
        this.segmented = this.configuration.segmented();
        this.actualNumSegments = this.segmented ? ctx.getCache().getCacheConfiguration().clustering().hash().numSegments() : 1;
        this.entries = new Map[this.actualNumSegments];
        this.freeList = Collections.synchronizedSortedSet(new TreeSet());
        this.blockingAddSegments(IntSets.immutableRangeSet((int)this.actualNumSegments));
        return this.blockingManager.runBlocking(this::blockingStart, "sfs-start");
    }

    private void blockingStart() {
        boolean shouldClear = this.configuration.purgeOnStartup();
        boolean readOnly = this.configuration.ignoreModifications();
        assert (!shouldClear || !readOnly) : "Store can't be configured with both purge and ignore modifications";
        try {
            Path resolvedPath = PersistenceUtil.getLocation(this.ctx.getGlobalConfiguration(), this.configuration.location());
            this.file = SingleFileStore.getStoreFile(resolvedPath.toString(), this.cacheName());
            boolean hasSingleFile = SecurityActions.fileExists(this.file);
            if (hasSingleFile) {
                this.channel = SecurityActions.openFileChannel(this.file);
                byte[] magicHeader = this.validateExistingFile(this.channel, this.file.getAbsolutePath());
                if (magicHeader != null) {
                    this.migrateNonSegmented(magicHeader, shouldClear);
                } else if (!shouldClear) {
                    this.rebuildIndex();
                    this.processFreeEntries();
                } else {
                    this.clear();
                }
            } else if (this.hasAnyComposedSegmentedFiles()) {
                if (!shouldClear) {
                    this.migrateFromComposedSegmentedLoadWriteStore(shouldClear);
                }
            } else if (!readOnly) {
                File dir = this.file.getParentFile();
                if (!SecurityActions.createDirectoryIfNeeded(dir)) {
                    throw Log.PERSISTENCE.directoryCannotBeCreated(dir.getAbsolutePath());
                }
                this.channel = this.createNewFile(this.file);
            }
            this.fragmentationFactor = this.configuration.fragmentationFactor();
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    private boolean hasAnyComposedSegmentedFiles() {
        int numSegments = this.ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
        for (int segment = 0; segment < numSegments; ++segment) {
            File segmentFile = this.getComposedSegmentFile(segment);
            if (!SecurityActions.fileExists(segmentFile)) continue;
            return true;
        }
        return false;
    }

    private byte[] validateExistingFile(FileChannel fileChannel, String filePath) throws Exception {
        byte[] headerMagic = new byte[MAGIC_LATEST.length];
        int headerBytes = fileChannel.read(java.nio.ByteBuffer.wrap(headerMagic), 0L);
        if (headerBytes == MAGIC_LATEST.length) {
            if (!Arrays.equals(MAGIC_LATEST, headerMagic)) {
                return headerMagic;
            }
        } else {
            throw Log.PERSISTENCE.invalidSingleFileStoreData(filePath);
        }
        return null;
    }

    private void migrateNonSegmented(byte[] magicHeader, boolean removeOnly) throws Exception {
        Log.PERSISTENCE.startMigratingPersistenceData(this.cacheName());
        File newFile = new File(this.file.getParentFile(), this.cacheName() + "_new.dat");
        try {
            if (SecurityActions.fileExists(newFile)) {
                if (log.isTraceEnabled()) {
                    log.tracef("Overwriting temporary migration file %s", newFile);
                }
                SecurityActions.deleteFile(newFile);
            }
            try (FileChannel newChannel = this.createNewFile(newFile);){
                if (!removeOnly) {
                    this.copyEntriesFromOldFile(magicHeader, newChannel, this.channel, this.file.toString());
                }
            }
            this.channel.close();
            SecurityActions.moveFile(newFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.channel = SecurityActions.openFileChannel(this.file);
            Log.PERSISTENCE.persistedDataSuccessfulMigrated(this.cacheName());
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(this.cacheName(), e);
        }
    }

    private void copyEntriesFromOldFile(byte[] magicHeader, FileChannel destChannel, FileChannel sourceChannel, String sourcePath) throws Exception {
        if (magicHeader == null) {
            this.copyEntriesFromV12_0(destChannel, sourceChannel, sourcePath);
        } else if (Arrays.equals(MAGIC_12_0, magicHeader)) {
            if (this.ctx.getGlobalConfiguration().serialization().marshaller() == null) {
                this.copyCorruptDataV12_0(destChannel, sourceChannel, sourcePath);
            } else {
                this.copyEntriesFromV12_0(destChannel, sourceChannel, sourcePath);
            }
        } else if (Arrays.equals(MAGIC_11_0, magicHeader)) {
            this.copyEntriesFromV11(destChannel, sourceChannel);
        } else {
            if (Arrays.equals(MAGIC_BEFORE_11, magicHeader)) {
                throw Log.PERSISTENCE.persistedDataMigrationUnsupportedVersion("< 11");
            }
            throw Log.PERSISTENCE.invalidSingleFileStoreData(this.file.getAbsolutePath());
        }
    }

    private FileChannel createNewFile(File newFile) throws IOException {
        FileChannel newChannel = SecurityActions.openFileChannel(newFile);
        try {
            newChannel.truncate(0L);
            newChannel.write(java.nio.ByteBuffer.wrap(MAGIC_LATEST), 0L);
            this.filePos = MAGIC_LATEST.length;
            return newChannel;
        }
        catch (Throwable t) {
            newChannel.close();
            throw t;
        }
    }

    @Override
    public CompletionStage<Void> stop() {
        return this.ctx.getBlockingManager().runBlocking(this::blockingStop, "sfs-stop");
    }

    private void blockingStop() {
        if (log.isTraceEnabled() && this.channel != null) {
            Long size = CompletionStages.join(this.approximateSize(IntSets.immutableRangeSet((int)this.actualNumSegments)));
            log.tracef("Stopping store %s, size = %d, file size = %d", this.cacheName(), size, this.filePos);
        }
        long stamp = this.resizeLock.writeLock();
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
                this.entries = null;
                this.freeList = null;
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.unlockWrite(stamp);
        }
    }

    @Override
    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    @Override
    public CompletionStage<Boolean> isAvailable() {
        return CompletableFutures.booleanStage(SecurityActions.fileExists(this.file));
    }

    private void rebuildIndex() throws Exception {
        this.filePos = MAGIC_LATEST.length;
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
        while ((buf = this.readChannel(buf, this.filePos, 28, this.channel)).remaining() <= 0) {
            buf.flip();
            FileEntry fe = new FileEntry(this.filePos, buf);
            if (fe.size < 28 + fe.keyLen + fe.dataLen + fe.metadataLen + fe.internalMetadataLen) {
                throw Log.PERSISTENCE.errorReadingFileStore(this.file.getPath(), this.filePos);
            }
            this.filePos += (long)fe.size;
            if (fe.keyLen > 0) {
                buf = this.readChannel(buf, fe.offset + 28L, fe.keyLen, this.channel);
                Object key = this.ctx.getPersistenceMarshaller().objectFromByteBuffer(buf.array(), 0, fe.keyLen);
                Map<Object, FileEntry> segmentEntries = this.getSegmentEntries(this.getSegment(key));
                segmentEntries.put(key, fe);
                continue;
            }
            this.freeList.add(fe);
        }
    }

    private int getSegment(Object key) {
        return this.segmented ? this.keyPartitioner.getSegment(key) : 0;
    }

    private PrivateMetadata generateMissingInternalMetadata() {
        AdvancedCache cache = this.ctx.getCache().getAdvancedCache();
        Configuration config = cache.getCacheConfiguration();
        TransactionConfiguration txConfig = config.transaction();
        PrivateMetadata.Builder builder = new PrivateMetadata.Builder();
        if (txConfig.transactionMode() == TransactionMode.TRANSACTIONAL && txConfig.lockingMode() == LockingMode.OPTIMISTIC) {
            builder.entryVersion(new SimpleClusteredVersion(1, 1L));
        }
        if (config.sites().hasAsyncEnabledBackups()) {
            String siteName = cache.getRpcManager().getTransport().localSiteName();
            IracEntryVersion version = IracEntryVersion.newVersion(XSiteNamedCache.cachedByteString(siteName), TopologyIracVersion.newVersion(1));
            builder.iracMetadata(new IracMetadata(siteName, version));
        }
        return builder.build();
    }

    private void migrateFromComposedSegmentedLoadWriteStore(boolean removeOnly) throws IOException {
        Log.PERSISTENCE.startMigratingPersistenceData(this.cacheName());
        File newFile = new File(this.file.getParentFile(), this.cacheName() + "_new.dat");
        try {
            if (SecurityActions.fileExists(newFile)) {
                if (log.isTraceEnabled()) {
                    log.tracef("Overwriting temporary migration file %s", newFile);
                }
                SecurityActions.deleteFile(newFile);
            }
            try (FileChannel newChannel = this.createNewFile(newFile);){
                if (!removeOnly) {
                    this.copyEntriesFromOldSegmentFiles(newChannel);
                }
            }
            SecurityActions.moveFile(newFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.channel = SecurityActions.openFileChannel(this.file);
            this.removeComposedSegmentedLoadWriteStoreFiles();
            Log.PERSISTENCE.persistedDataSuccessfulMigrated(this.cacheName());
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(this.cacheName(), e);
        }
    }

    private void copyEntriesFromOldSegmentFiles(FileChannel newChannel) throws Exception {
        int numSegments = this.ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
        for (int segment = 0; segment < numSegments; ++segment) {
            File segmentFile = this.getComposedSegmentFile(segment);
            if (!SecurityActions.fileExists(segmentFile)) continue;
            try (FileChannel segmentChannel = SecurityActions.openFileChannel(segmentFile);){
                byte[] magic = this.validateExistingFile(segmentChannel, segmentFile.toString());
                this.copyEntriesFromOldFile(magic, newChannel, segmentChannel, segmentFile.toString());
                continue;
            }
        }
    }

    private void removeComposedSegmentedLoadWriteStoreFiles() {
        Path rootLocation = PersistenceUtil.getLocation(this.ctx.getGlobalConfiguration(), this.configuration.location());
        if (log.isTraceEnabled()) {
            log.tracef("Removing old ComposedSegmentedLoadWriteStore files from %s", rootLocation);
        }
        int numSegments = this.ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
        for (int segment = 0; segment < numSegments; ++segment) {
            File segmentFile = this.getComposedSegmentFile(segment);
            if (!SecurityActions.fileExists(segmentFile)) continue;
            SecurityActions.deleteFile(segmentFile);
            File parentDir = segmentFile.getParentFile();
            if (parentDir == null || !parentDir.isDirectory() || parentDir.list().length != 0) continue;
            SecurityActions.deleteFile(parentDir);
        }
    }

    private File getComposedSegmentFile(int segment) {
        return SingleFileStore.segmentFileLocation(this.ctx.getGlobalConfiguration(), this.configuration.location(), this.cacheName(), segment);
    }

    private static File segmentFileLocation(GlobalConfiguration globalConfiguration, String location, String cacheName, int segment) {
        Path rootPath = PersistenceUtil.getLocation(globalConfiguration, location);
        String segmentPath = AbstractSegmentedStoreConfiguration.fileLocationTransform(rootPath.toString(), segment);
        return SingleFileStore.getStoreFile(segmentPath, cacheName);
    }

    private void copyEntriesFromV12_0(FileChannel destChannel, FileChannel sourceChannel, String sourcePath) throws Exception {
        try {
            long currentTs = this.timeService.wallClockTime();
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
            java.nio.ByteBuffer bodyBuf = java.nio.ByteBuffer.allocate(28);
            long oldFilePos = MAGIC_12_0.length;
            while ((buf = this.readChannel(buf, oldFilePos, 28, sourceChannel)).remaining() <= 0) {
                buf.flip();
                FileEntry oldFe = new FileEntry(oldFilePos, buf);
                if (oldFe.size < 28 + oldFe.keyLen + oldFe.dataLen + oldFe.metadataLen + oldFe.internalMetadataLen) {
                    throw Log.PERSISTENCE.errorReadingFileStore(this.file.getPath(), oldFilePos);
                }
                oldFilePos += (long)oldFe.size;
                if (oldFe.keyLen < 1 || oldFe.expiryTime > 0L && oldFe.expiryTime < currentTs) continue;
                bodyBuf = this.allocate(bodyBuf, oldFe.size - 28);
                this.readChannel(bodyBuf, oldFe.offset + 28L, oldFe.size - 28, sourceChannel);
                Object key = this.ctx.getPersistenceMarshaller().objectFromByteBuffer(bodyBuf.array(), 0, oldFe.keyLen);
                FileEntry newFe = new FileEntry(this.filePos, oldFe.size, oldFe.keyLen, oldFe.dataLen, oldFe.metadataLen, oldFe.internalMetadataLen, oldFe.expiryTime);
                Map<Object, FileEntry> segmentEntries = this.getSegmentEntries(this.getSegment(key));
                segmentEntries.put(key, newFe);
                buf.flip();
                destChannel.write(buf, this.filePos);
                bodyBuf.flip();
                destChannel.write(bodyBuf, this.filePos + 28L);
                this.filePos += (long)newFe.size;
                if (!log.isTraceEnabled()) continue;
                log.tracef("Recovered entry %s at %d:%d", new Object[]{key, newFe.size, newFe.offset, newFe.size});
            }
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(this.cacheName(), e);
        }
    }

    private String cacheName() {
        return this.ctx.getCache().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCorruptDataV12_0(FileChannel destChannel, FileChannel sourceChannel, String sourcePath) {
        Log.PERSISTENCE.startRecoveringCorruptPersistenceData(sourcePath);
        long sanityEpoch = LocalDate.of(2019, 10, 26).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long currentTs = this.timeService.wallClockTime();
        int entriesRecovered = 0;
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
        ByRef bufRef = ByRef.create((Object)buf);
        try {
            long fileSize = sourceChannel.size();
            long oldFilePos = MAGIC_12_0.length;
            while ((buf = this.readChannel(buf, oldFilePos, 28, sourceChannel)).remaining() <= 0) {
                Object value;
                Object key;
                buf.flip();
                FileEntry fe = new FileEntry(oldFilePos, buf);
                if (fe.size <= 0 || fe.expiryTime < -1L || fe.keyLen <= 0 || fe.keyLen > fe.size || fe.dataLen <= 0 || fe.dataLen > fe.size || fe.metadataLen < 0 || fe.metadataLen > fe.size || fe.internalMetadataLen < 0 || fe.internalMetadataLen > fe.size) {
                    ++oldFilePos;
                    continue;
                }
                long estimateSizeExcludingInternal = fe.keyLen;
                estimateSizeExcludingInternal += (long)fe.dataLen;
                if ((estimateSizeExcludingInternal += (long)fe.metadataLen) > fileSize - oldFilePos) {
                    ++oldFilePos;
                    continue;
                }
                Metadata metadata = null;
                ByRef.Long offset = new ByRef.Long(oldFilePos + 28L);
                bufRef.set((Object)buf);
                try {
                    int metaLen;
                    key = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, fe.keyLen, sourceChannel);
                    value = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, fe.dataLen, sourceChannel);
                    int n = metaLen = fe.metadataLen > 0 ? fe.metadataLen - 16 : 0;
                    if (metaLen > 0) {
                        metadata = (Metadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, metaLen, sourceChannel);
                    }
                    oldFilePos = offset.get();
                }
                catch (Throwable t) {
                    ++oldFilePos;
                    continue;
                }
                finally {
                    buf = (java.nio.ByteBuffer)bufRef.get();
                    continue;
                }
                long created = -1L;
                long lastUsed = -1L;
                if (fe.metadataLen > 0 && fe.expiryTime > 0L) {
                    buf = this.readChannelUpdateOffset(buf, offset, 16, sourceChannel);
                    buf.flip();
                    created = buf.getLong();
                    lastUsed = buf.getLong();
                    if (created != -1L && (created > currentTs || created < sanityEpoch)) {
                        long lifespan = metadata.lifespan();
                        long l = created = lifespan > 0L ? fe.expiryTime - lifespan : currentTs;
                    }
                    if (lastUsed != -1L && (lastUsed > currentTs || lastUsed < sanityEpoch)) {
                        long maxIdle = metadata.maxIdle();
                        lastUsed = maxIdle > 0L ? fe.expiryTime - maxIdle : currentTs;
                    }
                    oldFilePos = offset.get();
                }
                PrivateMetadata internalMeta = null;
                if (fe.internalMetadataLen > 0) {
                    try {
                        bufRef.set((Object)buf);
                        internalMeta = (PrivateMetadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, fe.internalMetadataLen, sourceChannel);
                        oldFilePos = offset.get();
                    }
                    catch (Throwable t) {
                        internalMeta = this.generateMissingInternalMetadata();
                    }
                    finally {
                        buf = (java.nio.ByteBuffer)bufRef.get();
                    }
                }
                if (fe.expiryTime > 0L && fe.expiryTime < currentTs) continue;
                MarshallableEntry me = this.ctx.getMarshallableEntryFactory().create(key, value, metadata, internalMeta, created, lastUsed);
                this.write(this.getSegment(key), me, destChannel);
                ++entriesRecovered;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Recovered %d entries", entriesRecovered);
            }
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.corruptDataMigrationFailed(this.cacheName(), e);
        }
    }

    private void copyEntriesFromV11(FileChannel destChannel, FileChannel sourceChannel) {
        long oldFilePos = MAGIC_11_0.length;
        boolean wrapperMissing = this.ctx.getGlobalConfiguration().serialization().marshaller() == null;
        try {
            long currentTs = this.timeService.wallClockTime();
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
            ByRef bufRef = ByRef.create((Object)buf);
            while ((buf = this.readChannel(buf, oldFilePos, 28, sourceChannel)).remaining() <= 0) {
                buf.flip();
                FileEntry oldFe = new FileEntry(oldFilePos, buf);
                if (oldFe.size < 28 + oldFe.keyLen + oldFe.dataLen + oldFe.metadataLen + oldFe.internalMetadataLen) {
                    throw Log.PERSISTENCE.errorReadingFileStore(this.file.getPath(), oldFilePos);
                }
                oldFilePos += (long)oldFe.size;
                if (oldFe.keyLen < 1 || oldFe.expiryTime > 0L && oldFe.expiryTime < currentTs) continue;
                ByRef.Long offset = new ByRef.Long(oldFe.offset + 28L);
                long created = -1L;
                long lastUsed = -1L;
                bufRef.set((Object)buf);
                Object key = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.keyLen, wrapperMissing, sourceChannel);
                Object value = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.dataLen, wrapperMissing, sourceChannel);
                Metadata metadata = null;
                if (oldFe.metadataLen > 0) {
                    metadata = (Metadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.metadataLen - 16, wrapperMissing, sourceChannel);
                    if (oldFe.expiryTime > 0L) {
                        buf = (java.nio.ByteBuffer)bufRef.get();
                        buf = this.readChannelUpdateOffset(buf, offset, 16, sourceChannel);
                        buf.flip();
                        created = buf.getLong();
                        lastUsed = buf.getLong();
                        bufRef.set((Object)buf);
                    }
                }
                PrivateMetadata internalMeta = null;
                if (oldFe.internalMetadataLen > 0) {
                    internalMeta = (PrivateMetadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.internalMetadataLen, wrapperMissing, sourceChannel);
                    buf = (java.nio.ByteBuffer)bufRef.get();
                }
                MarshallableEntry me = this.ctx.getMarshallableEntryFactory().create(key, value, metadata, internalMeta, created, lastUsed);
                this.write(this.getSegment(key), me, destChannel);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(this.cacheName(), e);
        }
    }

    private <T> T unmarshallObject(ByRef<java.nio.ByteBuffer> buf, ByRef.Long offset, int length, FileChannel sourceChannel) throws ClassNotFoundException, IOException {
        return this.unmarshallObject(buf, offset, length, false, sourceChannel);
    }

    private <T> T unmarshallObject(ByRef<java.nio.ByteBuffer> bufRef, ByRef.Long offset, int length, boolean legacyWrapperMissing, FileChannel sourceChannel) throws ClassNotFoundException, IOException {
        java.nio.ByteBuffer buf = (java.nio.ByteBuffer)bufRef.get();
        buf = this.readChannelUpdateOffset(buf, offset, length, sourceChannel);
        byte[] bytes = buf.array();
        bufRef.set((Object)buf);
        PersistenceMarshaller persistenceMarshaller = this.ctx.getPersistenceMarshaller();
        if (legacyWrapperMissing) {
            Marshaller marshaller = persistenceMarshaller.getUserMarshaller();
            try {
                return (T)marshaller.objectFromByteBuffer(bytes, 0, length);
            }
            catch (IllegalArgumentException e) {
                return (T)persistenceMarshaller.objectFromByteBuffer(bytes, 0, length);
            }
        }
        return (T)persistenceMarshaller.objectFromByteBuffer(bytes, 0, length);
    }

    private java.nio.ByteBuffer readChannelUpdateOffset(java.nio.ByteBuffer buf, ByRef.Long offset, int length, FileChannel sourceChannel) throws IOException {
        return this.readChannel(buf, offset.getAndAdd((long)length), length, sourceChannel);
    }

    private java.nio.ByteBuffer readChannel(java.nio.ByteBuffer buf, long offset, int length, FileChannel channel) throws IOException {
        buf = this.allocate(buf, length);
        channel.read(buf, offset);
        return buf;
    }

    private java.nio.ByteBuffer allocate(java.nio.ByteBuffer buf, int length) {
        buf.flip();
        if (buf.capacity() < length) {
            buf = java.nio.ByteBuffer.allocate(length);
        }
        buf.clear().limit(length);
        return buf;
    }

    @Override
    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        long stamp = this.resizeLock.tryReadLock();
        if (stamp != 0L) {
            FileEntry fe = this.getFileEntryWithReadLock(segment, key, stamp, false);
            return CompletableFutures.booleanStage(fe != null);
        }
        return this.blockingManager.supplyBlocking(() -> this.blockingContainsKey(segment, key), "sfs-containsKey");
    }

    private boolean blockingContainsKey(int segment, Object key) {
        long stamp = this.resizeLock.readLock();
        FileEntry fe = this.getFileEntryWithReadLock(segment, key, stamp, false);
        return fe != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="resizeLock.readLock()")
    private FileEntry allocate(int len) {
        SortedSet<FileEntry> sortedSet = this.freeList;
        synchronized (sortedSet) {
            SortedSet<FileEntry> candidates = this.freeList.tailSet(new FileEntry(0L, len));
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                FileEntry free = (FileEntry)it.next();
                if (free.isLocked()) continue;
                it.remove();
                return this.allocateExistingEntry(free, len);
            }
            FileEntry fe = new FileEntry(this.filePos, len);
            this.filePos += (long)len;
            if (log.isTraceEnabled()) {
                log.tracef("New entry allocated at %d:%d, %d free entries, file size is %d", new Object[]{fe.offset, fe.size, this.freeList.size(), this.filePos});
            }
            return fe;
        }
    }

    private FileEntry allocateExistingEntry(FileEntry free, int len) {
        int remainder = free.size - len;
        if (remainder >= 128 && (float)len <= (float)free.size * this.fragmentationFactor) {
            try {
                FileEntry newFreeEntry = new FileEntry(free.offset + (long)len, remainder);
                this.addNewFreeEntry(newFreeEntry);
                FileEntry newEntry = new FileEntry(free.offset, len);
                if (log.isTraceEnabled()) {
                    log.tracef("Split entry at %d:%d, allocated %d:%d, free %d:%d, %d free entries", new Object[]{free.offset, free.size, newEntry.offset, newEntry.size, newFreeEntry.offset, newFreeEntry.size, this.freeList.size()});
                }
                return newEntry;
            }
            catch (IOException e) {
                throw new PersistenceException("Cannot add new free entry", e);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Existing free entry allocated at %d:%d, %d free entries", free.offset, free.size, this.freeList.size());
        }
        return free;
    }

    private void addNewFreeEntry(FileEntry fe) throws IOException {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
        buf.putInt(fe.size);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putLong(-1L);
        buf.flip();
        this.channel.write(buf, fe.offset);
        this.freeList.add(fe);
    }

    private void free(FileEntry fe) throws IOException {
        if (fe != null) {
            fe.waitUnlocked();
            this.channel.write(java.nio.ByteBuffer.wrap(ZERO_INT), fe.offset + 4L);
            if (!this.freeList.add(fe)) {
                throw new IllegalStateException(String.format("Trying to free an entry that was not allocated: %s", fe));
            }
            if (log.isTraceEnabled()) {
                log.tracef("Deleted entry at %d:%d, there are now %d free entries", fe.offset, fe.size, this.freeList.size());
            }
        }
    }

    @Override
    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> marshalledEntry) {
        return this.blockingManager.runBlocking(() -> this.blockingWrite(segment, marshalledEntry), "sfs-write");
    }

    private void blockingWrite(int segment, MarshallableEntry<? extends K, ? extends V> marshalledEntry) {
        this.write(segment, marshalledEntry, this.channel);
    }

    private void write(int segment, MarshallableEntry<? extends K, ? extends V> marshalledEntry, FileChannel channel) {
        ByteBuffer key = marshalledEntry.getKeyBytes();
        ByteBuffer data = marshalledEntry.getValueBytes();
        ByteBuffer metadata = marshalledEntry.getMetadataBytes();
        ByteBuffer internalMetadata = marshalledEntry.getInternalMetadataBytes();
        int metadataLength = metadata == null ? 0 : metadata.getLength() + 16;
        int internalMetadataLength = internalMetadata == null ? 0 : internalMetadata.getLength();
        int len = 28 + key.getLength() + data.getLength() + metadataLength + internalMetadataLength;
        long stamp = this.resizeLock.readLock();
        try {
            FileEntry oldEntry;
            Map<K, FileEntry> segmentEntries = this.getSegmentEntries(segment);
            if (segmentEntries == null) {
                return;
            }
            FileEntry newEntry = this.allocate(len);
            newEntry = new FileEntry(newEntry.offset, newEntry.size, key.getLength(), data.getLength(), metadataLength, internalMetadataLength, marshalledEntry.expiryTime());
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(len);
            newEntry.writeToBuf(buf);
            buf.put(key.getBuf(), key.getOffset(), key.getLength());
            buf.put(data.getBuf(), data.getOffset(), data.getLength());
            if (metadata != null) {
                buf.put(metadata.getBuf(), metadata.getOffset(), metadata.getLength());
                if (newEntry.expiryTime > 0L) {
                    buf.putLong(marshalledEntry.created());
                    buf.putLong(marshalledEntry.lastUsed());
                }
            }
            if (internalMetadata != null) {
                buf.put(internalMetadata.getBuf(), internalMetadata.getOffset(), internalMetadata.getLength());
            }
            buf.flip();
            channel.write(buf, newEntry.offset);
            if (log.isTraceEnabled()) {
                log.tracef("Wrote entry %s:%d at %d:%d", new Object[]{marshalledEntry.getKey(), len, newEntry.offset, newEntry.size});
            }
            if ((oldEntry = segmentEntries.put(marshalledEntry.getKey(), newEntry)) == null) {
                oldEntry = this.evict();
            }
            this.free(oldEntry);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="resizeLock#readLock")
    private FileEntry evict() {
        if (this.maxEntries > 0) {
            Map<K, FileEntry> segment0Entries;
            Map<K, FileEntry> map = segment0Entries = this.getSegmentEntries(0);
            synchronized (map) {
                if (segment0Entries.size() > this.maxEntries) {
                    Iterator<FileEntry> it = segment0Entries.values().iterator();
                    FileEntry fe = it.next();
                    it.remove();
                    return fe;
                }
            }
        }
        return null;
    }

    @Override
    public CompletionStage<Void> clear() {
        return this.blockingManager.runBlocking(this::blockingClear, "sfs-clear");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingClear() {
        long stamp = this.resizeLock.writeLock();
        try {
            for (Map<K, FileEntry> segmentEntries : this.entries) {
                if (segmentEntries == null) continue;
                Map<K, FileEntry> map = segmentEntries;
                synchronized (map) {
                    for (FileEntry fe : segmentEntries.values()) {
                        fe.waitUnlocked();
                    }
                    segmentEntries.clear();
                }
            }
            SortedSet<FileEntry> sortedSet = this.freeList;
            synchronized (sortedSet) {
                for (FileEntry fe : this.freeList) {
                    fe.waitUnlocked();
                }
                this.freeList.clear();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Truncating file, current size is %d", this.filePos);
            }
            this.channel.truncate(4L);
            this.channel.write(java.nio.ByteBuffer.wrap(MAGIC_LATEST), 0L);
            this.filePos = MAGIC_LATEST.length;
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
        finally {
            this.resizeLock.unlockWrite(stamp);
        }
    }

    @Override
    public CompletionStage<Boolean> delete(int segment, Object key) {
        long stamp = this.resizeLock.tryReadLock();
        if (stamp != 0L) {
            FileEntry fe = this.deleteWithReadLock(segment, key);
            if (fe == null) {
                this.resizeLock.unlockRead(stamp);
                return CompletableFutures.completedFalse();
            }
            return this.blockingManager.supplyBlocking(() -> this.deleteInFile(stamp, fe), "sfs-delete");
        }
        return this.blockingManager.supplyBlocking(() -> this.blockingDelete(segment, key), "sfs-delete");
    }

    private boolean blockingDelete(int segment, Object key) {
        long stamp = this.resizeLock.readLock();
        FileEntry fe = this.deleteWithReadLock(segment, key);
        return this.deleteInFile(stamp, fe);
    }

    private boolean deleteInFile(long stamp, FileEntry fe) {
        try {
            this.free(fe);
            boolean bl = fe != null;
            return bl;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
    }

    private FileEntry deleteWithReadLock(int segment, Object key) {
        Map<K, FileEntry> segmentEntries = this.getSegmentEntries(segment);
        if (segmentEntries == null) {
            return null;
        }
        return segmentEntries.remove(key);
    }

    @Override
    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        long stamp = this.resizeLock.tryReadLock();
        if (stamp != 0L) {
            FileEntry fe = this.getFileEntryWithReadLock(segment, key, stamp, true);
            if (fe == null) {
                return CompletableFutures.completedNull();
            }
            return this.blockingManager.supplyBlocking(() -> this.readFromDisk(fe, key, true, true), "sfs-load");
        }
        return this.blockingManager.supplyBlocking(() -> this.blockingLoad(segment, key, true, true), "sfs-load");
    }

    private MarshallableEntry<K, V> blockingLoad(int segment, Object key, boolean loadValue, boolean loadMetadata) {
        long stamp = this.resizeLock.readLock();
        FileEntry fe = this.getFileEntryWithReadLock(segment, key, stamp, true);
        if (fe == null) {
            return null;
        }
        return this.readFromDisk(fe, key, loadValue, loadMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private FileEntry getFileEntryWithReadLock(int segment, Object key, long stamp, boolean lockFileEntry) {
        FileEntry fe;
        block12: {
            Map<K, FileEntry> segmentEntries = this.getSegmentEntries(segment);
            if (segmentEntries == null) {
                FileEntry fileEntry = null;
                this.resizeLock.unlockRead(stamp);
                return fileEntry;
            }
            Map<K, FileEntry> map = segmentEntries;
            // MONITORENTER : map
            fe = segmentEntries.get(key);
            if (fe == null) {
                FileEntry fileEntry = null;
                // MONITOREXIT : map
                this.resizeLock.unlockRead(stamp);
                return fileEntry;
            }
            if (!fe.isExpired(this.timeService.wallClockTime())) break block12;
            FileEntry fileEntry = null;
            this.resizeLock.unlockRead(stamp);
            return fileEntry;
        }
        try {
            if (lockFileEntry) {
                fe.lock();
            }
            // MONITOREXIT : map
            return fe;
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshallableEntry<K, V> readFromDisk(FileEntry fe, Object key, boolean loadValue, boolean loadMetadata) {
        byte[] data;
        ByteBuffer valueBb = null;
        if (!loadValue && !loadMetadata) {
            try {
                MarshallableEntry<K, V> marshallableEntry = this.entryFactory.create(key);
                return marshallableEntry;
            }
            finally {
                fe.unlock();
            }
        }
        try {
            data = new byte[fe.keyLen + fe.dataLen + (loadMetadata ? fe.metadataLen + fe.internalMetadataLen : 0)];
            this.channel.read(java.nio.ByteBuffer.wrap(data), fe.offset + 28L);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            fe.unlock();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Read entry %s at %d:%d", key, fe.offset, fe.actualSize());
        }
        ByteBufferFactory factory = this.ctx.getByteBufferFactory();
        ByteBuffer keyBb = factory.newByteBuffer(data, 0, fe.keyLen);
        if (loadValue) {
            valueBb = factory.newByteBuffer(data, fe.keyLen, fe.dataLen);
        }
        if (loadMetadata) {
            long created = -1L;
            long lastUsed = -1L;
            ByteBuffer metadataBb = null;
            ByteBuffer internalMetadataBb = null;
            int offset = fe.keyLen + fe.dataLen;
            if (fe.metadataLen > 0) {
                int metaLength = fe.metadataLen - 16;
                metadataBb = factory.newByteBuffer(data, offset, metaLength);
                java.nio.ByteBuffer buffer = java.nio.ByteBuffer.wrap(data, offset += metaLength, 16);
                if (fe.expiryTime > 0L) {
                    offset += 16;
                    created = buffer.getLong();
                    lastUsed = buffer.getLong();
                }
            }
            if (fe.internalMetadataLen > 0) {
                internalMetadataBb = factory.newByteBuffer(data, offset, fe.internalMetadataLen);
            }
            return this.entryFactory.create(keyBb, valueBb, metadataBb, internalMetadataBb, created, lastUsed);
        }
        return this.entryFactory.create(keyBb, valueBb);
    }

    @GuardedBy(value="resizeLock")
    private Map<K, FileEntry> getSegmentEntries(int segment) {
        if (!this.segmented) {
            return this.entries[0];
        }
        if (this.actualNumSegments <= segment) {
            throw new IndexOutOfBoundsException();
        }
        return this.entries[segment];
    }

    @Override
    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        if (!this.segmented) {
            return this.publishSegmentKeys(k -> this.keyMatches(segments, filter, k), 0);
        }
        return Flowable.fromIterable((Iterable)segments).concatMap(segment -> this.publishSegmentKeys(filter, (int)segment));
    }

    private Publisher<K> publishSegmentKeys(Predicate<? super K> filter, int segment) {
        long stamp = this.resizeLock.tryReadLock();
        if (stamp != 0L) {
            return this.publishSegmentKeysWithReadLock(filter, segment, stamp);
        }
        return this.blockingManager.blockingPublisher(Flowable.defer(() -> {
            long stamp1 = this.resizeLock.readLock();
            return this.publishSegmentKeysWithReadLock(filter, segment, stamp1);
        }));
    }

    private boolean keyMatches(IntSet segments, Predicate<? super K> filter, K k) {
        return segments.contains(this.keyPartitioner.getSegment(k)) && (filter == null || filter.test(k));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Flowable<K> publishSegmentKeysWithReadLock(Predicate<? super K> filter, int segment, long stamp) {
        try {
            ArrayList<K> keys;
            Flowable segmentEntries = this.getSegmentEntries(segment);
            if (segmentEntries == null) {
                Flowable flowable = Flowable.empty();
                return flowable;
            }
            long now = this.ctx.getTimeService().wallClockTime();
            Flowable flowable = segmentEntries;
            synchronized (flowable) {
                keys = new ArrayList<K>(segmentEntries.size());
                for (Map.Entry<K, FileEntry> e : segmentEntries.entrySet()) {
                    K key = e.getKey();
                    if (e.getValue().isExpired(now) || filter != null && !filter.test(key)) continue;
                    keys.add(key);
                }
            }
            flowable = Flowable.fromIterable(keys);
            return flowable;
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
    }

    @Override
    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        if (!this.segmented) {
            return this.publishSegmentEntries(0, k -> this.keyMatches(segments, filter, k), includeValues);
        }
        return Flowable.fromIterable((Iterable)segments).concatMap(segment -> this.publishSegmentEntries((int)segment, filter, includeValues));
    }

    private Publisher<MarshallableEntry<K, V>> publishSegmentEntries(int segment, Predicate<? super K> filter, boolean includeValues) {
        long stamp = this.resizeLock.tryReadLock();
        if (stamp != 0L && this.getSegmentEntries(segment) == null) {
            this.resizeLock.unlockRead(stamp);
            return Flowable.empty();
        }
        return this.blockingManager.blockingPublisher(Flowable.defer(() -> this.blockingPublishSegmentEntries(segment, filter, includeValues, stamp)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Flowable<MarshallableEntry<K, V>> blockingPublishSegmentEntries(int segment, Predicate<? super K> filter, boolean includeValues, long stamp) {
        ArrayList<KeyValuePair> keysToLoad;
        long now = this.ctx.getTimeService().wallClockTime();
        if (stamp == 0L) {
            stamp = this.resizeLock.readLock();
        }
        try {
            Map<K, FileEntry> segmentEntries = this.getSegmentEntries(segment);
            if (segmentEntries == null) {
                Flowable flowable = Flowable.empty();
                return flowable;
            }
            Map<K, FileEntry> map = segmentEntries;
            synchronized (map) {
                keysToLoad = new ArrayList<KeyValuePair>(segmentEntries.size());
                for (Map.Entry<K, FileEntry> e : segmentEntries.entrySet()) {
                    if (e.getValue().isExpired(now) || filter != null && !filter.test(e.getKey())) continue;
                    keysToLoad.add(new KeyValuePair<K, FileEntry>(e.getKey(), e.getValue()));
                }
            }
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
        keysToLoad.sort(Comparator.comparingLong(o -> ((FileEntry)o.getValue()).offset));
        return Flowable.fromIterable(keysToLoad).map(kvp -> {
            MarshallableEntry<K, V> entry = this.blockingLoad(segment, kvp.getKey(), includeValues, true);
            if (entry == null) {
                entry = this.entryFactory.getEmpty();
            }
            return entry;
        }).filter(me -> me != this.entryFactory.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFreeEntries() {
        long stamp = this.resizeLock.readLock();
        try {
            SortedSet<FileEntry> sortedSet = this.freeList;
            synchronized (sortedSet) {
                ArrayList<FileEntry> l = new ArrayList<FileEntry>(this.freeList);
                l.sort(Comparator.comparingLong(fe -> -fe.offset));
                this.truncateFile(l);
                this.mergeFreeEntries(l);
            }
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
    }

    private void truncateFile(List<FileEntry> entries) {
        FileEntry fe;
        long startTime = 0L;
        if (log.isTraceEnabled()) {
            startTime = this.timeService.wallClockTime();
        }
        int reclaimedSpace = 0;
        int removedEntries = 0;
        long truncateOffset = -1L;
        ListIterator<FileEntry> it = entries.listIterator();
        while (it.hasNext() && !(fe = it.next()).isLocked() && fe.offset + (long)fe.size == this.filePos) {
            truncateOffset = fe.offset;
            this.filePos = fe.offset;
            this.freeList.remove(fe);
            it.set(null);
            reclaimedSpace += fe.size;
            ++removedEntries;
        }
        if (truncateOffset > 0L) {
            try {
                this.channel.truncate(truncateOffset);
            }
            catch (IOException e) {
                throw new PersistenceException("Error while truncating file", e);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Removed entries: %d, Reclaimed Space: %d, Free Entries %d", removedEntries, reclaimedSpace, this.freeList.size());
            log.tracef("Time taken for truncateFile: %d (ms)", this.timeService.wallClockTime() - startTime);
        }
    }

    private void mergeFreeEntries(List<FileEntry> entries) {
        long startTime = 0L;
        if (log.isTraceEnabled()) {
            startTime = this.timeService.wallClockTime();
        }
        FileEntry lastEntry = null;
        FileEntry newEntry = null;
        int mergeCounter = 0;
        for (FileEntry fe : entries) {
            if (fe == null || fe.isLocked()) continue;
            if (lastEntry != null && lastEntry.offset == fe.offset + (long)fe.size) {
                if (newEntry == null) {
                    newEntry = new FileEntry(fe.offset, fe.size + lastEntry.size);
                    this.freeList.remove(lastEntry);
                    ++mergeCounter;
                } else {
                    newEntry = new FileEntry(fe.offset, fe.size + newEntry.size);
                }
                this.freeList.remove(fe);
                ++mergeCounter;
            } else if (newEntry != null) {
                this.mergeAndLogEntry(newEntry, mergeCounter);
                newEntry = null;
                mergeCounter = 0;
            }
            lastEntry = fe;
        }
        if (newEntry != null) {
            this.mergeAndLogEntry(newEntry, mergeCounter);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Total time taken for mergeFreeEntries: " + (this.timeService.wallClockTime() - startTime) + " (ms)", new Object[0]);
        }
    }

    private void mergeAndLogEntry(FileEntry entry, int mergeCounter) {
        try {
            this.addNewFreeEntry(entry);
            if (log.isTraceEnabled()) {
                log.tracef("Merged %d entries at %d:%d, %d free entries", new Object[]{mergeCounter, entry.offset, entry.size, this.freeList.size()});
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Could not add new merged entry", e);
        }
    }

    @Override
    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        UnicastProcessor processor = UnicastProcessor.create();
        this.blockingManager.runBlocking(() -> this.blockingPurgeExpired(processor), "sfs-purgeExpired");
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingPurgeExpired(UnicastProcessor<MarshallableEntry<K, V>> processor) {
        try {
            long now = this.timeService.wallClockTime();
            for (int segment = 0; segment < this.actualNumSegments; ++segment) {
                List<KeyValuePair<Object, FileEntry>> entriesToPurge;
                long stamp = this.resizeLock.readLock();
                try {
                    Map<K, FileEntry> segmentEntries = this.getSegmentEntries(segment);
                    if (segmentEntries == null) continue;
                    entriesToPurge = this.collectExpiredEntries(now, segmentEntries);
                }
                finally {
                    this.resizeLock.unlockRead(stamp);
                }
                this.purgeExpiredEntries(now, processor, entriesToPurge);
            }
            this.processFreeEntries();
        }
        catch (Throwable t) {
            processor.onError(t);
        }
        finally {
            processor.onComplete();
        }
    }

    private void purgeExpiredEntries(long now, UnicastProcessor<MarshallableEntry<K, V>> processor, List<KeyValuePair<Object, FileEntry>> entriesToPurge) {
        entriesToPurge.sort(Comparator.comparingLong(kvp -> ((FileEntry)kvp.getValue()).offset));
        ListIterator<KeyValuePair<Object, FileEntry>> it = entriesToPurge.listIterator();
        while (it.hasNext()) {
            KeyValuePair<Object, FileEntry> next = it.next();
            FileEntry fe = next.getValue();
            if (!fe.isExpired(now)) continue;
            it.set(null);
            MarshallableEntry<K, V> entry = this.readFromDisk(fe, next.getKey(), true, true);
            processor.onNext(entry);
            try {
                this.free(fe);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="resizeLock")
    private List<KeyValuePair<Object, FileEntry>> collectExpiredEntries(long now, Map<K, FileEntry> segmentEntries) {
        ArrayList<KeyValuePair<Object, FileEntry>> entriesToPurge = new ArrayList<KeyValuePair<Object, FileEntry>>();
        Map<K, FileEntry> map = segmentEntries;
        synchronized (map) {
            Iterator<Map.Entry<K, FileEntry>> it = segmentEntries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, FileEntry> next = it.next();
                FileEntry fe = next.getValue();
                if (!fe.isExpired(now)) continue;
                it.remove();
                fe.lock();
                entriesToPurge.add(new KeyValuePair<K, FileEntry>(next.getKey(), fe));
            }
        }
        return entriesToPurge;
    }

    @Override
    public CompletionStage<Long> size(IntSet segments) {
        return Flowable.fromPublisher(this.publishKeys(segments, null)).count().toCompletionStage();
    }

    @Override
    public CompletionStage<Long> approximateSize(IntSet segments) {
        return this.blockingManager.supplyBlocking(() -> this.blockingApproximateSize(segments), "sfs-approximateSize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long blockingApproximateSize(IntSet segments) {
        long size = 0L;
        long stamp = this.resizeLock.readLock();
        try {
            if (!this.segmented) {
                long l = this.getSegmentEntries(0).size();
                return l;
            }
            PrimitiveIterator.OfInt iterator = segments.iterator();
            while (iterator.hasNext()) {
                int segment = iterator.next();
                Map<K, FileEntry> segmentEntries = this.getSegmentEntries(segment);
                if (segmentEntries == null) continue;
                size += (long)segmentEntries.size();
            }
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, FileEntry> getEntries() {
        long stamp = this.resizeLock.readLock();
        try {
            Map<Object, FileEntry> map = Arrays.stream(this.entries).flatMap(segmentEntries -> segmentEntries != null ? segmentEntries.entrySet().stream() : Stream.empty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return map;
        }
        finally {
            this.resizeLock.unlockRead(stamp);
        }
    }

    SortedSet<FileEntry> getFreeList() {
        return this.freeList;
    }

    long getFileSize() {
        return this.filePos;
    }

    public SingleFileStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public CompletionStage<Void> addSegments(IntSet segments) {
        if (!this.segmented) {
            throw new UnsupportedOperationException();
        }
        return this.blockingManager.runBlocking(() -> this.blockingAddSegments(segments), "sfs-addSegments");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingAddSegments(IntSet segments) {
        long stamp = this.resizeLock.writeLock();
        try {
            PrimitiveIterator.OfInt ofInt = segments.iterator();
            while (ofInt.hasNext()) {
                int segment = (Integer)ofInt.next();
                if (this.entries[segment] != null) continue;
                HashMap entryMap = this.configuration.maxEntries() > 0 ? new LinkedHashMap(16, 0.75f, true) : new HashMap();
                this.entries[segment] = Collections.synchronizedMap(entryMap);
            }
        }
        finally {
            this.resizeLock.unlockWrite(stamp);
        }
    }

    @Override
    public CompletionStage<Void> removeSegments(IntSet segments) {
        if (!this.segmented) {
            throw new UnsupportedOperationException();
        }
        return this.blockingManager.runBlocking(() -> this.blockingRemoveSegments(segments), "sfs-removeSegments");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingRemoveSegments(IntSet segments) {
        ArrayList<Map<K, FileEntry>> removedSegments = new ArrayList<Map<K, FileEntry>>(segments.size());
        long stamp = this.resizeLock.writeLock();
        try {
            Iterator<Integer> iterator = segments.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (this.entries[n] == null) continue;
                removedSegments.add(this.entries[n]);
                this.entries[n] = null;
            }
        }
        finally {
            this.resizeLock.unlockWrite(stamp);
        }
        try {
            for (Map map : removedSegments) {
                for (FileEntry fileEntry : map.values()) {
                    this.free(fileEntry);
                }
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        this.processFreeEntries();
    }

    private static class FileEntry
    implements Comparable<FileEntry> {
        final long offset;
        final int size;
        final int keyLen;
        final int dataLen;
        final int metadataLen;
        final int internalMetadataLen;
        final long expiryTime;
        transient int readers = 0;

        FileEntry(long offset, java.nio.ByteBuffer buf) {
            this.offset = offset;
            this.size = buf.getInt();
            this.keyLen = buf.getInt();
            this.dataLen = buf.getInt();
            this.metadataLen = buf.getInt();
            this.internalMetadataLen = buf.getInt();
            this.expiryTime = buf.getLong();
        }

        FileEntry(long offset, int size) {
            this(offset, size, 0, 0, 0, 0, -1L);
        }

        FileEntry(long offset, int size, int keyLen, int dataLen, int metadataLen, int internalMetadataLen, long expiryTime) {
            this.offset = offset;
            this.size = size;
            this.keyLen = keyLen;
            this.dataLen = dataLen;
            this.metadataLen = metadataLen;
            this.internalMetadataLen = internalMetadataLen;
            this.expiryTime = expiryTime;
        }

        synchronized boolean isLocked() {
            return this.readers > 0;
        }

        synchronized void lock() {
            ++this.readers;
        }

        synchronized void unlock() {
            --this.readers;
            if (this.readers == 0) {
                this.notifyAll();
            }
        }

        synchronized void waitUnlocked() {
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        boolean isExpired(long now) {
            return this.expiryTime > 0L && this.expiryTime < now;
        }

        int actualSize() {
            return 28 + this.keyLen + this.dataLen + this.metadataLen + this.internalMetadataLen;
        }

        void writeToBuf(java.nio.ByteBuffer buf) {
            buf.putInt(this.size);
            buf.putInt(this.keyLen);
            buf.putInt(this.dataLen);
            buf.putInt(this.metadataLen);
            buf.putInt(this.internalMetadataLen);
            buf.putLong(this.expiryTime);
        }

        @Override
        public int compareTo(FileEntry fe) {
            int diff = this.size - fe.size;
            if (diff != 0) {
                return diff;
            }
            return Long.compare(this.offset, fe.offset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileEntry fileEntry = (FileEntry)o;
            if (this.offset != fileEntry.offset) {
                return false;
            }
            return this.size == fileEntry.size;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.size;
            return result;
        }

        public String toString() {
            return "FileEntry@" + this.offset + "{size=" + this.size + ", actual=" + this.actualSize() + '}';
        }
    }
}

