/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;

public class SingleXSiteRpcCommand
extends XSiteReplicateCommand<Object> {
    public static final byte COMMAND_ID = 40;
    private ReplicableCommand command;

    public SingleXSiteRpcCommand(ByteString cacheName, ReplicableCommand command) {
        super((byte)40, cacheName);
        this.command = command;
    }

    public SingleXSiteRpcCommand(ByteString cacheName) {
        this(cacheName, null);
    }

    public SingleXSiteRpcCommand() {
        this(null);
    }

    @Override
    public CompletionStage<Object> performInLocalSite(ComponentRegistry registry, boolean preserveOrder) {
        if (this.command instanceof VisitableCommand) {
            return super.performInLocalSite(registry, preserveOrder);
        }
        try {
            return ((CacheRpcCommand)this.command).invokeAsync(registry);
        }
        catch (Throwable throwable) {
            return CompletableFutures.completedExceptionFuture(throwable);
        }
    }

    @Override
    public CompletionStage<Object> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        return receiver.handleRemoteCommand((VisitableCommand)this.command, preserveOrder);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.command);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.command = (ReplicableCommand)input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.command.isReturnValueExpected();
    }

    @Override
    public String toString() {
        return "SingleXSiteRpcCommand{command=" + this.command + '}';
    }
}

