/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxCompletionNotificationCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    private static final Log log = LogFactory.getLog(TxCompletionNotificationCommand.class);
    public static final int COMMAND_ID = 22;
    private XidImpl xid;
    private long internalId;
    private GlobalTransaction gtx;
    private int topologyId = -1;

    private TxCompletionNotificationCommand() {
        super(null);
    }

    public TxCompletionNotificationCommand(XidImpl xid, GlobalTransaction gtx, ByteString cacheName) {
        super(cacheName);
        this.xid = xid;
        this.gtx = gtx;
    }

    public TxCompletionNotificationCommand(long internalId, ByteString cacheName) {
        super(cacheName);
        this.internalId = internalId;
    }

    public TxCompletionNotificationCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Processing completed transaction %s", this.gtx);
        }
        RemoteTransaction remoteTx = null;
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        if (recoveryManager != null) {
            remoteTx = this.xid != null ? (RemoteTransaction)((Object)recoveryManager.removeRecoveryInformation(this.xid)) : (RemoteTransaction)((Object)recoveryManager.removeRecoveryInformation(this.internalId));
        }
        if (remoteTx == null && this.gtx != null) {
            TransactionTable txTable = componentRegistry.getTransactionTableRef().running();
            remoteTx = txTable.removeRemoteTransaction(this.gtx);
        }
        if (remoteTx == null) {
            return CompletableFutures.completedNull();
        }
        this.forwardCommandRemotely(componentRegistry.getStateTransferManager(), remoteTx);
        LockManager lockManager = componentRegistry.getLockManager().running();
        lockManager.unlockAll(remoteTx.getLockedKeys(), remoteTx.getGlobalTransaction());
        return CompletableFutures.completedNull();
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.gtx;
    }

    private void forwardCommandRemotely(StateTransferManager stateTransferManager, RemoteTransaction remoteTx) {
        Set<Object> affectedKeys = remoteTx.getAffectedKeys();
        if (log.isTraceEnabled()) {
            log.tracef("Invoking forward of TxCompletionNotification for transaction %s. Affected keys: %s", this.gtx, Util.toStr(affectedKeys));
        }
        stateTransferManager.forwardCommandIfNeeded(this, affectedKeys, remoteTx.getGlobalTransaction().getAddress());
    }

    @Override
    public byte getCommandId() {
        return 22;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        if (this.xid == null) {
            output.writeBoolean(true);
            output.writeLong(this.internalId);
        } else {
            output.writeBoolean(false);
            XidImpl.writeTo((ObjectOutput)output, (XidImpl)this.xid);
        }
        output.writeObject(this.gtx);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        if (input.readBoolean()) {
            this.internalId = input.readLong();
        } else {
            this.xid = XidImpl.readFrom((ObjectInput)input);
        }
        this.gtx = (GlobalTransaction)input.readObject();
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + this.xid + ", internalId=" + this.internalId + ", topologyId=" + this.topologyId + ", gtx=" + this.gtx + ", cacheName=" + this.cacheName + "} ";
    }
}

