/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.impl;

import java.util.List;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ScatteredPartitionHandlingManagerImpl
extends PartitionHandlingManagerImpl {
    private static final Log log = LogFactory.getLog(ScatteredPartitionHandlingManagerImpl.class);

    @Override
    public void doCheck(Object key, boolean isWrite, long flagBitSet) {
        AvailabilityMode availabilityMode = this.getAvailabilityMode();
        if (log.isTraceEnabled()) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)availabilityMode);
        }
        if (availabilityMode == AvailabilityMode.AVAILABLE) {
            return;
        }
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (this.isKeyOperationAllowed(isWrite, flagBitSet, cacheTopology, key)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Partition is in %s mode, access is not allowed for key %s", (Object)availabilityMode, key);
        }
        throw Log.CONTAINER.degradedModeKeyUnavailable(key);
    }

    @Override
    protected boolean isKeyOperationAllowed(boolean isWrite, long flagBitSet, LocalizedCacheTopology cacheTopology, Object key) {
        if (this.getAvailabilityMode() == AvailabilityMode.AVAILABLE) {
            return true;
        }
        List<Address> actualMembers = cacheTopology.getActualMembers();
        switch (this.getPartitionHandling()) {
            case ALLOW_READ_WRITES: {
                return true;
            }
            case ALLOW_READS: {
                if (isWrite || EnumUtil.containsAny((long)flagBitSet, (long)FlagBitSets.FORCE_WRITE_LOCK)) {
                    return false;
                }
                return actualMembers.contains(cacheTopology.getDistribution(key).primary());
            }
        }
        return false;
    }
}

