/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.interceptors.distribution.Collector;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.TriangleFunctionsUtil;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleDistributionInterceptor
extends BaseDistributionInterceptor {
    private static final Log log = LogFactory.getLog(TriangleDistributionInterceptor.class);
    @Inject
    CommandAckCollector commandAckCollector;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    TriangleOrderManager triangleOrderManager;
    private Address localAddress;

    @Start
    public void start() {
        this.localAddress = this.rpcManager.getAddress();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return ctx.isOriginLocal() ? this.handleLocalManyKeysCommand(ctx, command, TriangleFunctionsUtil::copy, TriangleFunctionsUtil::mergeHashMap, HashMap::new, TriangleFunctionsUtil::backupFrom) : this.handleRemoteManyKeysCommand(ctx, command, PutMapCommand::isForwarded, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return ctx.isOriginLocal() ? this.handleLocalManyKeysCommand(ctx, command, TriangleFunctionsUtil::copy, TriangleFunctionsUtil::voidMerge, () -> null, TriangleFunctionsUtil::backupFrom) : this.handleRemoteManyKeysCommand(ctx, command, AbstractWriteManyCommand::isForwarded, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return ctx.isOriginLocal() ? this.handleLocalManyKeysCommand(ctx, command, TriangleFunctionsUtil::copy, TriangleFunctionsUtil::voidMerge, () -> null, TriangleFunctionsUtil::backupFrom) : this.handleRemoteManyKeysCommand(ctx, command, AbstractWriteManyCommand::isForwarded, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return ctx.isOriginLocal() ? this.handleLocalManyKeysCommand(ctx, command, TriangleFunctionsUtil::copy, TriangleFunctionsUtil::mergeList, LinkedList::new, TriangleFunctionsUtil::backupFrom) : this.handleRemoteManyKeysCommand(ctx, command, ReadWriteManyCommand::isForwarded, TriangleFunctionsUtil::backupFrom);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return ctx.isOriginLocal() ? this.handleLocalManyKeysCommand(ctx, command, TriangleFunctionsUtil::copy, TriangleFunctionsUtil::mergeList, LinkedList::new, TriangleFunctionsUtil::backupFrom) : this.handleRemoteManyKeysCommand(ctx, command, ReadWriteManyEntriesCommand::isForwarded, TriangleFunctionsUtil::backupFrom);
    }

    private <R, C extends WriteCommand> Object handleLocalManyKeysCommand(InvocationContext ctx, C command, SubsetCommandCopy<C> commandCopy, MergeResults<R> mergeResults, Supplier<R> emptyResult, MultiKeyBackupBuilder<C> backupBuilder) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        PrimaryOwnerClassifier filter = new PrimaryOwnerClassifier(cacheTopology, command.getAffectedKeys());
        return this.isSynchronous(command) ? this.syncLocalManyKeysWrite(ctx, command, cacheTopology, filter, commandCopy, mergeResults, emptyResult, backupBuilder) : this.asyncLocalManyKeysWrite(ctx, command, cacheTopology, filter, commandCopy, backupBuilder);
    }

    private <C extends WriteCommand> Object handleRemoteManyKeysCommand(InvocationContext ctx, C command, Predicate<C> isBackup, MultiKeyBackupBuilder<C> backupBuilder) {
        return isBackup.test(command) ? this.remoteBackupManyKeysWrite(ctx, command, InfinispanCollections.toObjectSet(command.getAffectedKeys())) : this.remotePrimaryManyKeysWrite(ctx, command, InfinispanCollections.toObjectSet(command.getAffectedKeys()), backupBuilder);
    }

    private <C extends WriteCommand> Object remoteBackupManyKeysWrite(InvocationContext ctx, C command, Set<Object> keys) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        return this.asyncInvokeNext(ctx, command, this.checkRemoteGetIfNeeded(ctx, command, keys, cacheTopology, command.loadType() == VisitableCommand.LoadType.OWNER));
    }

    private <C extends WriteCommand> Object remotePrimaryManyKeysWrite(InvocationContext ctx, C command, Set<Object> keys, MultiKeyBackupBuilder<C> backupBuilder) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        this.sendToBackups(command, keys, cacheTopology, backupBuilder);
        return this.asyncInvokeNext(ctx, command, this.checkRemoteGetIfNeeded(ctx, command, keys, cacheTopology, command.loadType() == VisitableCommand.LoadType.OWNER));
    }

    private <R, C extends WriteCommand> Object syncLocalManyKeysWrite(InvocationContext ctx, C command, LocalizedCacheTopology cacheTopology, PrimaryOwnerClassifier filter, SubsetCommandCopy<C> commandCopy, MergeResults<R> mergeResults, Supplier<R> emptyResult, MultiKeyBackupBuilder<C> backupBuilder) {
        Set localKeys = (Set)filter.primaries.remove(this.localAddress);
        Collector collector = this.commandAckCollector.createSegmentBasedCollector(command.getCommandInvocationId().getId(), filter.backups, command.getTopologyId());
        CompletableFuture<Object> localResult = new CompletableFuture<Object>();
        this.forwardToPrimaryOwners(command, filter, localResult, mergeResults, commandCopy).handle((result, throwable) -> {
            if (throwable != null) {
                collector.primaryException((Throwable)throwable);
            } else {
                collector.primaryResult(result, true);
            }
            return null;
        });
        if (localKeys != null) {
            return TriangleDistributionInterceptor.makeStage(this.invokeNextWriteManyKeysInPrimary(ctx, command, localKeys, cacheTopology, commandCopy, backupBuilder)).andHandle(ctx, command, (rCtx, rCommand, rv, throwable) -> {
                if (throwable != null) {
                    localResult.completeExceptionally(CompletableFutures.extractException(throwable));
                } else {
                    localResult.complete(rv);
                }
                return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
            });
        }
        localResult.complete(command.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? null : (Object)emptyResult.get());
        return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
    }

    private <C extends WriteCommand> Object asyncLocalManyKeysWrite(InvocationContext ctx, C command, LocalizedCacheTopology cacheTopology, PrimaryOwnerClassifier filter, SubsetCommandCopy<C> commandCopy, MultiKeyBackupBuilder<C> backupBuilder) {
        Set localKeys = (Set)filter.primaries.remove(this.localAddress);
        this.forwardToPrimaryOwners(command, filter, commandCopy);
        return localKeys != null ? this.invokeNextWriteManyKeysInPrimary(ctx, command, localKeys, cacheTopology, commandCopy, backupBuilder) : null;
    }

    private <C extends WriteCommand> Object invokeNextWriteManyKeysInPrimary(InvocationContext ctx, C command, Set<Object> keys, LocalizedCacheTopology cacheTopology, SubsetCommandCopy<C> commandCopy, MultiKeyBackupBuilder<C> backupBuilder) {
        VisitableCommand.LoadType loadType = command.loadType();
        this.sendToBackups(command, keys, cacheTopology, backupBuilder);
        WriteCommand primaryCmd = (WriteCommand)commandCopy.copySubset(command, keys);
        return this.asyncInvokeNext(ctx, (VisitableCommand)primaryCmd, this.checkRemoteGetIfNeeded(ctx, primaryCmd, keys, cacheTopology, loadType == VisitableCommand.LoadType.PRIMARY || loadType == VisitableCommand.LoadType.OWNER));
    }

    private <C extends WriteCommand> void sendToBackups(C command, Collection<Object> keysToSend, LocalizedCacheTopology cacheTopology, MultiKeyBackupBuilder<C> backupBuilder) {
        int topologyId = command.getTopologyId();
        for (Map.Entry<Integer, Collection<Object>> entry : TriangleFunctionsUtil.filterBySegment(cacheTopology, keysToSend).entrySet()) {
            int segmentId = entry.getKey();
            Collection<Address> backups = cacheTopology.getDistributionForSegment(segmentId).writeBackups();
            if (backups.isEmpty()) continue;
            long sequence = this.triangleOrderManager.next(segmentId, topologyId);
            BackupWriteCommand backupCommand = backupBuilder.build(this.commandsFactory, command, entry.getValue());
            backupCommand.setSequence(sequence);
            backupCommand.setSegmentId(segmentId);
            if (log.isTraceEnabled()) {
                log.tracef("Command %s got sequence %s for segment %s", command.getCommandInvocationId(), segmentId, sequence);
            }
            this.rpcManager.sendToMany(backups, backupCommand, DeliverOrder.NONE);
        }
    }

    private <C extends WriteCommand> void forwardToPrimaryOwners(C command, PrimaryOwnerClassifier splitter, SubsetCommandCopy<C> commandCopy) {
        for (Map.Entry entry : splitter.primaries.entrySet()) {
            WriteCommand copy = (WriteCommand)commandCopy.copySubset(command, (Collection)entry.getValue());
            copy.setTopologyId(command.getTopologyId());
            this.rpcManager.sendTo((Address)entry.getKey(), copy, DeliverOrder.NONE);
        }
    }

    private <R, C extends WriteCommand> CompletableFuture<R> forwardToPrimaryOwners(C command, PrimaryOwnerClassifier splitter, CompletableFuture<R> localResult, MergeResults<R> mergeResults, SubsetCommandCopy<C> commandCopy) {
        CompletionStage<Object> future = localResult;
        for (Map.Entry entry : splitter.primaries.entrySet()) {
            WriteCommand copy = (WriteCommand)commandCopy.copySubset(command, (Collection)entry.getValue());
            copy.setTopologyId(command.getTopologyId());
            CompletionStage<ValidResponse> remoteFuture = this.rpcManager.invokeCommand((Address)entry.getKey(), (ReplicableCommand)copy, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
            future = remoteFuture.toCompletableFuture().thenCombine(future, mergeResults);
        }
        return future;
    }

    private <C extends DataWriteCommand> Object handleSingleKeyWriteCommand(InvocationContext context, C command, BackupBuilder<C> backupBuilder) {
        assert (!context.isInTxScope());
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            return this.invokeNext(context, command);
        }
        LocalizedCacheTopology topology = this.checkTopologyId(command);
        DistributionInfo distributionInfo = topology.getDistributionForSegment(command.getSegment());
        if (distributionInfo.isPrimary()) {
            assert (context.lookupEntry(command.getKey()) != null);
            return context.isOriginLocal() ? this.localPrimaryOwnerWrite(context, command, distributionInfo, backupBuilder) : this.remotePrimaryOwnerWrite(context, command, distributionInfo, backupBuilder);
        }
        if (distributionInfo.isWriteBackup()) {
            return context.isOriginLocal() ? this.localWriteInvocation(context, command, distributionInfo) : this.remoteBackupOwnerWrite(context, command);
        }
        assert (context.isOriginLocal());
        return this.localWriteInvocation(context, command, distributionInfo);
    }

    private Object remoteBackupOwnerWrite(InvocationContext context, DataWriteCommand command) {
        CacheEntry entry = context.lookupEntry(command.getKey());
        if (entry == null) {
            if (command.loadType() == VisitableCommand.LoadType.OWNER) {
                return this.asyncInvokeNext(context, (VisitableCommand)command, this.remoteGetSingleKey(context, command, command.getKey(), true));
            }
            this.entryFactory.wrapExternalEntry(context, command.getKey(), null, false, true);
        }
        return this.invokeNext(context, command);
    }

    private <C extends DataWriteCommand> Object localPrimaryOwnerWrite(InvocationContext context, C command, DistributionInfo distributionInfo, BackupBuilder<C> backupBuilder) {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
        }
        return this.invokeNextThenApply(context, command, (rCtx, rCommand, rv) -> {
            DataWriteCommand dwCommand = rCommand;
            CommandInvocationId id = dwCommand.getCommandInvocationId();
            Collection<Address> backupOwners = distributionInfo.writeBackups();
            if (!dwCommand.isSuccessful() || backupOwners.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Command %s not successful in primary owner.", id);
                }
                return rv;
            }
            int topologyId = dwCommand.getTopologyId();
            boolean sync = this.isSynchronous(dwCommand);
            if (sync || dwCommand.isReturnValueExpected()) {
                Collector<Object> collector = this.commandAckCollector.create(id.getId(), sync ? backupOwners : Collections.emptyList(), topologyId);
                this.checkTopologyId(topologyId, collector);
                collector.primaryResult(rv, true);
                this.sendToBackups(distributionInfo.segmentId(), dwCommand, backupOwners, backupBuilder);
                return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
            }
            this.sendToBackups(distributionInfo.segmentId(), dwCommand, backupOwners, backupBuilder);
            return rv;
        });
    }

    private <C extends DataWriteCommand> Object remotePrimaryOwnerWrite(InvocationContext context, C command, DistributionInfo distributionInfo, BackupBuilder<C> backupBuilder) {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
        }
        return this.invokeNextThenApply(context, command, (rCtx, rCommand, rv) -> {
            DataWriteCommand dwCommand = rCommand;
            CommandInvocationId id = dwCommand.getCommandInvocationId();
            Collection<Address> backupOwners = distributionInfo.writeBackups();
            if (!dwCommand.isSuccessful() || backupOwners.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Command %s not successful in primary owner.", id);
                }
                return rv;
            }
            this.sendToBackups(distributionInfo.segmentId(), dwCommand, backupOwners, backupBuilder);
            return rv;
        });
    }

    private <C extends DataWriteCommand> void sendToBackups(int segmentId, C command, Collection<Address> backupOwners, BackupBuilder<C> backupBuilder) {
        CommandInvocationId id = command.getCommandInvocationId();
        if (log.isTraceEnabled()) {
            log.tracef("Command %s send to backup owner %s.", id, backupOwners);
        }
        long sequenceNumber = this.triangleOrderManager.next(segmentId, command.getTopologyId());
        BackupWriteCommand backupCommand = backupBuilder.build(this.commandsFactory, command);
        backupCommand.setSequence(sequenceNumber);
        backupCommand.setSegmentId(segmentId);
        if (log.isTraceEnabled()) {
            log.tracef("Command %s got sequence %s for segment %s", id, sequenceNumber, segmentId);
        }
        this.rpcManager.sendToMany(backupOwners, backupCommand, DeliverOrder.NONE);
    }

    private Object localWriteInvocation(InvocationContext context, DataWriteCommand command, DistributionInfo distributionInfo) {
        assert (context.isOriginLocal());
        CommandInvocationId invocationId = command.getCommandInvocationId();
        boolean sync = this.isSynchronous(command);
        if (sync || command.isReturnValueExpected() && !command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            int topologyId = command.getTopologyId();
            Collector<Object> collector = this.commandAckCollector.create(invocationId.getId(), sync ? distributionInfo.writeBackups() : Collections.emptyList(), topologyId);
            this.checkTopologyId(topologyId, collector);
            this.forwardToPrimary(command, distributionInfo, collector);
            return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
        }
        this.rpcManager.sendTo(distributionInfo.primary(), command, DeliverOrder.NONE);
        return null;
    }

    private void forwardToPrimary(DataWriteCommand command, DistributionInfo distributionInfo, Collector<Object> collector) {
        CompletionStage<ValidResponse> remoteInvocation = this.rpcManager.invokeCommand(distributionInfo.primary(), (ReplicableCommand)command, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
        remoteInvocation.handle((response, throwable) -> {
            if (throwable != null) {
                collector.primaryException(CompletableFutures.extractException(throwable));
            } else {
                if (!response.isSuccessful()) {
                    command.fail();
                }
                collector.primaryResult(response.getResponseValue(), response.isSuccessful());
            }
            return null;
        });
    }

    private <C extends FlagAffectedCommand & TopologyAffectedCommand> CompletionStage<?> checkRemoteGetIfNeeded(InvocationContext ctx, C command, Set<Object> keys, LocalizedCacheTopology cacheTopology, boolean needsPreviousValue) {
        ArrayList<Object> remoteKeys = null;
        for (Object key : keys) {
            CacheEntry cacheEntry = ctx.lookupEntry(key);
            if (cacheEntry != null || !cacheTopology.isWriteOwner(key)) continue;
            if (!needsPreviousValue || command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.CACHE_MODE_LOCAL)) {
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
                continue;
            }
            if (remoteKeys == null) {
                remoteKeys = new ArrayList<Object>();
            }
            remoteKeys.add(key);
        }
        return remoteKeys != null ? this.remoteGetMany(ctx, command, (Collection<?>)remoteKeys) : CompletableFutures.completedNull();
    }

    private void checkTopologyId(int topologyId, Collector<?> collector) {
        int currentTopologyId = this.distributionManager.getCacheTopology().getTopologyId();
        if (currentTopologyId != topologyId && topologyId != -1) {
            collector.primaryException((Throwable)((Object)OutdatedTopologyException.RETRY_NEXT_TOPOLOGY));
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
    }

    private static class PrimaryOwnerClassifier {
        private final Map<Address, Collection<Integer>> backups;
        private final Map<Address, Set<Object>> primaries;
        private final LocalizedCacheTopology cacheTopology;
        private final int entryCount;

        private PrimaryOwnerClassifier(LocalizedCacheTopology cacheTopology, Collection<?> keys) {
            this.cacheTopology = cacheTopology;
            int memberSize = cacheTopology.getMembers().size();
            this.backups = new HashMap<Address, Collection<Integer>>(memberSize);
            this.primaries = new HashMap<Address, Set<Object>>(memberSize);
            HashSet distinctKeys = new HashSet(keys);
            this.entryCount = distinctKeys.size();
            distinctKeys.forEach(this::check);
        }

        private void check(Object key) {
            int segment = this.cacheTopology.getSegment(key);
            DistributionInfo distributionInfo = this.cacheTopology.getDistributionForSegment(segment);
            Address primaryOwner = distributionInfo.primary();
            this.primaries.computeIfAbsent(primaryOwner, address -> new HashSet(this.entryCount)).add(key);
            for (Address backup : distributionInfo.writeBackups()) {
                this.backups.computeIfAbsent(backup, address -> new HashSet(this.entryCount)).add(segment);
            }
        }
    }

    private static interface MultiKeyBackupBuilder<C> {
        public BackupWriteCommand build(CommandsFactory var1, C var2, Collection<Object> var3);
    }

    private static interface BackupBuilder<C> {
        public BackupWriteCommand build(CommandsFactory var1, C var2);
    }

    private static interface MergeResults<T>
    extends BiFunction<ValidResponse, T, T> {
    }

    private static interface SubsetCommandCopy<T> {
        public T copySubset(T var1, Collection<Object> var2);
    }
}

