/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.AllowListConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.CacheParser;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.configuration.parsing.XMLResourceResolver;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.BuiltinJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.CommonNameRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.util.logging.Log;
import org.jgroups.conf.ProtocolConfiguration;

@Namespaces(value={@Namespace(root="infinispan"), @Namespace(uri="urn:infinispan:config:*", root="infinispan")})
public class Parser
extends CacheParser {
    public static final String NAMESPACE = "urn:infinispan:config:";

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, holder);
                    continue block5;
                }
                case JGROUPS: {
                    this.addJGroupsDefaultStacksIfNeeded(reader, holder);
                    this.parseJGroups(reader, holder);
                    continue block5;
                }
                case THREADS: {
                    this.parseThreads(reader, holder);
                    continue block5;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseSerialization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                case VERSION: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    Log.CONFIG.advancedExternalizerDeprecated();
                    this.parseAdvancedExternalizer(reader, holder.getClassLoader(), builder.serialization());
                    continue block11;
                }
                case SERIALIZATION_CONTEXT_INITIALIZER: {
                    this.parseSerializationContextInitializer(reader, holder.getClassLoader(), builder.serialization());
                    continue block11;
                }
                case WHITE_LIST: {
                    if (reader.getSchema().since(12, 0)) {
                        throw ParseUtils.elementRemoved(reader, Element.ALLOW_LIST.getLocalName());
                    }
                    Log.CONFIG.elementDeprecatedUseOther(Element.WHITE_LIST, Element.ALLOW_LIST);
                }
                case ALLOW_LIST: {
                    if (reader.getSchema().since(10, 0)) {
                        this.parseAllowList(reader, builder.serialization().allowList());
                        continue block11;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSerializationContextInitializer(XMLExtendedStreamReader reader, ClassLoader classLoader, SerializationConfigurationBuilder builder) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    builder.addContextInitializer((SerializationContextInitializer)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAllowList(XMLExtendedStreamReader reader, AllowListConfigurationBuilder builder) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLASS: {
                    builder.addClass(reader.getElementText());
                    continue block4;
                }
                case REGEX: {
                    builder.addRegexp(reader.getElementText());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAdvancedExternalizer(XMLExtendedStreamReader reader, ClassLoader classLoader, SerializationConfigurationBuilder builder) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        AdvancedExternalizer advancedExternalizer = null;
        Integer id = null;
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        block4: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    advancedExternalizer = (AdvancedExternalizer)Util.getInstance((String)value, (ClassLoader)classLoader);
                    continue block4;
                }
                case ID: {
                    id = Integer.valueOf(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (id != null) {
            builder.addAdvancedExternalizer(id, advancedExternalizer);
        } else {
            builder.addAdvancedExternalizer(advancedExternalizer);
        }
    }

    private void parseThreads(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader, holder);
                    continue block7;
                }
                case CACHED_THREAD_POOL: {
                    this.parseCachedThreadPool(reader, holder);
                    continue block7;
                }
                case SCHEDULED_THREAD_POOL: {
                    this.parseScheduledThreadPool(reader, holder);
                    continue block7;
                }
                case BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseBoundedQueueThreadPool(reader, holder, false);
                    continue block7;
                }
                case NON_BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseBoundedQueueThreadPool(reader, holder, true);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseBoundedQueueThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean isNonBlocking) throws XMLStreamException {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String name = null;
        String threadFactoryName = null;
        int maxThreads = 0;
        int coreThreads = 0;
        int queueLength = 0;
        long keepAlive = 0L;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block8;
                }
                case CORE_THREADS: {
                    coreThreads = Integer.parseInt(value);
                    continue block8;
                }
                case MAX_THREADS: {
                    maxThreads = Integer.parseInt(value);
                    continue block8;
                }
                case QUEUE_LENGTH: {
                    queueLength = Integer.parseInt(value);
                    continue block8;
                }
                case KEEP_ALIVE_TIME: {
                    keepAlive = Long.parseLong(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        threadsBuilder.addBoundedThreadPool(name).threadFactory(threadFactoryName).coreThreads(coreThreads).maxThreads(maxThreads).queueLength(queueLength).keepAliveTime(keepAlive).nonBlocking(isNonBlocking);
        ParseUtils.requireNoContent(reader);
    }

    private void parseScheduledThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String name = null;
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        threadsBuilder.addScheduledThreadPool(name).threadFactory(threadFactoryName);
        ParseUtils.requireNoContent(reader);
    }

    private void parseCachedThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String name = null;
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        threadsBuilder.addCachedThreadPool(name).threadFactory(threadFactoryName);
        ParseUtils.requireNoContent(reader);
    }

    private void parseThreadFactory(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = null;
        String threadGroupName = null;
        String threadNamePattern = null;
        int priority = 1;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                case GROUP_NAME: {
                    threadGroupName = value;
                    continue block6;
                }
                case THREAD_NAME_PATTERN: {
                    threadNamePattern = value;
                    continue block6;
                }
                case PRIORITY: {
                    priority = Integer.parseInt(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        holder.getGlobalConfigurationBuilder().threads().addThreadFactory(name).groupName(threadGroupName).priority(priority).threadNamePattern(threadNamePattern);
        ParseUtils.requireNoContent(reader);
    }

    private void parseJGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Transport transport = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TRANSPORT: {
                    transport = (Transport)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (transport == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        } else {
            holder.getGlobalConfigurationBuilder().transport().transport(transport);
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK_FILE: {
                    this.parseStackFile(reader, holder);
                    continue block8;
                }
                case STACK: {
                    if (!reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    this.parseJGroupsStack(reader, holder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void addJGroupsStackFile(ConfigurationBuilderHolder holder, String name, String path, Properties properties, XMLResourceResolver resourceResolver) {
        URL url = FileLookupFactory.newInstance().lookupFileLocation(path, holder.getClassLoader());
        try (InputStream xml = (url != null ? url : resourceResolver.resolveResource(path)).openStream();){
            holder.addJGroupsStack(new FileJGroupsChannelConfigurator(name, path, xml, properties));
        }
        catch (FileNotFoundException e) {
            throw Log.CONFIG.jgroupsConfigurationNotFound(path);
        }
        catch (IOException e) {
            throw Log.CONFIG.unableToAddJGroupsStack(name, e);
        }
    }

    private void parseJGroupsStack(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String stackName = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME)[0];
        EmbeddedJGroupsChannelConfigurator stackConfigurator = new EmbeddedJGroupsChannelConfigurator(stackName);
        String extend = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block7;
                }
                case EXTENDS: {
                    extend = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        List<ProtocolConfiguration> stack = stackConfigurator.getProtocolStack();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITES: {
                    this.parseJGroupsRelay(reader, holder, stackConfigurator);
                    continue block8;
                }
            }
            String protocolName = reader.getLocalName();
            HashMap<String, String> protocolAttributes = new HashMap<String, String>();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                protocolAttributes.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
            ParseUtils.requireNoContent(reader);
            stack.add(new ProtocolConfiguration(protocolName, protocolAttributes));
        }
        holder.addJGroupsStack(stackConfigurator, extend);
    }

    private void parseJGroupsRelay(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, EmbeddedJGroupsChannelConfigurator stackConfigurator) throws XMLStreamException {
        String defaultStack = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.DEFAULT_STACK);
        if (holder.getJGroupsStack(defaultStack) == null) {
            throw Log.CONFIG.missingJGroupsStack(defaultStack);
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    String remoteSite = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME)[0];
                    String stack = defaultStack;
                    block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                continue block8;
                            }
                            case STACK: {
                                stack = reader.getAttributeValue(i);
                                if (holder.getJGroupsStack(stack) != null) continue block8;
                                throw Log.CONFIG.missingJGroupsStack(stack);
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    stackConfigurator.addRemoteSite(remoteSite, holder.getJGroupsStack(stack));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseStackFile(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME, Attribute.PATH);
        ParseUtils.requireNoContent(reader);
        this.addJGroupsStackFile(holder, attributes[0], attributes[1], reader.getProperties(), reader.getResourceResolver());
    }

    private void parseContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.pushScope(ParserScope.CACHE_CONTAINER);
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block33: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    builder.cacheManagerName(value);
                    continue block33;
                }
                case DEFAULT_CACHE: {
                    builder.defaultCacheName(value);
                    continue block33;
                }
                case ALIASES: 
                case JNDI_NAME: 
                case MODULE: 
                case START: 
                case ASYNC_EXECUTOR: 
                case PERSISTENCE_EXECUTOR: 
                case STATE_TRANSFER_EXECUTOR: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block33;
                }
                case LISTENER_EXECUTOR: {
                    builder.listenerThreadPoolName(value);
                    builder.listenerThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.notification", holder));
                    continue block33;
                }
                case EVICTION_EXECUTOR: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.evictionExecutorDeprecated();
                }
                case EXPIRATION_EXECUTOR: {
                    builder.expirationThreadPoolName(value);
                    builder.expirationThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.expiration", holder));
                    continue block33;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block33;
                }
                case NON_BLOCKING_EXECUTOR: {
                    builder.nonBlockingThreadPoolName(value);
                    builder.nonBlockingThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.non-blocking", holder));
                    continue block33;
                }
                case BLOCKING_EXECUTOR: {
                    builder.blockingThreadPoolName(value);
                    builder.blockingThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.blocking", holder));
                    continue block33;
                }
                case STATISTICS: {
                    boolean statistics = Boolean.parseBoolean(value);
                    builder.cacheContainer().statistics(statistics);
                    if (reader.getSchema().since(10, 1)) continue block33;
                    builder.jmx().enabled(statistics);
                    continue block33;
                }
                case SHUTDOWN_HOOK: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(value));
                    continue block33;
                }
                case ZERO_CAPACITY_NODE: {
                    builder.zeroCapacityNode(Boolean.parseBoolean(value));
                    continue block33;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block34: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    continue block34;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, holder, false);
                    continue block34;
                }
                case LOCAL_CACHE_CONFIGURATION: {
                    this.parseLocalCache(reader, holder, true);
                    continue block34;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, holder, false);
                    continue block34;
                }
                case INVALIDATION_CACHE_CONFIGURATION: {
                    this.parseInvalidationCache(reader, holder, true);
                    continue block34;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, holder, false);
                    continue block34;
                }
                case REPLICATED_CACHE_CONFIGURATION: {
                    this.parseReplicatedCache(reader, holder, true);
                    continue block34;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, holder, false);
                    continue block34;
                }
                case DISTRIBUTED_CACHE_CONFIGURATION: {
                    this.parseDistributedCache(reader, holder, true);
                    continue block34;
                }
                case SCATTERED_CACHE: {
                    if (reader.getSchema().since(9, 1)) {
                        this.parseScatteredCache(reader, holder, false);
                        continue block34;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case SCATTERED_CACHE_CONFIGURATION: {
                    if (reader.getSchema().since(9, 1)) {
                        this.parseScatteredCache(reader, holder, true);
                        continue block34;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, holder);
                    continue block34;
                }
                case MODULES: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.elementRemoved(reader);
                    }
                    this.parseModules(reader, holder);
                    continue block34;
                }
                case METRICS: {
                    this.parseMetrics(reader, holder);
                    continue block34;
                }
                case JMX: {
                    this.parseJmx(reader, holder);
                    continue block34;
                }
                case SECURITY: {
                    this.parseGlobalSecurity(reader, holder);
                    continue block34;
                }
                case GLOBAL_STATE: {
                    if (reader.getSchema().since(8, 1)) {
                        this.parseGlobalState(reader, holder);
                        continue block34;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            reader.handleAny(holder);
        }
        holder.popScope();
    }

    private void parseGlobalSecurity(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseGlobalAuthorization(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalAuthorization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalAuthorizationConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().security().authorization().enable();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUDIT_LOGGER: {
                    builder.auditLogger((AuditLogger)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        PrincipalRoleMapper roleMapper = null;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new IdentityRoleMapper();
                    continue block11;
                }
                case COMMON_NAME_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new CommonNameRoleMapper();
                    continue block11;
                }
                case CLUSTER_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new ClusterRoleMapper();
                    continue block11;
                }
                case CUSTOM_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    roleMapper = this.parseCustomMapper(reader, holder);
                    continue block11;
                }
                case ROLE: {
                    this.parseGlobalRole(reader, builder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (roleMapper != null) {
            builder.principalRoleMapper(roleMapper);
        }
    }

    private PrincipalRoleMapper parseCustomMapper(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String mapperClass = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return (PrincipalRoleMapper)Util.getInstance((String)mapperClass, (ClassLoader)holder.getClassLoader());
    }

    private void parseGlobalRole(XMLExtendedStreamReader reader, GlobalAuthorizationConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName(), Attribute.PERMISSIONS.getLocalName());
        GlobalRoleConfigurationBuilder role = builder.role(attributes[0]);
        for (String permission : attributes[1].split("\\s+")) {
            role.permission(permission);
        }
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case PERMISSIONS: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseMetrics(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case GAUGES: {
                    builder.metrics().gauges(Boolean.parseBoolean(value));
                    continue block6;
                }
                case HISTOGRAMS: {
                    builder.metrics().histograms(Boolean.parseBoolean(value));
                    continue block6;
                }
                case PREFIX: {
                    builder.metrics().prefix(value);
                    continue block6;
                }
                case NAMES_AS_TAGS: {
                    builder.metrics().namesAsTags(Boolean.parseBoolean(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJmx(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.jmx().enabled(Boolean.parseBoolean(value));
                    continue block6;
                }
                case DOMAIN: {
                    builder.jmx().domain(value);
                    continue block6;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.jmx().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block6;
                }
                case ALLOW_DUPLICATE_DOMAINS: {
                    if (!reader.getSchema().since(11, 0)) {
                        ParseUtils.ignoreAttribute(reader, i);
                        continue block6;
                    }
                    throw ParseUtils.attributeRemoved(reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = Parser.parseProperties(reader);
        builder.jmx().withProperties(properties);
    }

    private void parseModules(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (holder.getGlobalConfigurationBuilder().transport().getTransport() == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        }
        TransportConfigurationBuilder transport = holder.getGlobalConfigurationBuilder().transport();
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    this.addJGroupsDefaultStacksIfNeeded(reader, holder);
                    JGroupsChannelConfigurator jGroupsStack = holder.getJGroupsStack(value);
                    if (jGroupsStack == null) {
                        throw Log.CONFIG.missingJGroupsStack(value);
                    }
                    Properties p = new Properties();
                    p.put("channelConfigurator", jGroupsStack);
                    p.put("stack", value);
                    transport.withProperties(p);
                    continue block15;
                }
                case CLUSTER: {
                    transport.clusterName(value);
                    continue block15;
                }
                case EXECUTOR: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("transport executor", "11.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block15;
                }
                case TOTAL_ORDER_EXECUTOR: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("total order executor", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block15;
                }
                case REMOTE_COMMAND_EXECUTOR: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("remote command executor", "11.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block15;
                }
                case LOCK_TIMEOUT: {
                    transport.distributedSyncTimeout(Long.parseLong(value));
                    continue block15;
                }
                case NODE_NAME: {
                    transport.nodeName(value);
                    holder.getGlobalConfigurationBuilder().threads().nodeName(value);
                    continue block15;
                }
                case LOCKING: {
                    continue block15;
                }
                case MACHINE_ID: {
                    transport.machineId(value);
                    continue block15;
                }
                case RACK_ID: {
                    transport.rackId(value);
                    continue block15;
                }
                case SITE: {
                    transport.siteId(value);
                    continue block15;
                }
                case INITIAL_CLUSTER_SIZE: {
                    if (reader.getSchema().since(8, 2)) {
                        transport.initialClusterSize(Integer.parseInt(value));
                        continue block15;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                case INITIAL_CLUSTER_TIMEOUT: {
                    if (reader.getSchema().since(8, 2)) {
                        transport.initialClusterTimeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
                        continue block15;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = Parser.parseProperties(reader);
        for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
            transport.addProperty((String)propertyEntry.getKey(), (String)propertyEntry.getValue());
        }
    }

    private void parseGlobalState(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        GlobalStateConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().globalState().enable();
        ConfigurationStorage storage = null;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENT_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::persistentLocation);
                    continue block10;
                }
                case SHARED_PERSISTENT_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::sharedPersistentLocation);
                    continue block10;
                }
                case TEMPORARY_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::temporaryLocation);
                    continue block10;
                }
                case IMMUTABLE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.IMMUTABLE;
                    continue block10;
                }
                case VOLATILE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.VOLATILE;
                    continue block10;
                }
                case OVERLAY_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.OVERLAY;
                    continue block10;
                }
                case MANAGED_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    throw Log.CONFIG.managerConfigurationStorageUnavailable();
                }
                case CUSTOM_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.CUSTOM;
                    builder.configurationStorageSupplier(this.parseCustomConfigurationStorage(reader, holder));
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (storage != null) {
            builder.configurationStorage(storage);
        }
    }

    private void parseGlobalStatePath(XMLExtendedStreamReader reader, BiConsumer<String, String> pathItems) throws XMLStreamException {
        String path = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.PATH.getLocalName())[0];
        String relativeTo = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty(reader, i);
                    continue block4;
                }
                case PATH: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        pathItems.accept(path, relativeTo);
    }

    private Supplier<? extends LocalConfigurationStorage> parseCustomConfigurationStorage(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String storageClass = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return Util.getInstanceSupplier((String)storageClass, (ClassLoader)holder.getClassLoader());
    }

    private ThreadPoolConfiguration createThreadPoolConfiguration(String threadPoolName, String componentName, ConfigurationBuilderHolder holder) {
        ThreadsConfigurationBuilder threads = holder.getGlobalConfigurationBuilder().threads();
        ThreadPoolBuilderAdapter threadPool = threads.getThreadPool(threadPoolName);
        if (threadPool == null) {
            throw Log.CONFIG.undefinedThreadPoolName(threadPoolName);
        }
        ThreadPoolConfiguration threadPoolConfiguration = threadPool.asThreadPoolConfigurationBuilder();
        boolean isNonBlocking = threadPoolConfiguration.threadPoolFactory().createsNonBlockingThreads();
        if ("org.infinispan.executors.non-blocking".equals(componentName) && !isNonBlocking) {
            throw Log.CONFIG.threadPoolFactoryIsBlocking(threadPoolName, componentName);
        }
        DefaultThreadFactory threadFactory = (DefaultThreadFactory)threadPoolConfiguration.threadFactory();
        if (threadFactory != null) {
            threadFactory.setComponent(KnownComponentNames.shortened(componentName));
        }
        return threadPoolConfiguration;
    }

    public static void parseStoreAttribute(XMLExtendedStreamReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        if (reader.getSchema().getMajor() < 10) {
            storeBuilder.segmented(false);
        }
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                storeBuilder.shared(Boolean.parseBoolean(value));
                break;
            }
            case READ_ONLY: {
                storeBuilder.ignoreModifications(Boolean.parseBoolean(value));
                break;
            }
            case PRELOAD: {
                storeBuilder.preload(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                storeBuilder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case TRANSACTIONAL: {
                storeBuilder.transactional(Boolean.parseBoolean(value));
                break;
            }
            case MAX_BATCH_SIZE: {
                storeBuilder.maxBatchSize(Integer.parseInt(value));
                break;
            }
            case SEGMENTED: {
                storeBuilder.segmented(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    public static void parseStoreElement(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                Parser.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                Parser.parseStoreProperty(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseStoreWriteBehind(XMLExtendedStreamReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: 
                case SHUTDOWN_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(Integer.parseInt(value));
                    continue block6;
                }
                case FAIL_SILENTLY: {
                    storeBuilder.failSilently(Boolean.parseBoolean(value));
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseStoreProperty(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String property = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    private static void parseProperty(XMLExtendedStreamReader reader, Properties properties) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String key = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    key = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        String propertyValue = reader.getElementText();
        properties.setProperty(key, propertyValue);
    }

    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties properties = new Properties();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Parser.parseProperty(reader, properties);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return properties;
    }

    private void addJGroupsDefaultStacksIfNeeded(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) {
        if (holder.getJGroupsStack("tcp") == null) {
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.TCP(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.UDP(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.KUBERNETES(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.EC2(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.GOOGLE(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.AZURE(reader.getProperties()));
        }
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

