/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexMergeConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.cluster.ClusterLoader;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.spi.XSiteMergePolicy;

@Namespaces(value={@Namespace(root="local-cache"), @Namespace(root="distributed-cache"), @Namespace(root="replicated-cache"), @Namespace(root="scattered-cache"), @Namespace(uri="urn:infinispan:config:*", root="local-cache"), @Namespace(uri="urn:infinispan:config:*", root="distributed-cache"), @Namespace(uri="urn:infinispan:config:*", root="replicated-cache"), @Namespace(uri="urn:infinispan:config:*", root="scattered-cache")})
public class CacheParser
implements ConfigurationParser {
    public static final String NAMESPACE = "urn:infinispan:config:";

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LOCAL_CACHE: {
                this.parseLocalCache(reader, holder, false);
                break;
            }
            case LOCAL_CACHE_CONFIGURATION: {
                this.parseLocalCache(reader, holder, true);
                break;
            }
            case INVALIDATION_CACHE: {
                this.parseInvalidationCache(reader, holder, false);
                break;
            }
            case INVALIDATION_CACHE_CONFIGURATION: {
                this.parseInvalidationCache(reader, holder, true);
                break;
            }
            case REPLICATED_CACHE: {
                this.parseReplicatedCache(reader, holder, false);
                break;
            }
            case REPLICATED_CACHE_CONFIGURATION: {
                this.parseReplicatedCache(reader, holder, true);
                break;
            }
            case DISTRIBUTED_CACHE: {
                this.parseDistributedCache(reader, holder, false);
                break;
            }
            case DISTRIBUTED_CACHE_CONFIGURATION: {
                this.parseDistributedCache(reader, holder, true);
                break;
            }
            case SCATTERED_CACHE: {
                if (reader.getSchema().since(9, 1)) {
                    this.parseScatteredCache(reader, holder, false);
                    break;
                }
                throw ParseUtils.unexpectedElement(reader);
            }
            case SCATTERED_CACHE_CONFIGURATION: {
                if (reader.getSchema().since(9, 1)) {
                    this.parseScatteredCache(reader, holder, true);
                    break;
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseModules(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
    }

    protected void parseLocalCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, builder);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder) throws XMLStreamException {
        switch (attribute) {
            case NAME: 
            case CONFIGURATION: {
                break;
            }
            case START: 
            case JNDI_NAME: 
            case MODULE: {
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case SIMPLE_CACHE: {
                builder.simpleCache(Boolean.parseBoolean(value));
                break;
            }
            case STATISTICS: {
                builder.statistics().enabled(Boolean.parseBoolean(value));
                break;
            }
            case STATISTICS_AVAILABLE: {
                builder.statistics().available(Boolean.parseBoolean(value));
                break;
            }
            case SPIN_DURATION: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case UNRELIABLE_RETURN_VALUES: {
                builder.unsafe().unreliableReturnValues(Boolean.parseBoolean(value));
                break;
            }
            default: {
                if (!ParseUtils.isNoNamespaceAttribute(reader, index)) break;
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseSharedStateCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, builder);
                break;
            }
            default: {
                this.parseCacheElement(reader, element, holder);
            }
        }
    }

    private void parseBackups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        builder.sites().backups().clear();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (attribute != Attribute.MERGE_POLICY) {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
            }
            builder.sites().mergePolicy(XSiteMergePolicy.instanceFromString(value, holder.getClassLoader()));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.BACKUP) {
                this.parseBackup(reader, builder);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        PartitionHandlingConfigurationBuilder ph = builder.clustering().partitionHandling();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i, Attribute.WHEN_SPLIT.getLocalName());
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block5;
                }
                case WHEN_SPLIT: {
                    ph.whenSplit(PartitionHandling.valueOf(value.toUpperCase()));
                    continue block5;
                }
                case MERGE_POLICY: {
                    MergePolicy mp = MergePolicy.fromString(value);
                    MergePolicy mergePolicy = mp == MergePolicy.CUSTOM ? (EntryMergePolicy)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()) : mp;
                    ph.mergePolicy(mergePolicy);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackup(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        BackupConfigurationBuilder backup = builder.sites().addBackup();
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    backup.site(value);
                    continue block13;
                }
                case STRATEGY: {
                    backup.strategy(BackupConfiguration.BackupStrategy.valueOf(value));
                    continue block13;
                }
                case BACKUP_FAILURE_POLICY: {
                    backup.backupFailurePolicy(BackupFailurePolicy.valueOf(value));
                    continue block13;
                }
                case TIMEOUT: {
                    backup.replicationTimeout(Long.parseLong(value));
                    continue block13;
                }
                case ENABLED: {
                    backup.enabled(Boolean.parseBoolean(value));
                    continue block13;
                }
                case USE_TWO_PHASE_COMMIT: {
                    backup.useTwoPhaseCommit(Boolean.parseBoolean(value));
                    continue block13;
                }
                case FAILURE_POLICY_CLASS: {
                    backup.failurePolicyClass(value);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (backup.site() == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SITE));
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, backup);
                    continue block14;
                }
                case STATE_TRANSFER: {
                    this.parseXSiteStateTransfer(reader, backup);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TAKE_BACKUP_OFFLINE_AFTER_FAILURES: {
                    backup.takeOffline().afterFailures(Integer.parseInt(value));
                    continue block4;
                }
                case TAKE_BACKUP_OFFLINE_MIN_WAIT: {
                    backup.takeOffline().minTimeToWait(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseXSiteStateTransfer(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CHUNK_SIZE: {
                    backup.stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                case TIMEOUT: {
                    backup.stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case MAX_RETRIES: {
                    backup.stateTransfer().maxRetries(Integer.parseInt(value));
                    continue block6;
                }
                case WAIT_TIME: {
                    backup.stateTransfer().waitTime(Long.parseLong(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.sites().backupFor().reset();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    builder.sites().backupFor().remoteCache(value);
                    continue block4;
                }
                case REMOTE_SITE: {
                    builder.sites().backupFor().remoteSite(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCacheSecurity(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        SecurityConfigurationBuilder securityBuilder = builder.security();
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseCacheAuthorization(reader, securityBuilder.authorization().enable());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCacheAuthorization(XMLExtendedStreamReader reader, AuthorizationConfigurationBuilder authzBuilder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    authzBuilder.enabled(Boolean.parseBoolean(value));
                    continue block4;
                }
                case ROLES: {
                    for (String role : value.split("\\s+")) {
                        authzBuilder.role(role);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected final void parseCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, builder);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, builder, holder);
                break;
            }
            case EVICTION: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.elementRemoved(reader, Element.MEMORY.getLocalName());
                }
                this.parseEviction(reader, builder);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, builder);
                break;
            }
            case ENCODING: {
                this.parseDataType(reader, builder, holder);
                break;
            }
            case PERSISTENCE: {
                this.parsePersistence(reader, holder);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, holder);
                break;
            }
            case CUSTOM_INTERCEPTORS: {
                Log.CONFIG.customInterceptorsDeprecated();
                this.parseCustomInterceptors(reader, holder);
                break;
            }
            case VERSIONING: {
                this.parseVersioning(reader, holder);
                break;
            }
            case COMPATIBILITY: {
                if (reader.getSchema().since(10, 0)) break;
                this.parseCompatibility(reader, holder);
                break;
            }
            case STORE_AS_BINARY: {
                this.parseStoreAsBinary(reader, holder);
                break;
            }
            case MODULES: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.elementRemoved(reader);
                }
                this.parseModules(reader, holder);
                break;
            }
            case DATA_CONTAINER: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.elementRemoved(reader);
                }
                this.parseDataContainer(reader);
                break;
            }
            case MEMORY: {
                this.parseMemory(reader, holder);
                break;
            }
            case BACKUPS: {
                this.parseBackups(reader, holder);
                break;
            }
            case BACKUP_FOR: {
                this.parseBackupFor(reader, builder);
                break;
            }
            case PARTITION_HANDLING: {
                this.parsePartitionHandling(reader, holder);
                break;
            }
            case SECURITY: {
                this.parseCacheSecurity(reader, builder);
                break;
            }
            default: {
                reader.handleAny(holder);
            }
        }
    }

    private void parseDataContainer(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.ignoreElement(reader, Element.DATA_CONTAINER);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: 
                case KEY_EQUIVALENCE: 
                case VALUE_EQUIVALENCE: {
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    ParseUtils.ignoreElement(reader, element);
                    CacheParser.parseProperty(reader, properties);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseMemory(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        if (reader.getSchema().since(11, 0)) {
            block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute(reader, i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case STORAGE: {
                        memoryBuilder.storage(StorageType.valueOf(value));
                        continue block11;
                    }
                    case MAX_SIZE: {
                        memoryBuilder.maxSize(value);
                        continue block11;
                    }
                    case MAX_COUNT: {
                        memoryBuilder.maxCount(Long.parseLong(value));
                        continue block11;
                    }
                    case WHEN_FULL: {
                        memoryBuilder.whenFull(EvictionStrategy.valueOf(value));
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                    }
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            Log.CONFIG.warnUsingDeprecatedMemoryConfigs(element.getLocalName());
            switch (element) {
                case OFF_HEAP: {
                    memoryBuilder.storageType(StorageType.OFF_HEAP);
                    this.parseOffHeapMemoryAttributes(reader, holder);
                    continue block12;
                }
                case OBJECT: {
                    memoryBuilder.storageType(StorageType.OBJECT);
                    this.parseObjectMemoryAttributes(reader, holder);
                    continue block12;
                }
                case BINARY: {
                    memoryBuilder.storageType(StorageType.BINARY);
                    this.parseBinaryMemoryAttributes(reader, holder);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseOffHeapMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block6;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(EvictionType.valueOf(value));
                    continue block6;
                }
                case ADDRESS_COUNT: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseObjectMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block4;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBinaryMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block5;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(EvictionType.valueOf(value));
                    continue block5;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Log.CONFIG.elementDeprecatedUseOther(Element.STORE_AS_BINARY, Element.MEMORY);
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean binaryKeys = null;
        Boolean binaryValues = null;
        builder.memory().storageType(StorageType.BINARY);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STORE_KEYS_AS_BINARY: {
                    binaryKeys = Boolean.parseBoolean(value);
                    continue block4;
                }
                case STORE_VALUES_AS_BINARY: {
                    binaryValues = Boolean.parseBoolean(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (binaryKeys != null && !binaryKeys.booleanValue() && binaryValues != null && !binaryValues.booleanValue()) {
            builder.memory().storageType(StorageType.OBJECT);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCompatibility(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        EncodingConfigurationBuilder encoding = builder.encoding();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (!Boolean.parseBoolean(value)) continue block4;
                    encoding.key().mediaType("application/x-java-object");
                    encoding.value().mediaType("application/x-java-object");
                    continue block4;
                }
                case MARSHALLER_CLASS: {
                    Log.CONFIG.marshallersNotSupported();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseVersioning(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("versioning", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCustomInterceptors(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseInterceptor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case CLASS: {
                    interceptorBuilder.interceptorClass(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.parseInt(value));
                    continue block7;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        interceptorBuilder.withProperties(CacheParser.parseProperties(reader));
    }

    private final void parseLocking(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block7;
                }
                case STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block7;
                }
                case ACQUIRE_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block7;
                }
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block7;
                }
                case WRITE_SKEW_CHECK: {
                    Log.CONFIG.ignoredAttribute("write skew attribute", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private final void parseTransaction(XMLExtendedStreamReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) throws XMLStreamException {
        CacheMode cacheMode;
        if (!reader.getSchema().since(9, 0) && !(cacheMode = builder.clustering().cacheMode()).isSynchronous()) {
            Log.CONFIG.unsupportedAsyncCacheMode(cacheMode, cacheMode.toSync());
            builder.clustering().cacheMode(cacheMode.toSync());
        }
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block12;
                }
                case MODE: {
                    TransactionMode txMode = TransactionMode.valueOf(value);
                    builder.transaction().transactionMode(txMode.getMode());
                    builder.transaction().useSynchronization(!txMode.isXAEnabled() && txMode.getMode().isTransactional());
                    builder.transaction().recovery().enabled(txMode.isRecoveryEnabled());
                    builder.invocationBatching().enable(txMode.isBatchingEnabled());
                    continue block12;
                }
                case LOCKING: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block12;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block12;
                }
                case REAPER_WAKE_UP_INTERVAL: {
                    builder.transaction().reaperWakeUpInterval(Long.parseLong(value));
                    continue block12;
                }
                case COMPLETED_TX_TIMEOUT: {
                    builder.transaction().completedTxTimeout(Long.parseLong(value));
                    continue block12;
                }
                case TRANSACTION_PROTOCOL: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("transaction protocol", "11.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block12;
                }
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.parseBoolean(value));
                    continue block12;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    builder.transaction().recovery().recoveryInfoCacheName(value);
                    continue block12;
                }
                case NOTIFICATIONS: {
                    builder.transaction().notifications(Boolean.parseBoolean(value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private final void parseDataType(XMLExtendedStreamReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) throws XMLStreamException {
        EncodingConfigurationBuilder encodingBuilder = builder.encoding();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (attribute != Attribute.MEDIA_TYPE || !reader.getSchema().since(11, 0)) {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
            }
            encodingBuilder.mediaType(value);
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_DATA_TYPE: {
                    ContentTypeConfigurationBuilder keyBuilder = encodingBuilder.key();
                    this.parseContentType(reader, holder, keyBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block5;
                }
                case VALUE_DATA_TYPE: {
                    ContentTypeConfigurationBuilder valueBuilder = encodingBuilder.value();
                    this.parseContentType(reader, holder, valueBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseContentType(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ContentTypeConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MEDIA_TYPE: {
                    builder.mediaType(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
    }

    private void parseEviction(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        Log.CONFIG.elementDeprecatedUseOther(Element.EVICTION, Element.MEMORY);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: 
                case THREAD_POLICY: 
                case TYPE: {
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block4;
                }
                case SIZE: 
                case MAX_ENTRIES: {
                    builder.memory().size(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block5;
                }
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block5;
                }
                case INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseInvalidationCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.INVALIDATION_SYNC : CacheMode.INVALIDATION_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_PARTITIONER: {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block5;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, baseCacheMode);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseSegmentedCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, ClassLoader classLoader, CacheMode baseCacheMode) throws XMLStreamException {
        switch (attribute) {
            case SEGMENTS: {
                builder.clustering().hash().numSegments(Integer.parseInt(value));
                break;
            }
            case CONSISTENT_HASH_FACTORY: {
                if (reader.getSchema().since(11, 0)) {
                    Log.CONFIG.debug("Consistent hash customization has been deprecated and will be removed");
                }
                builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                break;
            }
            case KEY_PARTITIONER: {
                if (reader.getSchema().since(8, 2)) {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)classLoader));
                    break;
                }
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
            default: {
                this.parseClusteredCacheAttribute(reader, index, attribute, value, builder, baseCacheMode);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, CacheMode baseCacheMode) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case MODE: {
                Mode mode = Mode.valueOf(value);
                builder.clustering().cacheMode(mode.apply(baseCacheMode));
                break;
            }
            case QUEUE_SIZE: 
            case QUEUE_FLUSH_INTERVAL: {
                if (reader.getSchema().since(11, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case REMOTE_TIMEOUT: {
                builder.clustering().remoteTimeout(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, builder);
            }
        }
    }

    protected void parseReplicatedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.REPL_SYNC : CacheMode.REPL_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AWAIT_INITIAL_TRANSFER: {
                    builder.clustering().stateTransfer().awaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case ENABLED: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block6;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseDistributedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.DIST_SYNC : CacheMode.DIST_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block9;
                }
                case L1_LIFESPAN: {
                    long lifespan = Long.parseLong(value);
                    if (lifespan > 0L) {
                        builder.clustering().l1().enable().lifespan(lifespan);
                        continue block9;
                    }
                    builder.clustering().l1().disable();
                    continue block9;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(Long.parseLong(value));
                    continue block9;
                }
                case CAPACITY_FACTOR: {
                    builder.clustering().hash().capacityFactor(Float.parseFloat(value));
                    continue block9;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, holder);
                    continue block10;
                }
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String value;
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireSingleAttribute((XMLStreamReader)reader, "enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement(reader, "class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseScatteredCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.SCATTERED_SYNC : CacheMode.SCATTERED_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        ClusteringConfigurationBuilder clusteringBuilder = builder.clustering();
        clusteringBuilder.cacheMode(baseCacheMode);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INVALIDATION_BATCH_SIZE: {
                    clusteringBuilder.invalidationBatchSize(Integer.parseInt(value));
                    continue block7;
                }
                case BIAS_ACQUISITION: {
                    clusteringBuilder.biasAcquisition(BiasAcquisition.valueOf(value));
                    continue block7;
                }
                case BIAS_LIFESPAN: {
                    clusteringBuilder.biasLifespan(Long.parseLong(value), TimeUnit.MILLISECONDS);
                    continue block7;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
    }

    private ConfigurationBuilder getConfigurationBuilder(ConfigurationBuilderHolder holder, String name, boolean template, String baseConfigurationName) {
        if (holder.getNamedConfigurationBuilders().containsKey(name)) {
            throw Log.CONFIG.duplicateCacheName(name);
        }
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        if (baseConfigurationName != null) {
            ConfigurationBuilder baseConfigurationBuilder = holder.getNamedConfigurationBuilders().get(baseConfigurationName);
            if (baseConfigurationBuilder == null) {
                throw Log.CONFIG.undeclaredConfiguration(baseConfigurationName, name);
            }
            Configuration baseConfiguration = baseConfigurationBuilder.build();
            if (!baseConfiguration.isTemplate()) {
                throw Log.CONFIG.noConfiguration(baseConfigurationName);
            }
            builder.read(baseConfiguration);
        }
        return builder.template(template);
    }

    private void parsePersistence(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.persistence().passivation(Boolean.parseBoolean(value));
                    continue block12;
                }
                case AVAILABILITY_INTERVAL: {
                    builder.persistence().availabilityInterval(Integer.parseInt(value));
                    continue block12;
                }
                case CONNECTION_ATTEMPTS: {
                    builder.persistence().connectionAttempts(Integer.parseInt(value));
                    continue block12;
                }
                case CONNECTION_INTERVAL: {
                    builder.persistence().connectionInterval(Integer.parseInt(value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        builder.persistence().clearStores();
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_LOADER: {
                    Log.CONFIG.warnUsingDeprecatedClusterLoader();
                    this.parseClusterLoader(reader, holder);
                    continue block13;
                }
                case FILE_STORE: {
                    this.parseFileStore(reader, holder);
                    continue block13;
                }
                case STORE: {
                    this.parseCustomStore(reader, holder);
                    continue block13;
                }
                case LOADER: {
                    ParseUtils.ignoreElement(reader, element);
                    continue block13;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ClusterLoaderConfigurationBuilder cclb = builder.persistence().addClusterLoader();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case REMOTE_TIMEOUT: {
                    cclb.remoteCallTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    CacheParser.parseStoreAttribute(reader, i, cclb);
                }
            }
        }
        this.parseStoreElements(reader, cclb);
    }

    protected void parseFileStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        SingleFileStoreConfigurationBuilder storeBuilder = holder.getCurrentConfigurationBuilder().persistence().addSingleFileStore();
        String path = null;
        String relativeTo = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case PATH: {
                    path = value;
                    continue block6;
                }
                case MAX_ENTRIES: {
                    storeBuilder.maxEntries(Integer.parseInt(value));
                    continue block6;
                }
                case FRAGMENTATION_FACTOR: {
                    storeBuilder.fragmentationFactor(Float.parseFloat(value));
                    continue block6;
                }
                default: {
                    CacheParser.parseStoreAttribute(reader, i, storeBuilder);
                }
            }
        }
        if ((path = ParseUtils.resolvePath(path, relativeTo)) != null) {
            storeBuilder.location(path);
        }
        this.parseStoreElements(reader, storeBuilder);
    }

    public static void parseStoreAttribute(XMLExtendedStreamReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        if (reader.getSchema().getMajor() < 10) {
            storeBuilder.segmented(false);
        }
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                storeBuilder.shared(Boolean.parseBoolean(value));
                break;
            }
            case READ_ONLY: {
                storeBuilder.ignoreModifications(Boolean.parseBoolean(value));
                break;
            }
            case PRELOAD: {
                storeBuilder.preload(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                storeBuilder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case TRANSACTIONAL: {
                storeBuilder.transactional(Boolean.parseBoolean(value));
                break;
            }
            case MAX_BATCH_SIZE: {
                storeBuilder.maxBatchSize(Integer.parseInt(value));
                break;
            }
            case SEGMENTED: {
                storeBuilder.segmented(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            CacheParser.parseStoreElement(reader, storeBuilder);
        }
    }

    public static void parseStoreElement(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                CacheParser.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                CacheParser.parseStoreProperty(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseStoreWriteBehind(XMLExtendedStreamReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block7;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(Integer.parseInt(value));
                    continue block7;
                }
                case FAIL_SILENTLY: {
                    storeBuilder.failSilently(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseStoreProperty(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String property = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Boolean preload = null;
        Boolean shared = null;
        Boolean transactional = null;
        Boolean segmented = null;
        Object store = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store = Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block11;
                }
                case FETCH_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block11;
                }
                case READ_ONLY: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block11;
                }
                case PURGE: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block11;
                }
                case PRELOAD: {
                    preload = Boolean.parseBoolean(value);
                    continue block11;
                }
                case SHARED: {
                    shared = Boolean.parseBoolean(value);
                    continue block11;
                }
                case SINGLETON: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block11;
                }
                case TRANSACTIONAL: {
                    transactional = Boolean.parseBoolean(value);
                    continue block11;
                }
                case SEGMENTED: {
                    segmented = Boolean.parseBoolean(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (store != null) {
            if (store instanceof SingleFileStore) {
                SingleFileStoreConfigurationBuilder sfs = builder.persistence().addSingleFileStore();
                if (fetchPersistentState != null) {
                    sfs.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    sfs.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    sfs.purgeOnStartup(purgeOnStartup);
                }
                if (preload != null) {
                    sfs.preload(preload);
                }
                if (shared != null) {
                    sfs.shared(shared);
                }
                if (transactional != null) {
                    sfs.transactional(transactional);
                }
                if (segmented != null) {
                    sfs.segmented(segmented);
                }
                this.parseStoreElements(reader, sfs);
            } else if (store instanceof ClusterLoader) {
                ClusterLoaderConfigurationBuilder cscb = builder.persistence().addClusterLoader();
                this.parseStoreElements(reader, cscb);
            } else {
                Class configuredBy;
                ConfiguredBy annotation = store.getClass().getAnnotation(ConfiguredBy.class);
                Class<StoreConfigurationBuilder> builderClass = null;
                if (annotation != null && (configuredBy = annotation.value()) != null) {
                    BuiltBy builtBy = configuredBy.getAnnotation(BuiltBy.class);
                    builderClass = builtBy.value().asSubclass(StoreConfigurationBuilder.class);
                }
                Object configBuilder = builderClass == null ? builder.persistence().addStore(CustomStoreConfigurationBuilder.class).customStoreClass(store.getClass()) : builder.persistence().addStore(builderClass);
                if (fetchPersistentState != null) {
                    configBuilder.fetchPersistentState(fetchPersistentState.booleanValue());
                }
                if (ignoreModifications != null) {
                    configBuilder.ignoreModifications(ignoreModifications.booleanValue());
                }
                if (purgeOnStartup != null) {
                    configBuilder.purgeOnStartup(purgeOnStartup.booleanValue());
                }
                if (preload != null) {
                    configBuilder.preload(preload.booleanValue());
                }
                if (shared != null) {
                    configBuilder.shared(shared.booleanValue());
                }
                if (transactional != null) {
                    configBuilder.transactional(transactional.booleanValue());
                }
                if (segmented != null) {
                    configBuilder.segmented(segmented.booleanValue());
                }
                this.parseStoreElements(reader, (StoreConfigurationBuilder<?, ?>)configBuilder);
            }
        }
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        boolean selfEnable = reader.getSchema().since(11, 0);
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (reader.getSchema().since(11, 0)) {
                        builder.indexing().enabled(Boolean.parseBoolean(value));
                        selfEnable = false;
                        continue block14;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                case INDEX: {
                    if (reader.getSchema().since(11, 0)) {
                        Log.CONFIG.indexModeDeprecated();
                    }
                    if ("LOCAL".equals(value) || "PRIMARY_OWNER".equals(value)) {
                        throw Log.CONFIG.indexModeNotSupported(value);
                    }
                    Index index = Index.valueOf(value);
                    builder.indexing().index(index);
                    selfEnable = false;
                    continue block14;
                }
                case AUTO_CONFIG: {
                    Log.CONFIG.autoConfigDeprecated();
                    builder.indexing().autoConfig(Boolean.parseBoolean(value));
                    continue block14;
                }
                case STORAGE: {
                    builder.indexing().storage(IndexStorage.requireValid(value, Log.CONFIG));
                    continue block14;
                }
                case PATH: {
                    builder.indexing().path(value);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (selfEnable) {
            builder.indexing().enable();
        }
        Properties indexingProperties = new Properties();
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMERS: {
                    this.parseKeyTransformers(reader, holder, builder);
                    continue block15;
                }
                case INDEXED_ENTITIES: {
                    this.parseIndexedEntities(reader, holder, builder);
                    continue block15;
                }
                case PROPERTY: {
                    if (reader.getSchema().since(12, 0)) {
                        Log.CONFIG.deprecatedIndexProperties();
                    }
                    CacheParser.parseProperty(reader, indexingProperties);
                    continue block15;
                }
                case INDEX_READER: {
                    this.parseIndexReader(reader, builder);
                    continue block15;
                }
                case INDEX_WRITER: {
                    this.parseIndexWriter(reader, builder);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!indexingProperties.isEmpty()) {
            builder.indexing().withProperties(indexingProperties);
        }
    }

    private void parseKeyTransformers(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMER: {
                    this.parseKeyTransformer(reader, holder, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseKeyTransformer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        String[] attrs = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.KEY.getLocalName(), Attribute.TRANSFORMER.getLocalName());
        Class keyClass = Util.loadClass((String)attrs[0], (ClassLoader)holder.getClassLoader());
        Class transformerClass = Util.loadClass((String)attrs[1], (ClassLoader)holder.getClassLoader());
        builder.indexing().addKeyTransformer(keyClass, transformerClass);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY: 
                case TRANSFORMER: {
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexReader(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (attribute != Attribute.REFRESH_INTERVAL) {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
            }
            builder.indexing().reader().refreshInterval(Long.parseLong(value));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexWriter(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        IndexWriterConfigurationBuilder indexWriterBuilder = builder.indexing().writer();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case THREAD_POOL_SIZE: {
                    indexWriterBuilder.threadPoolSize(Integer.parseInt(value));
                    continue block9;
                }
                case COMMIT_INTERVAL: {
                    indexWriterBuilder.commitInterval(Integer.parseInt(value));
                    continue block9;
                }
                case QUEUE_COUNT: {
                    indexWriterBuilder.queueCount(Integer.parseInt(value));
                    continue block9;
                }
                case QUEUE_SIZE: {
                    indexWriterBuilder.queueSize(Integer.parseInt(value));
                    continue block9;
                }
                case LOW_LEVEL_TRACE: {
                    indexWriterBuilder.setLowLevelTrace(Boolean.parseBoolean(value));
                    continue block9;
                }
                case MAX_BUFFERED_ENTRIES: {
                    indexWriterBuilder.maxBufferedEntries(Integer.parseInt(value));
                    continue block9;
                }
                case RAM_BUFFER_SIZE: {
                    indexWriterBuilder.ramBufferSize(Integer.parseInt(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.INDEX_MERGE) {
                this.parseIndexWriterMerge(reader, builder);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseIndexWriterMerge(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            IndexMergeConfigurationBuilder mergeBuilder = builder.indexing().writer().merge();
            switch (attribute) {
                case MAX_ENTRIES: {
                    mergeBuilder.maxEntries(Integer.parseInt(value));
                    continue block8;
                }
                case CALIBRATE_BY_DELETES: {
                    mergeBuilder.calibrateByDeletes(Boolean.parseBoolean(value));
                    continue block8;
                }
                case FACTOR: {
                    mergeBuilder.factor(Integer.parseInt(value));
                    continue block8;
                }
                case MAX_FORCED_SIZE: {
                    mergeBuilder.maxForcedSize(Integer.parseInt(value));
                    continue block8;
                }
                case MAX_SIZE: {
                    mergeBuilder.maxSize(Integer.parseInt(value));
                    continue block8;
                }
                case MIN_SIZE: {
                    mergeBuilder.minSize(Integer.parseInt(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexedEntities(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean isProtobufStorage = builder.memory().encoding().value().isProtobufStorage();
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INDEXED_ENTITY: {
                    ParseUtils.requireNoAttributes(reader);
                    String typeName = reader.getElementText();
                    builder.indexing().addIndexedEntity(typeName);
                    if (isProtobufStorage) continue block5;
                    try {
                        Class indexedClass = Util.loadClass((String)typeName, (ClassLoader)holder.getClassLoader());
                        builder.indexing().addIndexedEntity(indexedClass);
                    }
                    catch (Exception exception) {}
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private static void parseProperty(XMLExtendedStreamReader reader, Properties properties) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String key = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    key = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        String propertyValue = reader.getElementText();
        properties.setProperty(key, propertyValue);
    }

    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties properties = new Properties();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    CacheParser.parseProperty(reader, properties);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return properties;
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static enum Mode {
        SYNC(true),
        ASYNC(false);

        private final boolean sync;

        private Mode(boolean sync) {
            this.sync = sync;
        }

        public static Mode forCacheMode(CacheMode mode) {
            return mode.isSynchronous() ? SYNC : ASYNC;
        }

        public CacheMode apply(CacheMode mode) {
            return this.sync ? mode.toSync() : mode.toAsync();
        }

        public boolean isSynchronous() {
            return this.sync;
        }
    }

    public static enum TransactionMode {
        NONE(org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL, false, false, false),
        BATCH(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, true),
        NON_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, false),
        NON_DURABLE_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, false, false),
        FULL_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, true, false);

        private final org.infinispan.transaction.TransactionMode mode;
        private final boolean xaEnabled;
        private final boolean recoveryEnabled;
        private final boolean batchingEnabled;

        private TransactionMode(org.infinispan.transaction.TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
            this.mode = mode;
            this.xaEnabled = xaEnabled;
            this.recoveryEnabled = recoveryEnabled;
            this.batchingEnabled = batchingEnabled;
        }

        public static TransactionMode fromConfiguration(TransactionConfiguration transactionConfiguration, boolean batchingEnabled) {
            boolean xaEnabled;
            org.infinispan.transaction.TransactionMode mode = transactionConfiguration.transactionMode();
            boolean recoveryEnabled = transactionConfiguration.recovery().enabled();
            boolean bl = xaEnabled = !batchingEnabled && !transactionConfiguration.useSynchronization();
            if (mode == org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL) {
                return NONE;
            }
            for (TransactionMode txMode : TransactionMode.values()) {
                if (txMode.mode != mode || txMode.xaEnabled != xaEnabled || txMode.recoveryEnabled != recoveryEnabled || txMode.batchingEnabled != batchingEnabled) continue;
                return txMode;
            }
            throw Log.CONFIG.unknownTransactionConfiguration(mode, xaEnabled, recoveryEnabled, batchingEnabled);
        }

        public org.infinispan.transaction.TransactionMode getMode() {
            return this.mode;
        }

        public boolean isXAEnabled() {
            return this.xaEnabled;
        }

        public boolean isRecoveryEnabled() {
            return this.recoveryEnabled;
        }

        public boolean isBatchingEnabled() {
            return this.batchingEnabled;
        }
    }
}

