/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;

public abstract class AbstractLockingInterceptor
extends DDAsyncInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    final InvocationFinallyAction<VisitableCommand> unlockAllReturnHandler = this::handleUnlockAll;
    @Inject
    protected LockManager lockManager;
    @Inject
    protected ClusteringDependentLogic cdl;
    protected boolean invalidationMode;

    @Start
    public void start() {
        this.invalidationMode = this.cacheConfiguration.clustering().cacheMode().isInvalidation();
    }

    protected abstract Log getLog();

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            return this.visitNonTxDataWriteCommand(ctx, command);
        }
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.visitNonTxDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    protected abstract Object visitDataReadCommand(InvocationContext var1, DataCommand var2) throws Throwable;

    protected abstract Object visitDataWriteCommand(InvocationContext var1, DataWriteCommand var2) throws Throwable;

    final Object visitNonTxDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        boolean shouldLockKey;
        boolean bl = shouldLockKey = this.invalidationMode ? ctx.isOriginLocal() : this.shouldLockKey(command);
        if (this.hasSkipLocking(command) || !shouldLockKey) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage lockStage = this.lockAndRecord(ctx, command, command.getKey(), this.getLockTimeoutMillis(command));
        return this.nonTxLockAndInvokeNext(ctx, command, lockStage, this.unlockAllReturnHandler);
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) {
        if (this.hasSkipLocking(command)) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage lockStage = this.lockAllAndRecord(ctx, command, Arrays.asList(command.getKeys()), this.getLockTimeoutMillis(command));
        return this.nonTxLockAndInvokeNext(ctx, command, lockStage, this.unlockAllReturnHandler);
    }

    @Override
    public final Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        if (command.isCausedByALocalWrite(this.cdl.getAddress())) {
            if (this.trace) {
                this.getLog().trace("Skipping invalidation as the write operation originated here.");
            }
            return null;
        }
        if (this.hasSkipLocking(command)) {
            return this.invokeNext(ctx, command);
        }
        Object[] keys = command.getKeys();
        if (keys == null || keys.length < 1) {
            return null;
        }
        ArrayList<Object> keysToInvalidate = new ArrayList<Object>(keys.length);
        for (Object key : keys) {
            try {
                KeyAwareLockPromise lockPromise = this.lockManager.lock(key, ctx.getLockOwner(), 0L, TimeUnit.MILLISECONDS);
                lockPromise.lock();
                ctx.addLockedKey(key);
                keysToInvalidate.add(key);
            }
            catch (TimeoutException te) {
                this.getLog().unableToLockToInvalidate(key, this.cdl.getAddress());
            }
        }
        if (keysToInvalidate.isEmpty()) {
            return null;
        }
        command.setKeys(keysToInvalidate.toArray());
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            rCommand.setKeys(keys);
            if (!rCtx.isInTxScope()) {
                this.lockManager.unlockAll(rCtx);
            }
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getMap().keySet(), command.isForwarded());
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.handleReadManyCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.handleReadManyCommand(ctx, command, command.getKeys());
    }

    protected abstract Object handleReadManyCommand(InvocationContext var1, FlagAffectedCommand var2, Collection<?> var3) throws Throwable;

    protected abstract <K> Object handleWriteManyCommand(InvocationContext var1, WriteCommand var2, Collection<K> var3, boolean var4) throws Throwable;

    protected final long getLockTimeoutMillis(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.cacheConfiguration.locking().lockAcquisitionTimeout();
    }

    final boolean shouldLockKey(DataWriteCommand command) {
        return this.shouldLockKey(command.getSegment());
    }

    final boolean shouldLockKey(Object key) {
        boolean shouldLock = this.isLockOwner(key);
        if (this.trace) {
            this.getLog().tracef("Are (%s) we the lock owners for key '%s'? %s", this.cdl.getAddress(), Util.toStr((Object)key), shouldLock);
        }
        return shouldLock;
    }

    final boolean shouldLockKey(int keySegment) {
        boolean shouldLock = this.isLockOwner(keySegment);
        if (this.trace) {
            this.getLog().tracef("Are (%s) we the lock owners for segment '%s'? %s", this.cdl.getAddress(), keySegment, shouldLock);
        }
        return shouldLock;
    }

    final boolean isLockOwner(Object key) {
        return this.cdl.getCacheTopology().getDistribution(key).isPrimary();
    }

    final boolean isLockOwner(int keySegment) {
        return this.cdl.getCacheTopology().getSegmentDistribution(keySegment).isPrimary();
    }

    protected final InvocationStage lockAndRecord(InvocationContext context, VisitableCommand command, Object key, long timeout) {
        return this.lockManager.lock(key, context.getLockOwner(), timeout, TimeUnit.MILLISECONDS).toInvocationStage().thenAcceptMakeStage(context, command, (rCtx, rCommand, rv) -> rCtx.addLockedKey(key));
    }

    final InvocationStage lockAllAndRecord(InvocationContext context, VisitableCommand command, Collection<?> keys, long timeout) {
        return this.lockManager.lockAll(keys, context.getLockOwner(), timeout, TimeUnit.MILLISECONDS).toInvocationStage().andFinallyMakeStage(context, command, (rCtx, rCommand, rv, throwable) -> {
            if (throwable == null) {
                rCtx.addLockedKeys(keys);
            } else {
                this.lockManager.unlockAll(keys, rCtx.getLockOwner());
            }
        });
    }

    final boolean hasSkipLocking(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    final Object nonTxLockAndInvokeNext(InvocationContext ctx, VisitableCommand command, InvocationStage lockStage, InvocationFinallyAction<VisitableCommand> finallyFunction) {
        return lockStage.andHandle(ctx, command, (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                this.lockManager.unlockAll(rCtx);
                throw throwable;
            }
            return this.invokeNextAndFinally(rCtx, rCommand, finallyFunction);
        });
    }

    private void handleUnlockAll(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) {
        this.lockManager.unlockAll(rCtx);
    }
}

