/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.stream.Stream;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.Ownership;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.IracUtils;
import org.infinispan.util.logging.LogSupplier;

public abstract class AbstractIracLocalSiteInterceptor
extends DDAsyncInterceptor
implements LogSupplier {
    @Inject
    ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    IracVersionGenerator iracVersionGenerator;
    @Inject
    KeyPartitioner keyPartitioner;

    protected static boolean isNormalWriteCommand(WriteCommand command) {
        return !command.hasAnyFlag(FlagBitSets.IRAC_UPDATE);
    }

    protected static boolean isIracState(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.IRAC_STATE);
    }

    static LocalTxInvocationContext asLocalTxInvocationContext(InvocationContext ctx) {
        assert (ctx.isOriginLocal());
        assert (ctx.isInTxScope());
        return (LocalTxInvocationContext)ctx;
    }

    static RemoteTxInvocationContext asRemoteTxInvocationContext(InvocationContext ctx) {
        assert (!ctx.isOriginLocal());
        assert (ctx.isInTxScope());
        return (RemoteTxInvocationContext)ctx;
    }

    static void updateCommandMetadata(Object key, WriteCommand command, IracMetadata iracMetadata) {
        PrivateMetadata interMetadata = PrivateMetadata.getBuilder(command.getInternalMetadata(key)).iracMetadata(iracMetadata).build();
        command.setInternalMetadata(key, interMetadata);
    }

    protected Ownership getOwnership(int segment) {
        return this.getDistributionInfo(segment).writeOwnership();
    }

    protected Ownership getOwnership(Object key) {
        return this.getCacheTopology().getDistribution(key).writeOwnership();
    }

    protected DistributionInfo getDistributionInfo(int segment) {
        return this.getCacheTopology().getSegmentDistribution(segment);
    }

    protected boolean isWriteOwner(StreamData data) {
        return this.getDistributionInfo(data.segment).isWriteOwner();
    }

    protected boolean isPrimaryOwner(StreamData data) {
        return this.getDistributionInfo(data.segment).isPrimary();
    }

    protected LocalizedCacheTopology getCacheTopology() {
        return this.clusteringDependentLogic.getCacheTopology();
    }

    protected int getSegment(WriteCommand command, Object key) {
        return SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
    }

    protected void setMetadataToCacheEntry(CacheEntry<?, ?> entry, IracMetadata metadata) {
        if (entry.isEvicted()) {
            if (this.isTraceEnabled()) {
                this.getLog().tracef("[IRAC] Ignoring evict key: %s", entry.getKey());
            }
            return;
        }
        IracUtils.setIracMetadata(entry, metadata, this.iracVersionGenerator, this);
    }

    protected Stream<StreamData> streamKeysFromModifications(WriteCommand[] mods) {
        return this.streamKeysFromModifications(Stream.of(mods));
    }

    protected Stream<StreamData> streamKeysFromModifications(Stream<WriteCommand> modsStream) {
        return modsStream.filter(AbstractIracLocalSiteInterceptor::isNormalWriteCommand).flatMap(this::streamKeysFromCommand);
    }

    protected Stream<StreamData> streamKeysFromCommand(WriteCommand command) {
        return command.getAffectedKeys().stream().map(key -> new StreamData(key, command, this.getSegment(command, key)));
    }

    static class StreamData {
        final Object key;
        final WriteCommand command;
        final int segment;

        public StreamData(Object key, WriteCommand command, int segment) {
            this.key = key;
            this.command = command;
            this.segment = segment;
        }

        public String toString() {
            return "StreamData{key=" + this.key + ", command=" + this.command + ", segment=" + this.segment + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreamData data = (StreamData)o;
            return this.segment == data.segment && this.key.equals(data.key);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.segment;
            return result;
        }
    }
}

