/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationStateListener;
import org.infinispan.globalstate.impl.ImmutableLocalConfigurationStorage;
import org.infinispan.globalstate.impl.OverlayLocalConfigurationStorage;
import org.infinispan.globalstate.impl.SecurityActions;
import org.infinispan.globalstate.impl.VolatileLocalConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GlobalConfigurationManagerImpl
implements GlobalConfigurationManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String CACHE_SCOPE = "cache";
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    LocalTopologyManager localTopologyManager;
    @Inject
    ConfigurationManager configurationManager;
    @Inject
    InternalCacheRegistry internalCacheRegistry;
    @Inject
    GlobalComponentRegistry globalComponentRegistry;
    @Inject
    BlockingManager blockingManager;
    private Cache<ScopedState, Object> stateCache;
    private ParserRegistry parserRegistry;
    private LocalConfigurationStorage localConfigurationManager;

    @Start
    void start() {
        switch (this.configurationManager.getGlobalConfiguration().globalState().configurationStorage()) {
            case IMMUTABLE: {
                this.localConfigurationManager = new ImmutableLocalConfigurationStorage();
                break;
            }
            case VOLATILE: {
                this.localConfigurationManager = new VolatileLocalConfigurationStorage();
                break;
            }
            case OVERLAY: {
                this.localConfigurationManager = new OverlayLocalConfigurationStorage();
                break;
            }
            default: {
                this.localConfigurationManager = this.configurationManager.getGlobalConfiguration().globalState().configurationStorageClass().get();
            }
        }
        this.internalCacheRegistry.registerInternalCache("org.infinispan.CONFIG", new ConfigurationBuilder().build(), EnumSet.of(InternalCacheRegistry.Flag.GLOBAL));
        this.parserRegistry = new ParserRegistry();
        HashSet<String> staticCacheNames = new HashSet<String>(this.configurationManager.getDefinedCaches());
        log.debugf("Starting statically defined caches: %s", staticCacheNames);
        for (String cacheName2 : this.configurationManager.getDefinedCaches()) {
            SecurityActions.getCache(this.cacheManager, cacheName2);
        }
        this.localConfigurationManager.initialize(this.cacheManager, this.configurationManager, this.blockingManager);
        Map<String, Configuration> persistedConfigurations = this.localConfigurationManager.loadAll();
        GlobalConfigurationStateListener stateCacheListener = new GlobalConfigurationStateListener(this);
        this.getStateCache().addListener(stateCacheListener);
        this.getStateCache().forEach((key, v) -> {
            if (CACHE_SCOPE.equals(key.getScope())) {
                String cacheName = key.getName();
                CacheState cacheState = (CacheState)v;
                Configuration persisted = (Configuration)persistedConfigurations.get(cacheName);
                if (persisted != null) {
                    Configuration configuration = CompletionStages.join(this.buildConfiguration(cacheName, cacheState));
                    if (!persisted.matches(configuration)) {
                        throw Log.CONFIG.incompatibleClusterConfiguration(cacheName, configuration, persisted);
                    }
                    persistedConfigurations.remove(cacheName);
                }
                CompletionStages.join(this.createCacheLocally(cacheName, cacheState));
            }
        });
        persistedConfigurations.forEach((cacheName, configuration) -> {
            Configuration staticConfiguration = this.cacheManager.getCacheConfiguration((String)cacheName);
            if (staticConfiguration != null) {
                if (!staticConfiguration.matches((Configuration)configuration)) {
                    throw Log.CONFIG.incompatiblePersistedConfiguration((String)cacheName, (Configuration)configuration, staticConfiguration);
                }
                persistedConfigurations.remove(cacheName);
            }
            EnumSet<CacheContainerAdmin.AdminFlag> adminFlags = EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class);
            CompletionStages.join(this.getOrCreateCache((String)cacheName, (Configuration)configuration, adminFlags));
        });
    }

    @Override
    public Cache<ScopedState, Object> getStateCache() {
        if (this.stateCache == null) {
            this.stateCache = this.cacheManager.getCache("org.infinispan.CONFIG");
        }
        return this.stateCache;
    }

    @Override
    public CompletableFuture<Configuration> createCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.cacheManager.cacheExists(cacheName)) {
            throw Log.CONFIG.cacheExists(cacheName);
        }
        return this.getOrCreateCache(cacheName, configuration, flags);
    }

    @Override
    public CompletableFuture<Configuration> getOrCreateCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.createCache(cacheName, null, configuration, flags);
    }

    @Override
    public CompletableFuture<Configuration> createCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.cacheManager.cacheExists(cacheName)) {
            throw Log.CONFIG.cacheExists(cacheName);
        }
        return this.getOrCreateCache(cacheName, template, flags);
    }

    @Override
    public CompletableFuture<Configuration> getOrCreateCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration configuration;
        if (template == null) {
            if (this.cacheManager.cacheExists(cacheName)) {
                return CompletableFuture.completedFuture(this.configurationManager.getConfiguration(cacheName, true));
            }
            Optional<String> defaultCacheName = this.configurationManager.getGlobalConfiguration().defaultCacheName();
            configuration = defaultCacheName.isPresent() ? this.configurationManager.getConfiguration(defaultCacheName.get(), true) : null;
            if (configuration == null) {
                configuration = new ConfigurationBuilder().build();
            }
        } else {
            configuration = this.configurationManager.getConfiguration(template, true);
            if (configuration == null) {
                throw Log.CONFIG.undeclaredConfiguration(template, cacheName);
            }
        }
        return this.createCache(cacheName, template, configuration, flags);
    }

    CompletableFuture<Configuration> createCache(String cacheName, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.localConfigurationManager.validateFlags(flags);
        try {
            CacheState state = new CacheState(template, this.parserRegistry.serialize(cacheName, configuration), flags);
            return this.getStateCache().putIfAbsentAsync(new ScopedState(CACHE_SCOPE, cacheName), state).thenApply(v -> configuration);
        }
        catch (Exception e) {
            throw Log.CONFIG.configurationSerializationFailed(cacheName, configuration, e);
        }
    }

    CompletableFuture<Void> createCacheLocally(String name, CacheState state) {
        log.debugf("Starting cache %s from global state", name);
        CompletionStage<Configuration> configurationStage = this.buildConfiguration(name, state);
        return configurationStage.thenCompose(configuration -> this.localConfigurationManager.createCache(name, state.getTemplate(), (Configuration)configuration, state.getFlags())).toCompletableFuture();
    }

    private CompletionStage<Configuration> buildConfiguration(String name, CacheState state) {
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(state.getConfiguration());
        Configuration config = builderHolder.getNamedConfigurationBuilders().get(name).build(this.configurationManager.getGlobalConfiguration());
        return CompletableFuture.completedFuture(config);
    }

    @Override
    public CompletableFuture<Void> removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        ScopedState cacheScopedState = new ScopedState(CACHE_SCOPE, name);
        if (this.getStateCache().containsKey(cacheScopedState)) {
            try {
                this.localTopologyManager.setCacheRebalancingEnabled(name, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.getStateCache().removeAsync(cacheScopedState).thenCompose(r -> CompletableFutures.completedNull());
        }
        return this.localConfigurationManager.removeCache(name, flags);
    }

    CompletableFuture<Void> removeCacheLocally(String name, CacheState state) {
        return this.localConfigurationManager.removeCache(name, state.getFlags());
    }
}

