/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ClassAttributeSerializer;
import org.infinispan.commons.configuration.attributes.CollectionAttributeCopier;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.AllowListConfiguration;
import org.infinispan.configuration.global.WhiteListConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.protostream.SerializationContextInitializer;

public class SerializationConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder((String)"marshaller", null, Marshaller.class).serializer(ClassAttributeSerializer.INSTANCE).immutable().build();
    public static final AttributeDefinition<Map<Integer, AdvancedExternalizer<?>>> ADVANCED_EXTERNALIZERS = AttributeDefinition.builder((String)"advancedExternalizer", null, Map.class).serializer(new AttributeSerializer<Map<Integer, AdvancedExternalizer<?>>, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object getSerializationValue(Attribute<Map<Integer, AdvancedExternalizer<?>>> attribute, ConfigurationInfo configurationElement) {
            return ((Map)attribute.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((AdvancedExternalizer)v.getValue()).getClass().getName()));
        }
    }).copier(CollectionAttributeCopier.INSTANCE).initializer(HashMap::new).immutable().build();
    public static final AttributeDefinition<List<SerializationContextInitializer>> SERIALIZATION_CONTEXT_INITIALIZERS = AttributeDefinition.builder((String)"contextInitializers", null, List.class).serializer((AttributeSerializer)new AttributeSerializer<List<SerializationContextInitializer>, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object getSerializationValue(Attribute<List<SerializationContextInitializer>> attribute, ConfigurationInfo configurationElement) {
            List attributeValue = (List)attribute.get();
            return attributeValue == null ? null : attributeValue.stream().map(s -> s.getClass().getName()).collect(Collectors.toList());
        }
    }).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SERIALIZATION.getLocalName());
    private final Attribute<Map<Integer, AdvancedExternalizer<?>>> advancedExternalizers;
    private final Attribute<Marshaller> marshaller;
    private final Attribute<List<SerializationContextInitializer>> contextInitializers;
    private final AttributeSet attributes;
    private final AllowListConfiguration allowListConfig;
    private final List<ConfigurationInfo> subElements;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SerializationConfiguration.class, new AttributeDefinition[]{MARSHALLER, ADVANCED_EXTERNALIZERS, SERIALIZATION_CONTEXT_INITIALIZERS});
    }

    SerializationConfiguration(AttributeSet attributes, AllowListConfiguration allowListConfig) {
        this.attributes = attributes.checkProtection();
        this.marshaller = attributes.attribute(MARSHALLER);
        this.advancedExternalizers = attributes.attribute(ADVANCED_EXTERNALIZERS);
        this.contextInitializers = attributes.attribute(SERIALIZATION_CONTEXT_INITIALIZERS);
        this.allowListConfig = allowListConfig;
        this.subElements = Collections.singletonList(allowListConfig);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public Marshaller marshaller() {
        return (Marshaller)this.marshaller.get();
    }

    @Deprecated
    public Map<Integer, AdvancedExternalizer<?>> advancedExternalizers() {
        return (Map)this.advancedExternalizers.get();
    }

    public List<SerializationContextInitializer> contextInitializers() {
        return (List)this.contextInitializers.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public AllowListConfiguration allowList() {
        return this.allowListConfig;
    }

    @Deprecated
    public WhiteListConfiguration whiteList() {
        return new WhiteListConfiguration(this.allowListConfig);
    }

    public String toString() {
        return "SerializationConfiguration{attributes=" + this.attributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfiguration that = (SerializationConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

