/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.irac.IracCleanupKeyCommand;
import org.infinispan.commands.irac.IracClearKeysCommand;
import org.infinispan.commands.irac.IracMetadataRequestCommand;
import org.infinispan.commands.irac.IracPutKeyCommand;
import org.infinispan.commands.irac.IracRemoveKeyCommand;
import org.infinispan.commands.irac.IracRequestStateCommand;
import org.infinispan.commands.irac.IracStateResponseCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.CheckTransactionRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.RenewBiasCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.statetransfer.ConflictResolutionStartCommand;
import org.infinispan.commands.statetransfer.ScatteredStateConfirmRevokedCommand;
import org.infinispan.commands.statetransfer.ScatteredStateGetKeysCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferCancelCommand;
import org.infinispan.commands.statetransfer.StateTransferGetListenersCommand;
import org.infinispan.commands.statetransfer.StateTransferGetTransactionsCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commands.topology.CacheAvailabilityUpdateCommand;
import org.infinispan.commands.topology.CacheJoinCommand;
import org.infinispan.commands.topology.CacheLeaveCommand;
import org.infinispan.commands.topology.CacheShutdownCommand;
import org.infinispan.commands.topology.CacheShutdownRequestCommand;
import org.infinispan.commands.topology.CacheStatusRequestCommand;
import org.infinispan.commands.topology.RebalancePhaseConfirmCommand;
import org.infinispan.commands.topology.RebalancePolicyUpdateCommand;
import org.infinispan.commands.topology.RebalanceStartCommand;
import org.infinispan.commands.topology.RebalanceStatusRequestCommand;
import org.infinispan.commands.topology.TopologyUpdateCommand;
import org.infinispan.commands.topology.TopologyUpdateStableCommand;
import org.infinispan.commands.triangle.MultiEntriesFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.MultiKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.PutMapBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.InvalidateVersionsCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.ReplicableManagerFunctionCommand;
import org.infinispan.manager.impl.ReplicableRunnableCommand;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.CancelPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.InitialPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.NextPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.reduction.ReductionPublisherRequestCommand;
import org.infinispan.topology.HeartBeatCommand;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.commands.XSiteAmendOfflineStatusCommand;
import org.infinispan.xsite.commands.XSiteBringOnlineCommand;
import org.infinispan.xsite.commands.XSiteOfflineStatusCommand;
import org.infinispan.xsite.commands.XSiteStateTransferCancelSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferClearStatusCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferRestartSendingCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStatusRequestCommand;
import org.infinispan.xsite.commands.XSiteStatusCommand;
import org.infinispan.xsite.commands.XSiteTakeOfflineCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    GlobalComponentRegistry globalComponentRegistry;
    @Inject
    @ComponentName(value="org.infinispan.modules.command.factories")
    Map<Byte, ModuleCommandFactory> commandFactories;

    public ReplicableCommand fromStream(byte id, byte type) {
        ReplicableCommand command;
        block45: {
            block44: {
                if (type != 0) break block44;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block45;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block45;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block45;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block45;
                    }
                    case 68: {
                        command = new ComputeCommand();
                        break block45;
                    }
                    case 69: {
                        command = new ComputeIfAbsentCommand();
                        break block45;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block45;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block45;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block45;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block45;
                    }
                    case 43: {
                        command = new GetKeysInGroupCommand();
                        break block45;
                    }
                    case 45: {
                        command = new GetCacheEntryCommand();
                        break block45;
                    }
                    case 50: {
                        command = new ReadWriteKeyCommand();
                        break block45;
                    }
                    case 51: {
                        command = new ReadWriteKeyValueCommand();
                        break block45;
                    }
                    case 52: {
                        command = new ReadWriteManyCommand();
                        break block45;
                    }
                    case 53: {
                        command = new ReadWriteManyEntriesCommand();
                        break block45;
                    }
                    case 54: {
                        command = new WriteOnlyKeyCommand();
                        break block45;
                    }
                    case 55: {
                        command = new WriteOnlyKeyValueCommand();
                        break block45;
                    }
                    case 56: {
                        command = new WriteOnlyManyCommand();
                        break block45;
                    }
                    case 57: {
                        command = new WriteOnlyManyEntriesCommand();
                        break block45;
                    }
                    case 58: {
                        command = new RemoveExpiredCommand();
                        break block45;
                    }
                    case 59: {
                        command = new ReplicableRunnableCommand();
                        break block45;
                    }
                    case 60: {
                        command = new ReplicableManagerFunctionCommand();
                        break block45;
                    }
                    case 62: {
                        command = new ReadOnlyKeyCommand();
                        break block45;
                    }
                    case 63: {
                        command = new ReadOnlyManyCommand();
                        break block45;
                    }
                    case 64: {
                        command = new TxReadOnlyKeyCommand();
                        break block45;
                    }
                    case 65: {
                        command = new TxReadOnlyManyCommand();
                        break block45;
                    }
                    case 30: {
                        command = HeartBeatCommand.INSTANCE;
                        break block45;
                    }
                    case 85: {
                        command = new CacheJoinCommand();
                        break block45;
                    }
                    case 86: {
                        command = new CacheLeaveCommand();
                        break block45;
                    }
                    case 87: {
                        command = new RebalancePhaseConfirmCommand();
                        break block45;
                    }
                    case 88: {
                        command = new RebalancePolicyUpdateCommand();
                        break block45;
                    }
                    case 92: {
                        command = new RebalanceStartCommand();
                        break block45;
                    }
                    case 90: {
                        command = new RebalanceStatusRequestCommand();
                        break block45;
                    }
                    case 93: {
                        command = new CacheShutdownRequestCommand();
                        break block45;
                    }
                    case 94: {
                        command = new CacheShutdownCommand();
                        break block45;
                    }
                    case 95: {
                        command = new TopologyUpdateCommand();
                        break block45;
                    }
                    case 96: {
                        command = new CacheStatusRequestCommand();
                        break block45;
                    }
                    case 97: {
                        command = new TopologyUpdateStableCommand();
                        break block45;
                    }
                    case 98: {
                        command = new CacheAvailabilityUpdateCommand();
                        break block45;
                    }
                    case 28: {
                        command = new IracPutKeyValueCommand();
                        break block45;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        return command;
    }

    public CacheRpcCommand fromStream(byte id, byte type, ByteString cacheName) {
        CacheRpcCommand command;
        block62: {
            block61: {
                if (type != 0) break block61;
                switch (id) {
                    case 3: {
                        command = new LockControlCommand(cacheName);
                        break block62;
                    }
                    case 12: {
                        command = new PrepareCommand(cacheName);
                        break block62;
                    }
                    case 26: {
                        command = new VersionedPrepareCommand(cacheName);
                        break block62;
                    }
                    case 14: {
                        command = new CommitCommand(cacheName);
                        break block62;
                    }
                    case 27: {
                        command = new VersionedCommitCommand(cacheName);
                        break block62;
                    }
                    case 13: {
                        command = new RollbackCommand(cacheName);
                        break block62;
                    }
                    case 1: {
                        command = new SingleRpcCommand(cacheName);
                        break block62;
                    }
                    case 16: {
                        command = new ClusteredGetCommand(cacheName);
                        break block62;
                    }
                    case 112: {
                        command = new ConflictResolutionStartCommand(cacheName);
                        break block62;
                    }
                    case 115: {
                        command = new ScatteredStateConfirmRevokedCommand(cacheName);
                        break block62;
                    }
                    case 114: {
                        command = new ScatteredStateGetKeysCommand(cacheName);
                        break block62;
                    }
                    case 117: {
                        command = new StateTransferCancelCommand(cacheName);
                        break block62;
                    }
                    case 116: {
                        command = new StateTransferStartCommand(cacheName);
                        break block62;
                    }
                    case 118: {
                        command = new StateTransferGetListenersCommand(cacheName);
                        break block62;
                    }
                    case 119: {
                        command = new StateTransferGetTransactionsCommand(cacheName);
                        break block62;
                    }
                    case 20: {
                        command = new StateResponseCommand(cacheName);
                        break block62;
                    }
                    case 22: {
                        command = new TxCompletionNotificationCommand(cacheName);
                        break block62;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand(cacheName);
                        break block62;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand(cacheName);
                        break block62;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand(cacheName);
                        break block62;
                    }
                    case 103: {
                        command = new XSiteAmendOfflineStatusCommand(cacheName);
                        break block62;
                    }
                    case 102: {
                        command = new XSiteBringOnlineCommand(cacheName);
                        break block62;
                    }
                    case 99: {
                        command = new XSiteOfflineStatusCommand(cacheName);
                        break block62;
                    }
                    case 100: {
                        command = new XSiteStatusCommand(cacheName);
                        break block62;
                    }
                    case 101: {
                        command = new XSiteTakeOfflineCommand(cacheName);
                        break block62;
                    }
                    case 105: {
                        command = new XSiteStateTransferCancelSendCommand(cacheName);
                        break block62;
                    }
                    case 111: {
                        command = new XSiteStateTransferClearStatusCommand(cacheName);
                        break block62;
                    }
                    case 107: {
                        command = new XSiteStateTransferFinishReceiveCommand(cacheName);
                        break block62;
                    }
                    case 108: {
                        command = new XSiteStateTransferFinishSendCommand(cacheName);
                        break block62;
                    }
                    case 110: {
                        command = new XSiteStateTransferRestartSendingCommand(cacheName);
                        break block62;
                    }
                    case 106: {
                        command = new XSiteStateTransferStartReceiveCommand(cacheName);
                        break block62;
                    }
                    case 104: {
                        command = new XSiteStateTransferStartSendCommand(cacheName);
                        break block62;
                    }
                    case 109: {
                        command = new XSiteStateTransferStatusRequestCommand(cacheName);
                        break block62;
                    }
                    case 33: {
                        command = new XSiteStatePushCommand(cacheName);
                        break block62;
                    }
                    case 40: {
                        command = new SingleXSiteRpcCommand(cacheName);
                        break block62;
                    }
                    case 46: {
                        command = new ClusteredGetAllCommand(cacheName);
                        break block62;
                    }
                    case 76: {
                        command = new SingleKeyBackupWriteCommand(cacheName);
                        break block62;
                    }
                    case 77: {
                        command = new SingleKeyFunctionalBackupWriteCommand(cacheName);
                        break block62;
                    }
                    case 78: {
                        command = new PutMapBackupWriteCommand(cacheName);
                        break block62;
                    }
                    case 79: {
                        command = new MultiEntriesFunctionalBackupWriteCommand(cacheName);
                        break block62;
                    }
                    case 80: {
                        command = new MultiKeyFunctionalBackupWriteCommand(cacheName);
                        break block62;
                    }
                    case 67: {
                        command = new InvalidateVersionsCommand(cacheName);
                        break block62;
                    }
                    case 74: {
                        command = new RevokeBiasCommand(cacheName);
                        break block62;
                    }
                    case 75: {
                        command = new RenewBiasCommand(cacheName);
                        break block62;
                    }
                    case 31: {
                        command = new ReductionPublisherRequestCommand(cacheName);
                        break block62;
                    }
                    case 19: {
                        command = new MultiClusterEventCommand(cacheName);
                        break block62;
                    }
                    case 18: {
                        command = new InitialPublisherCommand(cacheName);
                        break block62;
                    }
                    case 25: {
                        command = new NextPublisherCommand(cacheName);
                        break block62;
                    }
                    case 49: {
                        command = new CancelPublisherCommand(cacheName);
                        break block62;
                    }
                    case 83: {
                        command = new CheckTransactionRpcCommand(cacheName);
                        break block62;
                    }
                    case 66: {
                        command = new TouchCommand(cacheName);
                        break block62;
                    }
                    case 123: {
                        command = new IracPutKeyCommand(cacheName);
                        break block62;
                    }
                    case 122: {
                        command = new IracCleanupKeyCommand(cacheName);
                        break block62;
                    }
                    case 124: {
                        command = new IracMetadataRequestCommand(cacheName);
                        break block62;
                    }
                    case 121: {
                        command = new IracRequestStateCommand(cacheName);
                        break block62;
                    }
                    case 120: {
                        command = new IracStateResponseCommand(cacheName);
                        break block62;
                    }
                    case 15: {
                        command = new IracRemoveKeyCommand(cacheName);
                        break block62;
                    }
                    case 17: {
                        command = new IracClearKeysCommand(cacheName);
                        break block62;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        return command;
    }
}

