/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;

public class Configurations {
    private Configurations() {
    }

    public static boolean isExceptionBasedEviction(Configuration cfg) {
        return cfg.memory().size() > 0L && cfg.memory().evictionStrategy().isExceptionBased();
    }

    public static boolean isOnePhaseCommit(Configuration cfg) {
        if (Configurations.isExceptionBasedEviction(cfg)) {
            return false;
        }
        return !cfg.clustering().cacheMode().isSynchronous() || cfg.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    public static boolean isOnePhaseTotalOrderCommit(Configuration cfg) {
        return false;
    }

    public static boolean isTxVersioned(Configuration cfg) {
        return cfg.transaction().transactionMode().isTransactional() && cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC && cfg.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ && !cfg.clustering().cacheMode().isInvalidation();
    }

    public static boolean noDataLossOnJoiner(Configuration configuration) {
        if (!configuration.clustering().cacheMode().isClustered()) {
            return true;
        }
        if (Configurations.hasSharedCacheLoaderOrWriter(configuration)) {
            return true;
        }
        boolean usingStores = configuration.persistence().usingStores();
        boolean passivation = configuration.persistence().passivation();
        boolean fetchInMemoryState = configuration.clustering().stateTransfer().fetchInMemoryState();
        boolean fetchPersistenceState = configuration.persistence().fetchPersistentState();
        return usingStores && !passivation && (fetchInMemoryState || fetchPersistenceState) || usingStores && passivation && fetchInMemoryState && fetchPersistenceState || !usingStores && fetchInMemoryState;
    }

    public static boolean hasSharedCacheLoaderOrWriter(Configuration configuration) {
        for (StoreConfiguration storeConfiguration : configuration.persistence().stores()) {
            if (!storeConfiguration.shared()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddedMode(GlobalConfiguration globalConfiguration) {
        PrivateGlobalConfiguration config = globalConfiguration.module(PrivateGlobalConfiguration.class);
        return config == null || !config.isServerMode();
    }

    public static boolean isClustered(GlobalConfiguration globalConfiguration) {
        return globalConfiguration.transport().transport() != null;
    }

    public static boolean isStateTransferStore(StoreConfiguration storeConfiguration) {
        return !storeConfiguration.shared() && storeConfiguration.fetchPersistentState();
    }

    public static boolean needSegments(Configuration configuration) {
        CacheMode cacheMode = configuration.clustering().cacheMode();
        boolean transactional = configuration.transaction().transactionMode().isTransactional();
        boolean usingSegmentedStore = configuration.persistence().usingSegmentedStore();
        return cacheMode.isReplicated() || cacheMode.isDistributed() || cacheMode.isScattered() || cacheMode.isInvalidation() && transactional || usingSegmentedStore;
    }

    static Set<Class<? extends StoreConfigurationBuilder<?, ?>>> lookupPersistenceBuilders() {
        Collection parsers = ServiceFinder.load(ConfigurationParser.class, (ClassLoader[])new ClassLoader[]{Configurations.class.getClassLoader(), ParserRegistry.class.getClassLoader()});
        HashSet builders = new HashSet();
        for (ConfigurationParser parser : parsers) {
            Class<? extends ConfigurationBuilderInfo> builderClass = parser.getConfigurationBuilderInfo();
            if (builderClass == null || !AbstractStoreConfigurationBuilder.class.isAssignableFrom(builderClass)) continue;
            builders.add(builderClass);
        }
        return builders;
    }

    public static Metadata newDefaultMetadata(Configuration configuration) {
        return new EmbeddedMetadata.Builder().lifespan(configuration.expiration().lifespan()).maxIdle(configuration.expiration().maxIdle()).build();
    }
}

