/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateTransferFinishSendCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 108;
    private String siteName;
    private boolean statusOk;

    public XSiteStateTransferFinishSendCommand() {
        super(null);
    }

    public XSiteStateTransferFinishSendCommand(ByteString cacheName) {
        this(cacheName, null, false);
    }

    public XSiteStateTransferFinishSendCommand(ByteString cacheName, String siteName, boolean statusOk) {
        super(cacheName);
        this.siteName = siteName;
        this.statusOk = statusOk;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        XSiteStateTransferManager stateTransferManager = registry.getXSiteStateTransferManager().running();
        stateTransferManager.notifyStatePushFinished(this.siteName, this.getOrigin(), this.statusOk);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 108;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.siteName);
        output.writeBoolean(this.statusOk);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.siteName = input.readUTF();
        this.statusOk = input.readBoolean();
    }

    @Override
    public String toString() {
        return "XSiteStateTransferFinishSendCommand{siteName='" + this.siteName + '\'' + ", statusOk=" + this.statusOk + ", cacheName=" + this.cacheName + '}';
    }
}

