/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;

public class GlobalTransaction
implements Cloneable {
    private static final AtomicLong sid = new AtomicLong(0L);
    private long id;
    private Address addr;
    private int hash_code = -1;
    private boolean remote = false;
    private volatile XidImpl xid = null;
    private volatile long internalId = -1L;

    public GlobalTransaction(Address addr, boolean remote) {
        this.id = sid.incrementAndGet();
        this.addr = addr;
        this.remote = remote;
    }

    private GlobalTransaction(long id, Address addr, XidImpl xid, long internalId) {
        this.id = id;
        this.addr = addr;
        this.xid = xid;
        this.internalId = internalId;
    }

    public Address getAddress() {
        return this.addr;
    }

    public long getId() {
        return this.id;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        return this.id == otherGtx.id && Objects.equals(this.addr, otherGtx.addr);
    }

    public final String globalId() {
        return this.getAddress() + ":" + this.getId();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public void setXid(XidImpl xid) {
        this.xid = xid;
    }

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    public String toString() {
        return "GlobalTransaction{id=" + this.id + ", addr=" + Objects.toString(this.addr, "local") + ", remote=" + this.remote + ", xid=" + this.xid + ", internalId=" + this.internalId + '}';
    }

    public static class Externalizer
    implements AdvancedExternalizer<GlobalTransaction> {
        public Set<Class<? extends GlobalTransaction>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{GlobalTransaction.class});
        }

        public Integer getId() {
            return 19;
        }

        public void writeObject(ObjectOutput output, GlobalTransaction gtx) throws IOException {
            output.writeLong(gtx.id);
            output.writeObject(gtx.addr);
            output.writeObject(gtx.xid);
            output.writeLong(gtx.internalId);
        }

        public GlobalTransaction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long id = input.readLong();
            Address addr = (Address)input.readObject();
            XidImpl xid = (XidImpl)input.readObject();
            long internalId = input.readLong();
            return new GlobalTransaction(id, addr, xid, internalId);
        }
    }
}

