/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

public class StreamMarshalling {
    private StreamMarshalling() {
    }

    public static Predicate<Object> equalityPredicate(Object object) {
        return new EqualityPredicate(object);
    }

    public static Predicate<Object> nonNullPredicate() {
        return NonNullPredicate.getInstance();
    }

    public static Predicate<Object> alwaysTruePredicate() {
        return AlwaysTruePredicate.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return EntryToKeyFunction.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, V> entryToValueFunction() {
        return EntryToValueFunction.getInstance();
    }

    public static <T> Function<T, T> identity() {
        return IdentityFunction.getInstance();
    }

    public static <K, V> Function<K, CacheEntry<K, V>> keyToEntryFunction() {
        return new KeyToEntryFunction();
    }

    public static final class StreamMarshallingExternalizer
    implements AdvancedExternalizer<Object> {
        private final Map<Class<? extends Object>, ExternalizerId> objects = new HashMap<Class<? extends Object>, ExternalizerId>();

        public StreamMarshallingExternalizer() {
            for (ExternalizerId id : ExternalizerId.values()) {
                this.objects.put(id.marshalledClass, id);
            }
        }

        public Set<Class<?>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{EqualityPredicate.class, EntryToKeyFunction.class, EntryToValueFunction.class, NonNullPredicate.class, AlwaysTruePredicate.class, KeyToEntryFunction.class, IdentityFunction.class});
        }

        public Integer getId() {
            return 86;
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExternalizerId id = this.objects.get(object.getClass());
            if (id == null) {
                throw new IllegalArgumentException("Unsupported class " + object.getClass() + " was provided!");
            }
            output.writeByte(id.ordinal());
            switch (id) {
                case EQUALITY_PREDICATE: {
                    output.writeObject(((EqualityPredicate)object).object);
                }
            }
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            ExternalizerId[] ids = ExternalizerId.values();
            if (number < 0 || number >= ids.length) {
                throw new IllegalArgumentException("Found invalid number " + number);
            }
            ExternalizerId id = ids[number];
            switch (id) {
                case EQUALITY_PREDICATE: {
                    return new EqualityPredicate(input.readObject());
                }
                case ENTRY_KEY_FUNCTION: {
                    return EntryToKeyFunction.getInstance();
                }
                case ENTRY_VALUE_FUNCTION: {
                    return EntryToValueFunction.getInstance();
                }
                case NON_NULL_PREDICATE: {
                    return NonNullPredicate.getInstance();
                }
                case ALWAYS_TRUE_PREDICATE: {
                    return AlwaysTruePredicate.getInstance();
                }
                case KEY_ENTRY_FUNCTION: {
                    return new KeyToEntryFunction();
                }
                case IDENTITY_FUNCTION: {
                    return IdentityFunction.getInstance();
                }
            }
            throw new IllegalArgumentException("ExternalizerId not supported: " + (Object)((Object)id));
        }

        static enum ExternalizerId {
            EQUALITY_PREDICATE(EqualityPredicate.class),
            ENTRY_KEY_FUNCTION(EntryToKeyFunction.class),
            ENTRY_VALUE_FUNCTION(EntryToValueFunction.class),
            NON_NULL_PREDICATE(NonNullPredicate.class),
            ALWAYS_TRUE_PREDICATE(AlwaysTruePredicate.class),
            KEY_ENTRY_FUNCTION(KeyToEntryFunction.class),
            IDENTITY_FUNCTION(IdentityFunction.class);

            private final Class<? extends Object> marshalledClass;

            private ExternalizerId(Class<? extends Object> marshalledClass) {
                this.marshalledClass = marshalledClass;
            }
        }
    }

    private static final class IdentityFunction<T>
    implements Function<T, T> {
        private static final IdentityFunction<?> FUNCTION = new IdentityFunction();

        private IdentityFunction() {
        }

        public static <T> IdentityFunction<T> getInstance() {
            return FUNCTION;
        }

        @Override
        public T apply(T t) {
            return t;
        }
    }

    @Scope(value=Scopes.NONE)
    static final class KeyToEntryFunction<K, V>
    implements Function<K, CacheEntry<K, V>> {
        @Inject
        AdvancedCache<K, V> advancedCache;

        KeyToEntryFunction() {
        }

        @Override
        public CacheEntry<K, V> apply(K k) {
            return this.advancedCache.getCacheEntry(k);
        }
    }

    private static final class EntryToValueFunction<K, V>
    implements Function<Map.Entry<K, V>, V> {
        private static final EntryToValueFunction<?, ?> FUNCTION = new EntryToValueFunction();

        private EntryToValueFunction() {
        }

        public static <K, V> EntryToValueFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public V apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getValue();
        }
    }

    private static final class EntryToKeyFunction<K, V>
    implements Function<Map.Entry<K, V>, K> {
        private static final EntryToKeyFunction<?, ?> FUNCTION = new EntryToKeyFunction();

        private EntryToKeyFunction() {
        }

        public static <K, V> EntryToKeyFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public K apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getKey();
        }
    }

    private static final class AlwaysTruePredicate
    implements Predicate<Object> {
        private static final AlwaysTruePredicate INSTANCE = new AlwaysTruePredicate();

        private AlwaysTruePredicate() {
        }

        public static AlwaysTruePredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t) {
            return true;
        }
    }

    private static final class NonNullPredicate
    implements Predicate<Object> {
        private static final NonNullPredicate INSTANCE = new NonNullPredicate();

        private NonNullPredicate() {
        }

        public static NonNullPredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t) {
            return t != null;
        }
    }

    private static final class EqualityPredicate
    implements Predicate<Object> {
        private final Object object;

        private EqualityPredicate(Object object) {
            Objects.nonNull(object);
            this.object = object;
        }

        @Override
        public boolean test(Object t) {
            return this.object.equals(t);
        }
    }
}

