/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.util.logging.Log;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.StackType;

public class EmbeddedJGroupsChannelConfigurator
implements JGroupsChannelConfigurator {
    private static final String PROTOCOL_PREFIX = "org.jgroups.protocols.";
    private final String name;
    final List<ProtocolConfiguration> stack;
    final Map<String, JGroupsChannelConfigurator> remoteSites;

    public EmbeddedJGroupsChannelConfigurator(String name, List<ProtocolConfiguration> stack) {
        this.name = name;
        this.stack = stack;
        this.remoteSites = new HashMap<String, JGroupsChannelConfigurator>(2);
    }

    public EmbeddedJGroupsChannelConfigurator(String name) {
        this(name, new ArrayList<ProtocolConfiguration>());
    }

    public String getProtocolStackString() {
        return this.stack.toString();
    }

    public List<ProtocolConfiguration> getProtocolStack() {
        return this.stack;
    }

    public Map<String, JGroupsChannelConfigurator> getRemoteSites() {
        return this.remoteSites;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JChannel createChannel() throws Exception {
        StackType stackType = org.jgroups.util.Util.getIpStackType();
        ArrayList<Protocol> protocols = new ArrayList<Protocol>(this.stack.size());
        for (ProtocolConfiguration c : this.stack) {
            Protocol protocol;
            try {
                String className = PROTOCOL_PREFIX + c.getProtocolName();
                protocol = (Protocol)Util.getInstanceStrict((String)className, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                protocol = (Protocol)Util.getInstanceStrict((String)c.getProtocolName(), (ClassLoader)this.getClass().getClassLoader());
            }
            ProtocolConfiguration configuration = new ProtocolConfiguration(protocol.getName(), c.getProperties());
            Configurator.initializeAttrs((Protocol)protocol, (ProtocolConfiguration)configuration, (StackType)stackType);
            protocols.add(protocol);
            if (!(protocol instanceof RELAY2)) continue;
            RELAY2 relay2 = (RELAY2)protocol;
            if (relay2 != null) {
                if (this.remoteSites.size() == 0) {
                    throw Log.CONFIG.jgroupsRelayWithoutRemoteSites(this.name);
                }
                for (Map.Entry<String, JGroupsChannelConfigurator> remoteSite : this.remoteSites.entrySet()) {
                    final JGroupsChannelConfigurator remoteSiteChannel = remoteSite.getValue();
                    RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(remoteSite.getKey());
                    siteConfig.addBridge(new RelayConfig.BridgeConfig(remoteSiteChannel.getName()){

                        public JChannel createChannel() throws Exception {
                            return remoteSiteChannel.createChannel();
                        }
                    });
                    relay2.addSite(remoteSite.getKey(), siteConfig);
                }
                continue;
            }
            if (this.remoteSites.size() <= 0) continue;
            throw Log.CONFIG.jgroupsRemoteSitesWithoutRelay(this.name);
        }
        return new JChannel(protocols);
    }

    public void addRemoteSite(String remoteSite, JGroupsChannelConfigurator stackConfigurator) {
        if (this.remoteSites.containsKey(remoteSite)) {
            throw Log.CONFIG.duplicateRemoteSite(remoteSite, this.name);
        }
        this.remoteSites.put(remoteSite, stackConfigurator);
    }

    public static EmbeddedJGroupsChannelConfigurator combine(JGroupsChannelConfigurator baseStack, EmbeddedJGroupsChannelConfigurator stack) {
        ArrayList<ProtocolConfiguration> actualStack = new ArrayList<ProtocolConfiguration>();
        for (ProtocolConfiguration originalProtocol : baseStack.getProtocolStack()) {
            ProtocolConfiguration protocol = new ProtocolConfiguration(originalProtocol.getProtocolName(), new HashMap(originalProtocol.getProperties()));
            actualStack.add(protocol);
        }
        for (ProtocolConfiguration protocol : stack.stack) {
            String protocolName = protocol.getProtocolName();
            int position = EmbeddedJGroupsChannelConfigurator.findProtocol(protocolName, actualStack);
            StackCombine mode = position < 0 ? StackCombine.APPEND : StackCombine.COMBINE;
            String stackCombine = (String)protocol.getProperties().remove("stack.combine");
            if (stackCombine != null) {
                mode = StackCombine.valueOf(stackCombine);
            }
            String stackPosition = (String)protocol.getProperties().remove("stack.position");
            switch (mode) {
                case APPEND: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    actualStack.add(protocol);
                    break;
                }
                case COMBINE: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    ((ProtocolConfiguration)actualStack.get(position)).getProperties().putAll(protocol.getProperties());
                    break;
                }
                case REMOVE: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    actualStack.remove(position);
                    break;
                }
                case REPLACE: {
                    if (stackPosition != null) {
                        position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                        EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    } else {
                        EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    }
                    actualStack.set(position, protocol);
                    break;
                }
                case INSERT_AFTER: {
                    if (stackPosition == null) {
                        throw Log.CONFIG.jgroupsInsertAfterRequiresPosition(protocolName);
                    }
                    position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    actualStack.add(position + 1, protocol);
                }
            }
        }
        EmbeddedJGroupsChannelConfigurator newStack = new EmbeddedJGroupsChannelConfigurator(stack.getName(), actualStack);
        newStack.remoteSites.putAll(stack.remoteSites);
        return newStack;
    }

    private static void assertNoStackPosition(StackCombine mode, String stackAfter) {
        if (stackAfter != null) {
            throw Log.CONFIG.jgroupsNoStackPosition(mode.name());
        }
    }

    private static void assertExisting(StackCombine mode, String protocolName, int position) {
        if (position < 0) {
            throw Log.CONFIG.jgroupsNoSuchProtocol(protocolName, mode.name());
        }
    }

    private static int findProtocol(String protocol, List<ProtocolConfiguration> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!protocol.equals(stack.get(i).getProtocolName())) continue;
            return i;
        }
        return -1;
    }

    public static enum StackCombine {
        COMBINE,
        INSERT_AFTER,
        REPLACE,
        REMOVE,
        APPEND;

    }
}

