/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

public interface RpcManager {
    public <T> CompletionStage<T> invokeCommand(Address var1, ReplicableCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> CompletionStage<T> invokeCommand(Collection<Address> var1, ReplicableCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand var1, ResponseCollector<T> var2, RpcOptions var3);

    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> var1, ReplicableCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> CompletionStage<T> invokeCommands(Collection<Address> var1, Function<Address, ReplicableCommand> var2, ResponseCollector<T> var3, RpcOptions var4);

    public <T> T blocking(CompletionStage<T> var1);

    @Deprecated
    default public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        Collection<Address> targets = recipients != null ? recipients : this.getTransport().getMembers();
        MapResponseCollector collector = MapResponseCollector.ignoreLeavers(false, targets.size());
        return this.invokeCommand(recipients, rpc, collector, options).toCompletableFuture();
    }

    public void sendTo(Address var1, ReplicableCommand var2, DeliverOrder var3);

    public void sendToMany(Collection<Address> var1, ReplicableCommand var2, DeliverOrder var3);

    public void sendToAll(ReplicableCommand var1, DeliverOrder var2);

    public XSiteResponse invokeXSite(XSiteBackup var1, XSiteReplicateCommand var2);

    public Transport getTransport();

    public List<Address> getMembers();

    public Address getAddress();

    public int getTopologyId();

    public RpcOptions getSyncRpcOptions();

    default public RpcOptions getTotalSyncRpcOptions() {
        throw new UnsupportedOperationException();
    }
}

