/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedRepeatableReadEntry
extends RepeatableReadEntry {
    private static final Log log = LogFactory.getLog(VersionedRepeatableReadEntry.class);
    private static final boolean trace = log.isTraceEnabled();

    public VersionedRepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
    }

    public CompletionStage<Boolean> performWriteSkewCheck(EntryLoader entryLoader, int segment, TxInvocationContext ctx, EntryVersion versionSeen, VersionGenerator versionGenerator, boolean rollingUpgrade) {
        CompletionStage<IncrementableEntryVersion> entryStage;
        if (versionSeen == null) {
            if (trace) {
                log.tracef("Perform write skew check for key %s but the key was not read. Skipping check!", Util.toStr((Object)this.key));
            }
            return CompletableFutures.completedTrue();
        }
        if (ctx.isOriginLocal()) {
            entryStage = this.getCurrentEntryVersion(entryLoader, segment, ctx, versionGenerator, rollingUpgrade);
        } else {
            IncrementableEntryVersion prevVersion2 = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead().get(this.key);
            if (prevVersion2 == null) {
                entryStage = this.getCurrentEntryVersion(entryLoader, segment, ctx, versionGenerator, rollingUpgrade);
            } else {
                return CompletableFutures.booleanStage(this.skewed(prevVersion2, versionSeen, versionGenerator));
            }
        }
        return entryStage.thenApply(prevVersion -> this.skewed((IncrementableEntryVersion)prevVersion, versionSeen, versionGenerator));
    }

    private boolean skewed(IncrementableEntryVersion prevVersion, EntryVersion versionSeen, VersionGenerator versionGenerator) {
        if (this.isExpired() && prevVersion == versionGenerator.nonExistingVersion()) {
            return true;
        }
        InequalVersionComparisonResult result = prevVersion.compareTo(versionSeen);
        if (trace) {
            log.tracef("Comparing versions %s and %s for key %s: %s", new Object[]{prevVersion, versionSeen, this.key, result});
        }
        return InequalVersionComparisonResult.EQUAL == result;
    }

    private CompletionStage<IncrementableEntryVersion> getCurrentEntryVersion(EntryLoader entryLoader, int segment, TxInvocationContext ctx, VersionGenerator versionGenerator, boolean rollingUpgrade) {
        CompletionStage entry = entryLoader.loadAndStoreInDataContainer(ctx, this.getKey(), segment, null);
        return entry.thenApply(ice -> {
            IncrementableEntryVersion prevVersion;
            if (ice == null) {
                if (trace) {
                    log.tracef("No entry for key %s found in data container", Util.toStr((Object)this.key));
                }
                return versionGenerator.nonExistingVersion();
            }
            if (trace) {
                log.tracef("Entry found in data container: %s", Util.toStr((Object)ice));
            }
            if ((prevVersion = WriteSkewHelper.versionFromEntry(ice)) == null) {
                if (rollingUpgrade) {
                    return versionGenerator.nonExistingVersion();
                }
                throw new IllegalStateException("Entries cannot have null versions!");
            }
            return prevVersion;
        });
    }

    @Override
    public VersionedRepeatableReadEntry clone() {
        return (VersionedRepeatableReadEntry)super.clone();
    }
}

