/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.util.logging.Log;

public class ConfigurationBuilderHolder {
    private final GlobalConfigurationBuilder globalConfigurationBuilder;
    private final Map<String, ConfigurationBuilder> namedConfigurationBuilders;
    private ConfigurationBuilder currentConfigurationBuilder;
    private final Map<Class<? extends ConfigurationParser>, ParserContext> parserContexts;
    private final WeakReference<ClassLoader> classLoader;
    private final Deque<String> scope;
    private final JGroupsConfigurationBuilder jgroupsBuilder;

    public ConfigurationBuilderHolder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ConfigurationBuilderHolder(ClassLoader classLoader) {
        this(classLoader, new GlobalConfigurationBuilder());
    }

    public ConfigurationBuilderHolder(ClassLoader classLoader, GlobalConfigurationBuilder globalConfigurationBuilder) {
        this.globalConfigurationBuilder = globalConfigurationBuilder;
        this.namedConfigurationBuilders = new HashMap<String, ConfigurationBuilder>();
        this.parserContexts = new HashMap<Class<? extends ConfigurationParser>, ParserContext>();
        this.jgroupsBuilder = this.globalConfigurationBuilder.transport().jgroups();
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.scope = new ArrayDeque<String>();
        this.scope.push(ParserScope.GLOBAL.name());
    }

    public GlobalConfigurationBuilder getGlobalConfigurationBuilder() {
        return this.globalConfigurationBuilder;
    }

    public ConfigurationBuilder newConfigurationBuilder(String name) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.namedConfigurationBuilders.put(name, builder);
        this.currentConfigurationBuilder = builder;
        return builder;
    }

    public Map<String, ConfigurationBuilder> getNamedConfigurationBuilders() {
        return this.namedConfigurationBuilders;
    }

    public ConfigurationBuilder getCurrentConfigurationBuilder() {
        return this.currentConfigurationBuilder;
    }

    public ConfigurationBuilder getDefaultConfigurationBuilder() {
        if (this.globalConfigurationBuilder.defaultCacheName().isPresent()) {
            return this.namedConfigurationBuilders.get(this.globalConfigurationBuilder.defaultCacheName().get());
        }
        return null;
    }

    void pushScope(Enum<?> scope) {
        this.pushScope(scope.name());
    }

    public void pushScope(String scope) {
        this.scope.push(scope);
    }

    public String popScope() {
        return this.scope.pop();
    }

    public boolean inScope(String scope) {
        return this.getScope().equals(scope);
    }

    public boolean inScope(Enum<?> scope) {
        return this.inScope(scope.name());
    }

    public String getScope() {
        return this.scope.peek();
    }

    public <T extends ParserContext> T getParserContext(Class<? extends ConfigurationParser> parserClass) {
        return (T)this.parserContexts.get(parserClass);
    }

    public void setParserContext(Class<? extends ConfigurationParser> parserClass, ParserContext context) {
        this.parserContexts.put(parserClass, context);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    Map<Class<? extends ConfigurationParser>, ParserContext> getParserContexts() {
        return this.parserContexts;
    }

    public void validate() {
        this.globalConfigurationBuilder.defaultCacheName().ifPresent(name -> {
            if (!this.namedConfigurationBuilders.containsKey(name)) {
                throw Log.CONFIG.missingDefaultCacheDeclaration((String)name);
            }
        });
    }

    public void addJGroupsStack(FileJGroupsChannelConfigurator stack) {
        String name = stack.getName();
        if (this.jgroupsBuilder.getStack(name) != null) {
            throw Log.CONFIG.duplicateJGroupsStack(name);
        }
        this.jgroupsBuilder.addStackFile(name).fileChannelConfigurator(stack);
    }

    public void addJGroupsStack(EmbeddedJGroupsChannelConfigurator stack, String extend) {
        String name = stack.getName();
        if (this.jgroupsBuilder.getStack(name) != null) {
            throw Log.CONFIG.duplicateJGroupsStack(name);
        }
        if (extend == null) {
            this.jgroupsBuilder.addStack(stack.getName()).channelConfigurator(stack);
        } else {
            if (this.jgroupsBuilder.getStack(extend) == null) {
                throw Log.CONFIG.missingJGroupsStack(extend);
            }
            JGroupsChannelConfigurator baseStack = this.jgroupsBuilder.getStack(extend);
            this.jgroupsBuilder.addStack(stack.getName()).channelConfigurator(EmbeddedJGroupsChannelConfigurator.combine(baseStack, stack));
        }
    }

    JGroupsChannelConfigurator getJGroupsStack(String name) {
        return this.jgroupsBuilder.getStack(name);
    }
}

