/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class XSiteStatePushCommand
extends XSiteReplicateCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 33;
    private XSiteState[] chunk;
    private long timeoutMillis;
    private XSiteStateConsumer consumer;

    public XSiteStatePushCommand(ByteString cacheName, XSiteState[] chunk, long timeoutMillis) {
        super(cacheName);
        this.chunk = chunk;
        this.timeoutMillis = timeoutMillis;
    }

    public XSiteStatePushCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public CompletionStage<Void> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        assert (!preserveOrder);
        return receiver.handleStateTransferState(this);
    }

    public XSiteStatePushCommand() {
        super(null);
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.consumer = componentRegistry.getXSiteStateTransferManager().running().getStateConsumer();
    }

    public XSiteState[] getChunk() {
        return this.chunk;
    }

    public long getTimeout() {
        return this.timeoutMillis;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.consumer.applyState(this.chunk);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 33;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.timeoutMillis);
        MarshallUtil.marshallArray((Object[])this.chunk, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.timeoutMillis = input.readLong();
        this.chunk = (XSiteState[])MarshallUtil.unmarshallArray((ObjectInput)input, XSiteState[]::new);
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteStatePushCommand{cacheName=" + this.cacheName + ", timeout=" + this.timeoutMillis + " (" + this.chunk.length + " keys)" + '}';
    }
}

