/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Version;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalCacheStatus;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.topology.TopologyManagementHelper;
import org.infinispan.util.concurrent.ActionSequencer;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="LocalTopologyManager", description="Controls the cache membership and state transfer")
@Scope(value=Scopes.GLOBAL)
public class LocalTopologyManagerImpl
implements LocalTopologyManager,
GlobalStateProvider {
    private static Log log = LogFactory.getLog(LocalTopologyManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    Transport transport;
    @Inject
    @ComponentName(value="org.infinispan.executors.transport")
    ExecutorService asyncTransportExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;
    @Inject
    GlobalComponentRegistry gcr;
    @Inject
    TimeService timeService;
    @Inject
    GlobalStateManager globalStateManager;
    @Inject
    PersistentUUIDManager persistentUUIDManager;
    @Inject
    ClusterTopologyManager clusterTopologyManager;
    private TopologyManagementHelper helper;
    private ActionSequencer actionSequencer;
    private final Map<String, LocalCacheStatus> runningCaches = Collections.synchronizedMap(new HashMap());
    private volatile boolean running;
    @GuardedBy(value="runningCaches")
    private int latestStatusResponseViewId;
    private PersistentUUID persistentUUID;

    @Start(priority=0)
    public void preStart() {
        this.helper = new TopologyManagementHelper(this.gcr.getComponent(BasicComponentRegistry.class));
        this.actionSequencer = new ActionSequencer(this.asyncTransportExecutor, true, this.timeService);
        if (this.globalStateManager != null) {
            this.globalStateManager.registerStateProvider(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Start(priority=100)
    public void start() {
        if (trace) {
            log.tracef("Starting LocalTopologyManager on %s", this.transport.getAddress());
        }
        if (this.persistentUUID == null) {
            this.persistentUUID = PersistentUUID.randomUUID();
            this.globalStateManager.writeGlobalState();
        }
        this.persistentUUIDManager.addPersistentAddressMapping(this.transport.getAddress(), this.persistentUUID);
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            this.latestStatusResponseViewId = this.transport.getViewId();
        }
        this.running = true;
    }

    @Stop(priority=110)
    public void stop() {
        if (trace) {
            log.tracef("Stopping LocalTopologyManager on %s", this.transport.getAddress());
        }
        this.running = false;
    }

    @Override
    public CompletionStage<CacheTopology> join(String cacheName, CacheJoinInfo joinInfo, CacheTopologyHandler stm, PartitionHandlingManager phm) {
        log.debugf("Node %s joining cache %s", this.transport.getAddress(), cacheName);
        LocalCacheStatus cacheStatus = new LocalCacheStatus(cacheName, joinInfo, stm, phm);
        LocalCacheStatus previousStatus = this.runningCaches.put(cacheName, cacheStatus);
        if (previousStatus != null) {
            throw new IllegalStateException("A cache can only join once");
        }
        return this.orderOnCache(cacheName, () -> {
            long timeout = joinInfo.getTimeout();
            long endTime = this.timeService.expectedEndTime(timeout, TimeUnit.MILLISECONDS);
            return this.sendJoinRequest(cacheName, joinInfo, timeout, endTime).thenCompose(joinResponse -> this.handleJoinResponse(cacheName, cacheStatus, (CacheStatusResponse)joinResponse));
        });
    }

    public CompletionStage<CacheStatusResponse> sendJoinRequest(String cacheName, CacheJoinInfo joinInfo, long timeout, long endTime) {
        int viewId = this.transport.getViewId();
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.JOIN, this.transport.getAddress(), joinInfo, viewId);
        return CompletionStages.handleAndCompose(this.helper.executeOnCoordinator(this.transport, command, timeout), (response, throwable) -> {
            int currentViewId = this.transport.getViewId();
            if (viewId != currentViewId) {
                log.tracef("Received new view %d before join response for cache %s, retrying", currentViewId);
                return this.sendJoinRequest(cacheName, joinInfo, timeout, endTime);
            }
            if (throwable == null) {
                if (response != null) {
                    return CompletableFuture.completedFuture((CacheStatusResponse)response);
                }
                log.debugf("Coordinator sent a null join response, retrying in view %d", viewId + 1);
                return this.retryJoinInView(cacheName, joinInfo, timeout, endTime, viewId + 1);
            }
            Throwable t = CompletableFutures.extractException(throwable);
            if (t instanceof MarshallingException || t instanceof NotSerializableException) {
                throw new CacheJoinException(t);
            }
            if (t instanceof SuspectException) {
                log.debugf("Join request received CacheNotFoundResponse for cache %s, retrying", cacheName);
            } else {
                if (t.getCause() != null && t.getCause() instanceof CacheJoinException) {
                    log.debugf(t, "Join request failed for cache %s", cacheName);
                    throw (CacheJoinException)((Object)((Object)t.getCause()));
                }
                if (this.timeService.isTimeExpired(endTime)) {
                    log.debugf(t, "Join request timed out for cache %s", cacheName);
                    throw CompletableFutures.asCompletionException(t);
                }
                log.debugf(t, "Join request got an error for cache %s, retrying", cacheName);
            }
            long delay = 100L;
            return CompletionStages.scheduleNonBlocking(() -> this.sendJoinRequest(cacheName, joinInfo, timeout, endTime), this.timeoutExecutor, delay, TimeUnit.MILLISECONDS);
        });
    }

    private CompletionStage<CacheStatusResponse> retryJoinInView(String cacheName, CacheJoinInfo joinInfo, long timeout, long endTime, int viewId) {
        return this.withView(viewId, timeout, TimeUnit.MILLISECONDS).thenCompose(v -> this.sendJoinRequest(cacheName, joinInfo, timeout, endTime));
    }

    public CompletionStage<CacheTopology> handleJoinResponse(String cacheName, LocalCacheStatus cacheStatus, CacheStatusResponse initialStatus) {
        int viewId = this.transport.getViewId();
        return this.doHandleTopologyUpdate(cacheName, initialStatus.getCacheTopology(), initialStatus.getAvailabilityMode(), viewId, this.transport.getCoordinator(), cacheStatus).thenCompose(applied -> {
            if (!applied.booleanValue()) {
                throw new IllegalStateException("We already had a newer topology by the time we received the join response");
            }
            return this.doHandleStableTopologyUpdate(cacheName, initialStatus.getStableTopology(), viewId, this.transport.getCoordinator(), cacheStatus);
        }).thenApply(ignored -> initialStatus.getCacheTopology());
    }

    @Override
    public void leave(String cacheName, long timeout) {
        log.debugf("Node %s leaving cache %s", this.transport.getAddress(), cacheName);
        this.runningCaches.remove(cacheName);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.LEAVE, this.transport.getAddress(), this.transport.getViewId());
        try {
            CompletionStages.join(this.helper.executeOnCoordinator(this.transport, command, timeout));
        }
        catch (Exception e) {
            log.debugf(e, "Error sending the leave request for cache %s to coordinator", cacheName);
        }
    }

    @Override
    public void confirmRebalancePhase(String cacheName, int topologyId, int rebalanceId, Throwable throwable) {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCE_PHASE_CONFIRM, this.transport.getAddress(), topologyId, rebalanceId, throwable, this.transport.getViewId());
        try {
            this.helper.executeOnCoordinatorAsync(this.transport, command);
        }
        catch (Exception e) {
            log.debugf(e, "Error sending the rebalance completed notification for cache %s to the coordinator", cacheName);
        }
    }

    @Override
    public CompletionStage<ManagerStatusResponse> handleStatusRequest(int viewId) {
        return this.withView(viewId, this.getGlobalTimeout(), TimeUnit.MILLISECONDS).thenApply(ignored -> {
            HashMap<String, CacheStatusResponse> caches = new HashMap<String, CacheStatusResponse>();
            Map<String, LocalCacheStatus> map = this.runningCaches;
            synchronized (map) {
                this.latestStatusResponseViewId = viewId;
                for (Map.Entry<String, LocalCacheStatus> e : this.runningCaches.entrySet()) {
                    String cacheName = e.getKey();
                    LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
                    if (cacheStatus.getCurrentTopology() == null) continue;
                    caches.put(e.getKey(), new CacheStatusResponse(cacheStatus.getJoinInfo(), cacheStatus.getCurrentTopology(), cacheStatus.getStableTopology(), cacheStatus.getPartitionHandlingManager().getAvailabilityMode()));
                }
            }
            boolean rebalancingEnabled = true;
            CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), this.transport.getViewId());
            try {
                this.gcr.wireDependencies(command);
                SuccessfulResponse response = (SuccessfulResponse)command.invoke();
                rebalancingEnabled = (Boolean)response.getResponseValue();
            }
            catch (Throwable t) {
                log.warn("Failed to obtain the rebalancing status", t);
            }
            log.debugf("Sending cluster status response for view %d", viewId);
            return new ManagerStatusResponse(caches, rebalancingEnabled);
        });
    }

    @Override
    public CompletionStage<Void> handleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender) {
        if (!this.running) {
            log.tracef("Ignoring consistent hash update %s for cache %s, the local cache manager is not running", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring consistent hash update %s for cache %s that doesn't exist locally", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        return this.withView(viewId, cacheStatus.getJoinInfo().getTimeout(), TimeUnit.MILLISECONDS).thenCompose(ignored -> this.orderOnCache(cacheName, () -> this.doHandleTopologyUpdate(cacheName, cacheTopology, availabilityMode, viewId, sender, cacheStatus))).handle((ignored, throwable) -> {
            if (throwable != null && !(throwable instanceof IllegalLifecycleStateException)) {
                log.topologyUpdateError(cacheName, (Throwable)throwable);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Boolean> doHandleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        ConsistentHash unionCH;
        CacheTopology existingTopology;
        LocalCacheStatus localCacheStatus = cacheStatus;
        synchronized (localCacheStatus) {
            if (cacheTopology == null) {
                return CompletableFutures.completedTrue();
            }
            this.registerPersistentUUID(cacheTopology);
            existingTopology = cacheStatus.getCurrentTopology();
            if (existingTopology != null && cacheTopology.getTopologyId() <= existingTopology.getTopologyId()) {
                log.debugf("Ignoring late consistent hash update for cache %s, current topology is %s: %s", cacheName, existingTopology.getTopologyId(), cacheTopology);
                return CompletableFutures.completedFalse();
            }
            if (!this.updateCacheTopology(cacheName, cacheTopology, viewId, sender, cacheStatus)) {
                return CompletableFutures.completedFalse();
            }
        }
        CacheTopologyHandler handler = cacheStatus.getHandler();
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        if (pendingCH != null) {
            ConsistentHashFactory chf = cacheStatus.getJoinInfo().getConsistentHashFactory();
            switch (cacheTopology.getPhase()) {
                case READ_NEW_WRITE_ALL: {
                    unionCH = chf.union(pendingCH, currentCH);
                    break;
                }
                default: {
                    unionCH = chf.union(currentCH, pendingCH);
                    break;
                }
            }
        } else {
            unionCH = null;
        }
        List<PersistentUUID> persistentUUIDs = this.persistentUUIDManager.mapAddresses(cacheTopology.getActualMembers());
        CacheTopology unionTopology = new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), currentCH, pendingCH, unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), persistentUUIDs);
        boolean updateAvailabilityModeFirst = availabilityMode != AvailabilityMode.AVAILABLE;
        CompletionStage<Void> stage = this.resetLocalTopologyBeforeRebalance(cacheName, cacheTopology, existingTopology, handler);
        stage = stage.thenCompose(ignored -> {
            unionTopology.logRoutingTableInformation();
            if (updateAvailabilityModeFirst && availabilityMode != null) {
                return cacheStatus.getPartitionHandlingManager().setAvailabilityMode(availabilityMode);
            }
            return CompletableFutures.completedNull();
        });
        stage = stage.thenCompose(ignored -> {
            boolean startConflictResolution;
            boolean bl = startConflictResolution = cacheTopology.getPhase() == CacheTopology.Phase.CONFLICT_RESOLUTION;
            if (!(startConflictResolution || unionCH == null || existingTopology != null && existingTopology.getRebalanceId() == cacheTopology.getRebalanceId())) {
                log.tracef("This topology update has a pending CH, starting the rebalance now", new Object[0]);
                return handler.rebalance(unionTopology);
            }
            return handler.updateConsistentHash(unionTopology);
        });
        if (!updateAvailabilityModeFirst) {
            stage = stage.thenCompose(ignored -> cacheStatus.getPartitionHandlingManager().setAvailabilityMode(availabilityMode));
        }
        return stage.thenApply(ignored -> true);
    }

    private void registerPersistentUUID(CacheTopology cacheTopology) {
        int count = cacheTopology.getActualMembers().size();
        for (int i = 0; i < count; ++i) {
            this.persistentUUIDManager.addPersistentAddressMapping(cacheTopology.getActualMembers().get(i), cacheTopology.getMembersPersistentUUIDs().get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCacheTopology(String cacheName, CacheTopology cacheTopology, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            if (!this.validateCommandViewId(cacheTopology, viewId, sender, cacheName)) {
                return false;
            }
            log.debugf("Updating local topology for cache %s: %s", cacheName, cacheTopology);
            cacheStatus.setCurrentTopology(cacheTopology);
            return true;
        }
    }

    @GuardedBy(value="runningCaches")
    private boolean validateCommandViewId(CacheTopology cacheTopology, int viewId, Address sender, String cacheName) {
        if (!sender.equals(this.transport.getCoordinator())) {
            log.debugf("Ignoring topology %d for cache %s from old coordinator %s", cacheTopology.getTopologyId(), cacheName, sender);
            return false;
        }
        if (viewId < this.latestStatusResponseViewId) {
            log.debugf("Ignoring topology %d for cache %s from view %d received after status request from view %d", new Object[]{cacheTopology.getTopologyId(), cacheName, viewId, this.latestStatusResponseViewId});
            return false;
        }
        return true;
    }

    private CompletionStage<Void> resetLocalTopologyBeforeRebalance(String cacheName, CacheTopology newCacheTopology, CacheTopology oldCacheTopology, CacheTopologyHandler handler) {
        boolean newRebalance;
        boolean bl = newRebalance = newCacheTopology.getPhase() != CacheTopology.Phase.NO_REBALANCE && newCacheTopology.getPhase() != CacheTopology.Phase.CONFLICT_RESOLUTION;
        if (newRebalance) {
            if (oldCacheTopology == null) {
                return CompletableFutures.completedNull();
            }
            if (newCacheTopology.getTopologyId() <= oldCacheTopology.getTopologyId() + 1) {
                return CompletableFutures.completedNull();
            }
            if (newCacheTopology.getRebalanceId() != oldCacheTopology.getRebalanceId()) {
                this.registerPersistentUUID(newCacheTopology);
                CacheTopology resetTopology = new CacheTopology(newCacheTopology.getTopologyId() - 1, newCacheTopology.getRebalanceId() - 1, newCacheTopology.getCurrentCH(), null, CacheTopology.Phase.NO_REBALANCE, newCacheTopology.getActualMembers(), this.persistentUUIDManager.mapAddresses(newCacheTopology.getActualMembers()));
                log.debugf("Installing fake cache topology %s for cache %s", resetTopology, cacheName);
                return handler.updateConsistentHash(resetTopology);
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> handleStableTopologyUpdate(String cacheName, CacheTopology newStableTopology, Address sender, int viewId) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus != null) {
            return this.orderOnCache(cacheName, () -> this.doHandleStableTopologyUpdate(cacheName, newStableTopology, viewId, sender, cacheStatus));
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doHandleStableTopologyUpdate(String cacheName, CacheTopology newStableTopology, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            if (!this.validateCommandViewId(newStableTopology, viewId, sender, cacheName)) {
                return CompletableFutures.completedNull();
            }
            CacheTopology stableTopology = cacheStatus.getStableTopology();
            if (stableTopology == null || stableTopology.getTopologyId() < newStableTopology.getTopologyId()) {
                log.tracef("Updating stable topology for cache %s: %s", cacheName, newStableTopology);
                cacheStatus.setStableTopology(newStableTopology);
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> handleRebalance(String cacheName, CacheTopology cacheTopology, int viewId, Address sender) {
        if (!this.running) {
            log.debugf("Ignoring rebalance request %s for cache %s, the local cache manager is not running", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring rebalance %s for cache %s that doesn't exist locally", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        return this.withView(viewId, cacheStatus.getJoinInfo().getTimeout(), TimeUnit.MILLISECONDS).thenCompose(ignored -> this.orderOnCache(cacheName, () -> this.doHandleRebalance(viewId, cacheStatus, cacheTopology, cacheName, sender))).exceptionally(throwable -> {
            Throwable t = CompletableFutures.extractException(throwable);
            if (!(t instanceof IllegalLifecycleStateException)) {
                log.rebalanceStartError(cacheName, (Throwable)throwable);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doHandleRebalance(int viewId, LocalCacheStatus cacheStatus, CacheTopology cacheTopology, String cacheName, Address sender) {
        CacheTopology existingTopology;
        LocalCacheStatus localCacheStatus = cacheStatus;
        synchronized (localCacheStatus) {
            existingTopology = cacheStatus.getCurrentTopology();
            if (existingTopology != null && cacheTopology.getTopologyId() <= existingTopology.getTopologyId()) {
                log.debugf("Ignoring old rebalance for cache %s, current topology is %s: %s", cacheName, existingTopology.getTopologyId(), cacheTopology);
                return CompletableFutures.completedNull();
            }
            if (!this.updateCacheTopology(cacheName, cacheTopology, viewId, sender, cacheStatus)) {
                return CompletableFutures.completedNull();
            }
        }
        CacheTopologyHandler handler = cacheStatus.getHandler();
        ConsistentHash unionCH = cacheStatus.getJoinInfo().getConsistentHashFactory().union(cacheTopology.getCurrentCH(), cacheTopology.getPendingCH());
        CacheTopology newTopology = new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
        CompletionStage<Void> stage = this.resetLocalTopologyBeforeRebalance(cacheName, cacheTopology, existingTopology, handler);
        return stage.thenCompose(ignored -> {
            log.debugf("Starting local rebalance for cache %s, topology = %s", cacheName, cacheTopology);
            cacheTopology.logRoutingTableInformation();
            return handler.rebalance(newTopology);
        });
    }

    @Override
    public CacheTopology getCacheTopology(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus != null ? cacheStatus.getCurrentTopology() : null;
    }

    @Override
    public CacheTopology getStableCacheTopology(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus != null ? cacheStatus.getStableTopology() : null;
    }

    @Override
    public boolean isTotalOrderCache(String cacheName) {
        if (!this.running) {
            log.tracef("isTotalOrderCache(%s) returning false because the local cache manager is not running", cacheName);
            return false;
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("isTotalOrderCache(%s) returning false because the cache doesn't exist locally", cacheName);
            return false;
        }
        boolean totalOrder = cacheStatus.getJoinInfo().isTotalOrder();
        log.tracef("isTotalOrderCache(%s) returning %s", cacheName, totalOrder);
        return totalOrder;
    }

    private CompletionStage<Void> withView(int viewId, long timeout, TimeUnit timeUnit) {
        CompletableFuture<Void> viewFuture = this.transport.withView(viewId);
        ScheduledFuture<Boolean> cancelTask = this.timeoutExecutor.schedule(() -> viewFuture.completeExceptionally((Throwable)((Object)Log.CLUSTER.timeoutWaitingForView(viewId, this.transport.getViewId()))), timeout, timeUnit);
        viewFuture.whenComplete((v, throwable) -> cancelTask.cancel(false));
        return viewFuture;
    }

    @Override
    @ManagedAttribute(description="Rebalancing enabled", displayName="Rebalancing enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        return this.isCacheRebalancingEnabled(null);
    }

    @Override
    public void setRebalancingEnabled(boolean enabled) {
        this.setCacheRebalancingEnabled(null, enabled);
    }

    @Override
    public boolean isCacheRebalancingEnabled(String cacheName) {
        int viewId = this.transport.getViewId();
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), viewId);
        return (Boolean)CompletionStages.join(this.executeOnCoordinatorRetry(command, viewId, this.timeService.expectedEndTime((long)this.getGlobalTimeout(), TimeUnit.MILLISECONDS)));
    }

    public CompletionStage<Object> executeOnCoordinatorRetry(ReplicableCommand command, int viewId, long endNanos) {
        long remainingMillis = this.timeService.remainingTime(endNanos, TimeUnit.MILLISECONDS);
        return CompletionStages.handleAndCompose(this.helper.executeOnCoordinator(this.transport, command, remainingMillis), (o, throwable) -> {
            if (throwable == null) {
                return CompletableFuture.completedFuture(o);
            }
            Throwable t = CompletableFutures.extractException(throwable);
            if (t instanceof SuspectException) {
                if (trace) {
                    log.tracef("Coordinator left the cluster while querying rebalancing status, retrying", new Object[0]);
                }
                int newViewId = Math.max(viewId + 1, this.transport.getViewId());
                return this.executeOnCoordinatorRetry(command, newViewId, endNanos);
            }
            return CompletableFutures.completedExceptionFuture(t);
        });
    }

    @Override
    public void setCacheRebalancingEnabled(String cacheName, boolean enabled) {
        CacheTopologyControlCommand.Type type = enabled ? CacheTopologyControlCommand.Type.POLICY_ENABLE : CacheTopologyControlCommand.Type.POLICY_DISABLE;
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, type, this.transport.getAddress(), this.transport.getViewId());
        CompletionStages.join(this.helper.executeOnClusterSync(this.transport, command, this.getGlobalTimeout(), false, VoidResponseCollector.ignoreLeavers()));
    }

    @Override
    public RebalancingStatus getRebalancingStatus(String cacheName) {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCING_GET_STATUS, this.transport.getAddress(), this.transport.getViewId());
        int viewId = this.transport.getViewId();
        return (RebalancingStatus)((Object)CompletionStages.join(this.executeOnCoordinatorRetry(command, viewId, this.timeService.expectedEndTime((long)this.getGlobalTimeout(), TimeUnit.MILLISECONDS))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Cluster availability", displayName="Cluster availability", dataType=DataType.TRAIT, writable=false)
    public String getClusterAvailability() {
        AvailabilityMode clusterAvailability = AvailabilityMode.AVAILABLE;
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            for (LocalCacheStatus cacheStatus : this.runningCaches.values()) {
                AvailabilityMode availabilityMode = cacheStatus.getPartitionHandlingManager().getAvailabilityMode();
                clusterAvailability = clusterAvailability.min(availabilityMode);
            }
        }
        return clusterAvailability.toString();
    }

    @Override
    public AvailabilityMode getCacheAvailability(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus.getPartitionHandlingManager().getAvailabilityMode();
    }

    @Override
    public void setCacheAvailability(String cacheName, AvailabilityMode availabilityMode) {
        CacheTopologyControlCommand.Type type = CacheTopologyControlCommand.Type.AVAILABILITY_MODE_CHANGE;
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, type, this.transport.getAddress(), availabilityMode, this.transport.getViewId());
        CompletionStages.join(this.helper.executeOnCoordinator(this.transport, command, this.getGlobalTimeout()));
    }

    @Override
    public void cacheShutdown(String name) {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(name, CacheTopologyControlCommand.Type.SHUTDOWN_REQUEST, this.transport.getAddress(), this.transport.getViewId());
        CompletionStages.join(this.helper.executeOnCoordinator(this.transport, command, this.getGlobalTimeout()));
    }

    @Override
    public CompletionStage<Void> handleCacheShutdown(String cacheName) {
        this.writeCHState(cacheName);
        return CompletableFutures.completedNull();
    }

    private void writeCHState(String cacheName) {
        ScopedPersistentStateImpl cacheState = new ScopedPersistentStateImpl(cacheName);
        cacheState.setProperty("@version", Version.getVersion());
        cacheState.setProperty("@timestamp", this.timeService.instant().toString());
        cacheState.setProperty("version-major", Version.getMajor());
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        ConsistentHash remappedCH = cacheStatus.getCurrentTopology().getCurrentCH().remapAddresses(this.persistentUUIDManager.addressToPersistentUUID());
        remappedCH.toScopedState(cacheState);
        this.globalStateManager.writeScopedState(cacheState);
        if (trace) {
            log.tracef("Written CH state, checksum=%s: %s", cacheState.getChecksum(), remappedCH);
        }
    }

    private int getGlobalTimeout() {
        return (int)this.gcr.getGlobalConfiguration().transport().distributedSyncTimeout();
    }

    @Override
    public void prepareForPersist(ScopedPersistentState state) {
        if (this.persistentUUID != null) {
            state.setProperty("uuid", this.persistentUUID.toString());
        }
    }

    @Override
    public void prepareForRestore(ScopedPersistentState state) {
        if (!state.containsProperty("uuid")) {
            throw Log.CONFIG.invalidPersistentState("___global");
        }
        this.persistentUUID = PersistentUUID.fromString(state.getProperty("uuid"));
    }

    @Override
    public PersistentUUID getPersistentUUID() {
        return this.persistentUUID;
    }

    private <T> CompletionStage<T> orderOnCache(String cacheName, Callable<CompletionStage<T>> action) {
        return this.actionSequencer.orderOnKey(cacheName, () -> {
            log.tracef("Acquired cache status %s", cacheName);
            return ((CompletionStage)action.call()).whenComplete((v, t) -> log.tracef("Released cache status %s", cacheName));
        });
    }

    private CompletionStage<Void> orderOnCache(String cacheName, Runnable action) {
        return this.orderOnCache(cacheName, () -> {
            action.run();
            return CompletableFutures.completedNull();
        });
    }
}

