/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.factory;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.factory.CacheStoreFactory;
import org.infinispan.persistence.factory.ConfigurationForClassExtractor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LocalClassLoaderCacheStoreFactory
implements CacheStoreFactory {
    private static final Log log = LogFactory.getLog(LocalClassLoaderCacheStoreFactory.class);

    @Override
    public <T> T createInstance(StoreConfiguration cfg) {
        Class classBasedOnConfigurationAnnotation = ConfigurationForClassExtractor.getClassBasedOnConfigurationAnnotation(cfg);
        try {
            Object instance = Util.getInstance((Class)classBasedOnConfigurationAnnotation);
            if (instance != null) {
                return (T)instance;
            }
        }
        catch (CacheConfigurationException unableToInstantiate) {
            log.debugv("Could not instantiate class {0} using local classloader", classBasedOnConfigurationAnnotation.getName());
        }
        return null;
    }

    @Override
    public StoreConfiguration processConfiguration(StoreConfiguration storeConfiguration) {
        return null;
    }
}

