/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    private static final Log log = LogFactory.getLog(VersionedEntryWrappingInterceptor.class);
    @Inject
    protected VersionGenerator versionGenerator;
    private final InvocationSuccessFunction<VersionedPrepareCommand> prepareHandler = this::prepareHandler;

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        VersionedPrepareCommand versionedPrepareCommand = (VersionedPrepareCommand)command;
        if (ctx.isOriginLocal()) {
            versionedPrepareCommand.setVersionsSeen(((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead());
        }
        return this.wrapEntriesForPrepareAndApply(ctx, versionedPrepareCommand, this.prepareHandler);
    }

    private Object prepareHandler(InvocationContext nonTxCtx, VersionedPrepareCommand command, Object nil) {
        TxInvocationContext ctx = (TxInvocationContext)nonTxCtx;
        CompletionStage<Object> originVersionData = ctx.isOriginLocal() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer() ? this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, command) : CompletableFutures.completedNull();
        InvocationStage originVersionStage = VersionedEntryWrappingInterceptor.makeStage(this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, originVersionData));
        InvocationStage newVersionStage = originVersionStage.thenApplyMakeStage(ctx, command, (rCtx, rCommand, rv) -> {
            TxInvocationContext txInvocationContext = (TxInvocationContext)rCtx;
            VersionedPrepareCommand versionedPrepareCommand = rCommand;
            if (txInvocationContext.isOriginLocal()) {
                return VersionedEntryWrappingInterceptor.asyncValue(originVersionData);
            }
            return VersionedEntryWrappingInterceptor.asyncValue(this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, txInvocationContext, versionedPrepareCommand));
        });
        return newVersionStage.thenApply(ctx, command, (rCtx, rCommand, rv) -> {
            TxInvocationContext txInvocationContext = (TxInvocationContext)rCtx;
            VersionedPrepareCommand versionedPrepareCommand = rCommand;
            boolean onePhaseCommit = versionedPrepareCommand.isOnePhaseCommit();
            if (onePhaseCommit) {
                ((AbstractCacheTransaction)txInvocationContext.getCacheTransaction()).setUpdatedEntryVersions(versionedPrepareCommand.getVersionsSeen());
            }
            CompletionStage<Void> stage = null;
            if (onePhaseCommit) {
                stage = this.commitContextEntries(txInvocationContext, null);
            }
            return VersionedEntryWrappingInterceptor.delayedValue(stage, rv);
        });
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        VersionedCommitCommand versionedCommitCommand = (VersionedCommitCommand)command;
        if (ctx.isOriginLocal()) {
            versionedCommitCommand.setUpdatedVersions(((AbstractCacheTransaction)ctx.getCacheTransaction()).getUpdatedEntryVersions());
        }
        return this.invokeNextAndHandle(ctx, versionedCommitCommand, (rCtx, rCommand, rv, t) -> VersionedEntryWrappingInterceptor.delayedValue(this.doCommit(rCtx, (VersionedCommitCommand)rCommand), rv, t));
    }

    private CompletionStage<Void> doCommit(InvocationContext rCtx, VersionedCommitCommand versionedCommitCommand) {
        if (!rCtx.isOriginLocal()) {
            ((AbstractCacheTransaction)((TxInvocationContext)rCtx).getCacheTransaction()).setUpdatedEntryVersions(versionedCommitCommand.getUpdatedVersions());
        }
        return this.commitContextEntries(rCtx, null);
    }

    @Override
    protected CompletionStage<Void> commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Flag stateTransferFlag, boolean l1Invalidation) {
        if (ctx.isInTxScope() && stateTransferFlag == null) {
            EntryVersion updatedEntryVersion = (EntryVersion)((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions().get(entry.getKey());
            Metadata commitMetadata = updatedEntryVersion != null ? (entry.getMetadata() == null ? new EmbeddedMetadata.Builder().version(updatedEntryVersion).build() : entry.getMetadata().builder().version(updatedEntryVersion).build()) : entry.getMetadata();
            entry.setMetadata(commitMetadata);
            return this.cdl.commitEntry(entry, command, ctx, null, l1Invalidation);
        }
        return this.cdl.commitEntry(entry, command, ctx, stateTransferFlag, l1Invalidation);
    }
}

