/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;

public abstract class ClusteringInterceptor
extends BaseRpcInterceptor {
    @Inject
    protected CommandsFactory cf;
    @Inject
    protected EntryFactory entryFactory;
    @Inject
    protected LockManager lockManager;
    @Inject
    protected InternalDataContainer dataContainer;
    @Inject
    protected DistributionManager distributionManager;

    protected static SuccessfulResponse getSuccessfulResponseOrFail(Map<Address, Response> responseMap, CompletableFuture<?> future, Consumer<Response> cacheNotFound) {
        Iterator<Map.Entry<Address, Response>> it = responseMap.entrySet().iterator();
        if (!it.hasNext()) {
            future.completeExceptionally((Throwable)((Object)AllOwnersLostException.INSTANCE));
            return null;
        }
        Map.Entry<Address, Response> e = it.next();
        Address sender = e.getKey();
        Response response = e.getValue();
        if (it.hasNext()) {
            future.completeExceptionally(new IllegalStateException("Too many responses " + responseMap));
        } else {
            if (response instanceof SuccessfulResponse) {
                return (SuccessfulResponse)response;
            }
            if (response instanceof CacheNotFoundResponse || response instanceof UnsureResponse) {
                if (cacheNotFound == null) {
                    future.completeExceptionally(ClusteringInterceptor.unexpected(sender, response));
                } else {
                    try {
                        cacheNotFound.accept(response);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                }
            } else {
                future.completeExceptionally(ClusteringInterceptor.unexpected(sender, response));
            }
        }
        return null;
    }

    protected static RuntimeException unexpected(Address sender, Response response) {
        return Log.CLUSTER.unexpectedResponse(sender, response);
    }

    protected class ClusteredGetAllFuture
    extends CompletableFuture<Void> {
        public int counter;

        public ClusteredGetAllFuture(int counter) {
            this.counter = counter;
        }

        @Override
        public synchronized boolean completeExceptionally(Throwable ex) {
            return super.completeExceptionally(ex);
        }
    }
}

