/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class TouchCommand
extends BaseRpcCommand
implements InitializableCommand,
TopologyAffectedCommand {
    public static final byte COMMAND_ID = 66;
    private Object key;
    private int segment;
    private int topologyId = -1;
    private InternalDataContainer internalDataContainer;
    private TimeService timeService;
    private DistributionManager distributionManager;

    private TouchCommand() {
        super(null);
    }

    public TouchCommand(ByteString cacheName) {
        super(cacheName);
    }

    public TouchCommand(ByteString cacheName, Object key, int segment) {
        super(cacheName);
        this.key = key;
        this.segment = segment;
    }

    @Override
    public byte getCommandId() {
        return 66;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.internalDataContainer = componentRegistry.getInternalDataContainer().running();
        this.timeService = componentRegistry.getTimeService();
        if (!componentRegistry.getConfiguration().clustering().cacheMode().isInvalidation()) {
            this.distributionManager = componentRegistry.getDistributionManager();
        }
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public CompletableFuture<Object> invokeAsync(long currentTimeMilli) {
        boolean touched = this.internalDataContainer.touch(this.segment, this.key, currentTimeMilli);
        if (this.distributionManager != null && this.topologyId != -1) {
            LocalizedCacheTopology lct = this.distributionManager.getCacheTopology();
            int currentTopologyId = lct.getTopologyId();
            if (currentTopologyId != this.topologyId) {
                return CompletableFutures.completedExceptionFuture((Throwable)((Object)OutdatedTopologyException.RETRY_NEXT_TOPOLOGY));
            }
            DistributionInfo di = lct.getSegmentDistribution(this.segment);
            if (di.isWriteOwner() && !di.isReadOwner()) {
                return CompletableFuture.completedFuture(Boolean.TRUE);
            }
        }
        return CompletableFuture.completedFuture(touched);
    }

    @Override
    public CompletableFuture<Object> invokeAsync() {
        return this.invokeAsync(this.timeService.wallClockTime());
    }
}

