/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ACQUIRE_TIMEOUT,
    ADDRESS_COUNT,
    AFTER,
    ALIASES,
    ALLOW_DUPLICATE_DOMAINS("duplicate-domains"),
    ASYNC_EXECUTOR("async-executor"),
    ASYNC_MARSHALLING,
    AUDIT_LOGGER,
    AUTO_COMMIT,
    AUTO_CONFIG,
    AVAILABILITY_INTERVAL,
    AWAIT_INITIAL_TRANSFER,
    BACKUP_FAILURE_POLICY("failure-policy"),
    BEFORE,
    CAPACITY_FACTOR("capacity"),
    CHUNK_SIZE,
    CLASS,
    CLUSTER,
    COMPLETED_TX_TIMEOUT("complete-timeout"),
    CONCURRENCY_LEVEL,
    CONFIGURATION,
    CONNECTION_ATTEMPTS,
    CONNECTION_INTERVAL,
    CONSISTENT_HASH_FACTORY,
    CONTEXT_INITIALIZER,
    CORE_THREADS,
    DATA_CONTAINER,
    DEFAULT_CACHE,
    DEFAULT_STACK,
    DOMAIN,
    ENABLED,
    ENCODER,
    EXECUTOR,
    EVICTION,
    EVICTION_EXECUTOR,
    EXPIRATION_EXECUTOR,
    EXTENDS,
    FAIL_SILENTLY,
    FAILURE_POLICY_CLASS,
    FETCH_STATE,
    FLUSH_LOCK_TIMEOUT,
    FRAGMENTATION_FACTOR,
    GAUGES,
    GROUP_NAME,
    HISTOGRAMS,
    ID,
    INDEX,
    INITIAL_CLUSTER_SIZE,
    INITIAL_CLUSTER_TIMEOUT,
    INTERVAL,
    INVALIDATION_BATCH_SIZE,
    INVALIDATION_CLEANUP_TASK_FREQUENCY("l1-cleanup-interval"),
    ISOLATION,
    JNDI_NAME,
    KEEP_ALIVE_TIME("keepalive-time"),
    KEY,
    KEY_EQUIVALENCE,
    KEY_PARTITIONER,
    L1_LIFESPAN("l1-lifespan"),
    LIFESPAN,
    LISTENER_EXECUTOR,
    LOCATION,
    LOCK_TIMEOUT,
    LOCKING,
    MACHINE_ID("machine"),
    MAPPER,
    MARSHALLER_CLASS("marshaller"),
    MAX_BATCH_SIZE,
    MAX_ENTRIES,
    MAX_IDLE,
    MAX_RETRIES,
    MAX_THREADS,
    MBEAN_SERVER_LOOKUP,
    MERGE_POLICY,
    MEDIA_TYPE,
    MODE,
    NODE_NAME,
    MODIFICATION_QUEUE_SIZE,
    MODULE,
    NAME,
    NAMES,
    NAMES_AS_TAGS("namesAsTags"),
    NOTIFICATIONS,
    ON_REHASH("onRehash"),
    OWNERS,
    PATH,
    PASSIVATION,
    PERMISSIONS,
    PERSISTENCE_EXECUTOR,
    POSITION,
    PREFIX,
    PRELOAD,
    PRIORITY,
    PURGE,
    QUEUE_FLUSH_INTERVAL,
    QUEUE_LENGTH,
    QUEUE_SIZE,
    RACK_ID("rack"),
    READ_ONLY,
    REAPER_WAKE_UP_INTERVAL("reaper-interval"),
    RECOVERY_INFO_CACHE_NAME("recovery-cache"),
    RELATIVE_TO,
    REMOTE_CACHE,
    REMOTE_COMMAND_EXECUTOR,
    REMOTE_SITE,
    REMOTE_TIMEOUT,
    REPLICATION_QUEUE_EXECUTOR,
    ROLES,
    SEGMENTED,
    SEGMENTS,
    SHARED,
    SHUTDOWN_HOOK,
    SHUTDOWN_TIMEOUT,
    SIMPLE_CACHE,
    SINGLETON,
    SITE,
    SIZE,
    SPIN_DURATION("deadlock-detection-spin"),
    STATISTICS,
    STATISTICS_AVAILABLE,
    START,
    STATE_TRANSFER_EXECUTOR,
    STORE_KEYS_AS_BINARY("keys"),
    STORE_VALUES_AS_BINARY("values"),
    STRATEGY,
    STRIPING,
    STACK,
    STOP_TIMEOUT,
    TAKE_BACKUP_OFFLINE_AFTER_FAILURES("after-failures"),
    TAKE_BACKUP_OFFLINE_MIN_WAIT("min-wait"),
    THREAD_FACTORY,
    THREAD_NAME_PATTERN,
    THREAD_POLICY,
    THREAD_POOL_SIZE,
    TIMEOUT,
    TOTAL_ORDER_EXECUTOR,
    TRANSACTION_MANAGER_LOOKUP_CLASS("transaction-manager-lookup"),
    TRANSACTION_PROTOCOL("protocol"),
    TRANSACTIONAL,
    TRANSFORMER,
    TRANSPORT,
    TYPE,
    UNRELIABLE_RETURN_VALUES,
    USE_TWO_PHASE_COMMIT("two-phase-commit"),
    VALUE,
    VALUE_EQUIVALENCE,
    VERSION,
    VERSIONING_SCHEME("scheme"),
    WAIT_TIME,
    WHEN_SPLIT,
    WRITE_SKEW_CHECK("write-skew"),
    ZERO_CAPACITY_NODE("zero-capacity-node");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    private Attribute() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

