/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractTransactionBoundaryCommand
implements InitializableCommand,
TransactionBoundaryCommand {
    private static final Log log = LogFactory.getLog(AbstractTransactionBoundaryCommand.class);
    private static boolean trace = log.isTraceEnabled();
    protected GlobalTransaction globalTx;
    protected final ByteString cacheName;
    protected AsyncInterceptorChain invoker;
    protected InvocationContextFactory icf;
    protected TransactionTable txTable;
    private Address origin;
    private int topologyId = -1;

    public AbstractTransactionBoundaryCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.invoker = componentRegistry.getInterceptorChain().running();
        this.icf = componentRegistry.getInvocationContextFactory().running();
        this.txTable = componentRegistry.getTransactionTableRef().running();
        this.markTransactionAsRemote(isRemote);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.globalTx;
    }

    @Override
    public void markTransactionAsRemote(boolean isRemote) {
        this.globalTx.setRemote(isRemote);
    }

    protected Object invalidRemoteTxReturnValue() {
        return null;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.markGtxAsRemote();
        RemoteTransaction transaction = this.txTable.getRemoteTransaction(this.globalTx);
        if (transaction == null) {
            if (trace) {
                log.tracef("Did not find a RemoteTransaction for %s", this.globalTx);
            }
            return CompletableFuture.completedFuture(this.invalidRemoteTxReturnValue());
        }
        this.visitRemoteTransaction(transaction);
        RemoteTxInvocationContext ctx = this.icf.createRemoteTxInvocationContext(transaction, this.getOrigin());
        if (trace) {
            log.tracef("About to execute tx command %s", this);
        }
        return this.invoker.invokeAsync(ctx, this);
    }

    protected void visitRemoteTransaction(RemoteTransaction tx) {
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.globalTx);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.globalTx = (GlobalTransaction)input.readObject();
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransactionBoundaryCommand that = (AbstractTransactionBoundaryCommand)o;
        return this.globalTx.equals(that.globalTx);
    }

    public int hashCode() {
        return this.globalTx.hashCode();
    }

    public String toString() {
        return "gtx=" + this.globalTx + ", cacheName='" + this.cacheName + '\'' + ", topologyId=" + this.topologyId + '}';
    }

    private void markGtxAsRemote() {
        this.globalTx.setRemote(true);
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public final boolean canBlock() {
        return true;
    }
}

