/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;

public class ConditionFuture<T> {
    private final Map<Predicate<T>, Data> futures = new IdentityHashMap<Predicate<T>, Data>();
    private final ScheduledExecutorService timeoutExecutor;
    private volatile T lastValue;
    private volatile boolean running = true;

    public ConditionFuture(ScheduledExecutorService timeoutExecutor) {
        this.timeoutExecutor = timeoutExecutor;
    }

    public CompletionStage<Void> newConditionStage(Predicate<T> test, long timeout, TimeUnit timeUnit) {
        T localValue;
        Objects.requireNonNull(test);
        if (!this.running) {
            return CompletableFutures.completedExceptionFuture(new IllegalLifecycleStateException());
        }
        Data data = new Data();
        data.cancelFuture = this.timeoutExecutor.schedule(() -> {
            data.completeExceptionally((Throwable)((Object)new TimeoutException()));
            return null;
        }, timeout, timeUnit);
        CompletableFuture previous = this.futures.putIfAbsent(test, data);
        if (previous != null) {
            data.cancelFuture.cancel(false);
            this.futures.remove(test);
            throw new IllegalStateException();
        }
        if (!this.running) {
            data.cancelFuture.cancel(false);
            this.futures.remove(test);
            data.completeExceptionally(new IllegalLifecycleStateException());
        }
        if ((localValue = this.lastValue) != null && test.test(localValue)) {
            data.cancelFuture.cancel(false);
            this.futures.remove(test);
            data.complete(null);
        }
        return data;
    }

    public void update(T value) {
        if (!this.running) {
            throw new IllegalLifecycleStateException();
        }
        this.lastValue = Objects.requireNonNull(value);
        this.checkConditions(value);
    }

    public void updateAsync(T value, Executor executor) {
        if (!this.running) {
            throw new IllegalLifecycleStateException();
        }
        this.lastValue = Objects.requireNonNull(value);
        try {
            executor.execute(() -> this.checkConditions(value));
        }
        catch (Exception e) {
            for (Data data : this.futures.values()) {
                data.cancelFuture.cancel(false);
                data.completeExceptionally(e);
            }
        }
    }

    private void checkConditions(T value) {
        Iterator<Map.Entry<Predicate<T>, Data>> iterator = this.futures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Predicate<T>, Data> e = iterator.next();
            if (!e.getKey().test(value)) continue;
            Data data = e.getValue();
            data.cancelFuture.cancel(false);
            data.complete(null);
            iterator.remove();
        }
    }

    public void stop() {
        this.running = false;
        this.lastValue = null;
        IllegalLifecycleStateException exception = new IllegalLifecycleStateException();
        for (Data data : this.futures.values()) {
            data.cancelFuture.cancel(false);
            data.completeExceptionally(exception);
        }
        this.futures.clear();
    }

    private static class Data
    extends CompletableFuture<Void> {
        volatile Future<Void> cancelFuture;

        private Data() {
        }
    }
}

