/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

public final class ObjectNameMapper {
    public static final String JMX_DOMAIN_TAG = "_domain";

    public static MetricID makeMetricId(ObjectName objectName, String attributeName) {
        return new MetricID(ObjectNameMapper.makeMetricName(objectName, attributeName), ObjectNameMapper.makeTags(objectName));
    }

    public static String makeMetricName(ObjectName objectName, String attributeName) {
        return ObjectNameMapper.makeMetricNamePrefix(objectName) + attributeName.replace(';', '_');
    }

    public static String makeMetricNamePrefix(ObjectName objectName) {
        String componentKey;
        StringBuilder sb = new StringBuilder();
        String typeKey = objectName.getKeyProperty("type");
        if (typeKey != null) {
            typeKey = typeKey.replace(';', '_');
            sb.append(typeKey).append('_');
        }
        if ((componentKey = objectName.getKeyProperty("component")) != null && !(componentKey = componentKey.replace(';', '_')).equals(typeKey)) {
            sb.append(componentKey.replace('.', '_')).append('_');
        }
        return sb.toString();
    }

    public static Tag[] makeTags(ObjectName objectName) {
        Hashtable<String, String> props = objectName.getKeyPropertyList();
        ArrayList<Tag> tags = new ArrayList<Tag>(props.size());
        for (String name : props.keySet()) {
            if (name.equals("type") || name.equals("component")) continue;
            tags.add(new Tag(name, (String)props.get(name)));
        }
        tags.add(new Tag(JMX_DOMAIN_TAG, objectName.getDomain()));
        return tags.toArray(new Tag[0]);
    }

    public static Map<String, String> makeTagMap(ObjectName objectName) {
        HashMap<String, String> tags = new HashMap<String, String>(objectName.getKeyPropertyList());
        tags.remove("type");
        tags.remove("component");
        tags.put(JMX_DOMAIN_TAG, objectName.getDomain());
        return tags;
    }
}

