/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.setup.JmxRegistrar;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.metrics.impl.ObjectNameMapper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class ApplicationMetricsRegistry {
    private static final Log log = LogFactory.getLog(ApplicationMetricsRegistry.class);
    private final MetricRegistry applicationMetricRegistry = this.makeRegistry();

    protected MetricRegistry makeRegistry() {
        return MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
    }

    @Start
    public void start() {
        JmxRegistrar jmxRegistrar = new JmxRegistrar();
        try {
            jmxRegistrar.init();
        }
        catch (IOException e) {
            throw log.failedToInitBaseAndVendorMetrics(e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final MetricRegistry getRegistry() {
        return this.applicationMetricRegistry;
    }

    public void register(ResourceDMBean resourceDMBean) {
        MetricRegistry registry = this.getRegistry();
        ObjectName objectName = resourceDMBean.getObjectName();
        int metricCounter = 0;
        if (log.isTraceEnabled()) {
            log.tracef("Metric registry @%x contains %d metrics. Registering metrics for ObjectName \"%s\" ...", System.identityHashCode(registry), registry.getMetrics().size(), objectName);
        }
        MBeanInfo mBeanInfo = resourceDMBean.getMBeanInfo();
        MBeanAttributeInfo[] mBeanAttributes = mBeanInfo.getAttributes();
        Object[] tags = ObjectNameMapper.makeTags(objectName);
        for (MBeanAttributeInfo attr : mBeanAttributes) {
            Supplier<?> getter;
            String attrName = attr.getName();
            try {
                Consumer<?> setter = resourceDMBean.getAttributeSetter(attrName);
                if (setter != null) {
                    String metricName = ObjectNameMapper.makeMetricName(objectName, attrName);
                    Metadata metadata = new MetadataBuilder().withType(MetricType.TIMER).withUnit("nanoseconds").withName(metricName).withDisplayName(attrName).withDescription(attr.getDescription()).build();
                    Timer timer = this.getRegistry().timer(metadata, (Tag[])tags);
                    setter.accept(timer);
                }
            }
            catch (AttributeNotFoundException e) {
                throw new IllegalStateException(e);
            }
            if (!attr.isReadable()) continue;
            try {
                getter = resourceDMBean.getAttributeGetter(attrName);
                if (getter == null) {
                    continue;
                }
            }
            catch (AttributeNotFoundException e) {
                throw new IllegalStateException(e);
            }
            Gauge gaugeMetric = () -> (Number)getter.get();
            String metricName = ObjectNameMapper.makeMetricName(objectName, attrName);
            Metadata metadata = new MetadataBuilder().withType(MetricType.GAUGE).withUnit("none").withName(metricName).withDisplayName(attr.getName()).withDescription(attr.getDescription()).build();
            if (log.isTraceEnabled()) {
                log.tracef("Registering metric %s with tags %s", metricName, Arrays.toString(tags));
                ++metricCounter;
            }
            registry.register(metadata, (Metric)gaugeMetric, (Tag[])tags);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Metric registry @%x contains %d metrics. Registered %d metrics for ObjectName \"%s\"", new Object[]{System.identityHashCode(registry), registry.getMetrics().size(), metricCounter, objectName});
        }
    }

    public void unregister(ObjectName objectName) {
        MetricRegistry registry = this.getRegistry();
        if (log.isTraceEnabled()) {
            log.tracef("Metric registry @%x contains %d metrics. Unregistering metrics for ObjectName \"%s\" ...", System.identityHashCode(registry), registry.getMetrics().size(), objectName);
        }
        String prefix = ObjectNameMapper.makeMetricNamePrefix(objectName);
        Map<String, String> tags = ObjectNameMapper.makeTagMap(objectName);
        AtomicInteger metricCounter = new AtomicInteger();
        registry.removeMatching((metricID, metric) -> {
            boolean isMatching;
            boolean bl = isMatching = metricID.getName().startsWith(prefix) && tags.equals(metricID.getTags());
            if (log.isTraceEnabled() && isMatching) {
                log.tracef("Unregistering metric %s with tags %s", metricID.getName(), tags);
                metricCounter.getAndIncrement();
            }
            return isMatching;
        });
        if (log.isTraceEnabled()) {
            log.tracef("Metric registry @%x contains %d metrics. Unregistered %d metrics for ObjectName \"%s\"", new Object[]{System.identityHashCode(registry), registry.getMetrics().size(), metricCounter.get(), objectName});
        }
    }
}

