/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.ObjectNameKeys;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.jmx.SecurityActions;
import org.infinispan.metrics.impl.ApplicationMetricsRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NONE)
abstract class AbstractJmxRegistration
implements ObjectNameKeys {
    private static final Log log = LogFactory.getLog(AbstractJmxRegistration.class);
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    BasicComponentRegistry basicComponentRegistry;
    @Inject
    ApplicationMetricsRegistry applicationMetricsRegistry;
    volatile MBeanServer mBeanServer;
    String jmxDomain;
    String groupName;
    private List<ResourceDMBean> resourceDMBeans;
    private final String mainComponent;

    AbstractJmxRegistration(String mainComponent) {
        this.mainComponent = mainComponent;
    }

    public void start() {
        if (this.mBeanServer == null) {
            MBeanServer mBeanServer = null;
            try {
                GlobalJmxStatisticsConfiguration globalJmxConfig = this.globalConfig.globalJmxStatistics();
                MBeanServerLookup lookup = globalJmxConfig.mbeanServerLookup();
                if (lookup != null) {
                    mBeanServer = lookup.getMBeanServer((Properties)globalJmxConfig.properties());
                }
            }
            catch (Exception e) {
                Log.CONTAINER.warn("Ignoring exception in MBean server lookup", e);
            }
            if (mBeanServer != null) {
                this.groupName = this.initGroup();
                this.resourceDMBeans = Collections.synchronizedList(this.getResourceDMBeansFromComponents());
                Iterator<ResourceDMBean> it = this.resourceDMBeans.iterator();
                ResourceDMBean first = it.next();
                this.jmxDomain = this.findVirginDomain(mBeanServer, first, this.globalConfig.globalJmxStatistics());
                this.mBeanServer = mBeanServer;
                try {
                    while (it.hasNext()) {
                        ResourceDMBean resourceDMBean = it.next();
                        ObjectName objectName = this.getObjectName(this.groupName, resourceDMBean.getMBeanName());
                        this.register(resourceDMBean, objectName, mBeanServer);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Failure while registering MBeans", (Throwable)e);
                }
            }
        } else {
            this.resourceDMBeans = Collections.synchronizedList(this.getResourceDMBeansFromComponents());
            try {
                for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                    ObjectName objectName = this.getObjectName(this.groupName, resourceDMBean.getMBeanName());
                    this.register(resourceDMBean, objectName, this.mBeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Failure while registering MBeans", (Throwable)e);
            }
        }
    }

    private String findVirginDomain(MBeanServer mBeanServer, ResourceDMBean first, GlobalJmxStatisticsConfiguration globalJmxConfig) {
        String jmxDomain = globalJmxConfig.domain();
        int counter = 2;
        while (true) {
            try {
                this.register(first, AbstractJmxRegistration.getObjectName(jmxDomain, this.groupName, first.getMBeanName()), mBeanServer);
            }
            catch (IllegalArgumentException | InstanceAlreadyExistsException e) {
                if (globalJmxConfig.allowDuplicateDomains()) {
                    jmxDomain = globalJmxConfig.domain() + counter++;
                    continue;
                }
                throw Log.CONTAINER.jmxMBeanAlreadyRegistered(this.groupName, globalJmxConfig.domain());
            }
            catch (Exception e) {
                throw new CacheException("Failure while registering MBeans", (Throwable)e);
            }
            break;
        }
        return jmxDomain;
    }

    public void stop() {
        if (this.mBeanServer != null && this.resourceDMBeans != null) {
            try {
                for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                    ObjectName objectName = resourceDMBean.getObjectName();
                    if (objectName == null) continue;
                    this.unregisterMBean(objectName);
                }
                this.resourceDMBeans = null;
            }
            catch (Exception e) {
                throw new CacheException("Failure while unregistering MBeans", (Throwable)e);
            }
        }
    }

    protected abstract String initGroup();

    public final String getDomain() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.jmxDomain;
    }

    public final String getGroupName() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.groupName;
    }

    public final MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.mBeanServer;
    }

    private static ObjectName getObjectName(String domain, String groupName, String resourceName) throws MalformedObjectNameException {
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("groupName cannot be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName cannot be null");
        }
        return new ObjectName(domain + ":" + groupName + "," + "component" + "=" + resourceName);
    }

    private ObjectName getObjectName(String groupName, String resourceName) throws MalformedObjectNameException {
        return AbstractJmxRegistration.getObjectName(this.getDomain(), groupName, resourceName);
    }

    private List<ResourceDMBean> getResourceDMBeansFromComponents() {
        Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>(components.size());
        for (ComponentRef<?> component : components) {
            ResourceDMBean resourceDMBean;
            Object instance;
            if (component.isAlias() || (instance = component.wired()) == null || (resourceDMBean = this.getResourceDMBean(instance, component.getName())) == null) continue;
            if (this.mainComponent.equals(resourceDMBean.getMBeanName())) {
                resourceDMBeans.add(0, resourceDMBean);
                continue;
            }
            resourceDMBeans.add(resourceDMBean);
        }
        if (resourceDMBeans.isEmpty()) {
            throw new IllegalStateException("No MBeans found in component registry!");
        }
        return resourceDMBeans;
    }

    private ResourceDMBean getResourceDMBean(Object instance, String componentName) {
        MBeanMetadata md = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        return md == null ? null : new ResourceDMBean(instance, md, componentName);
    }

    public ObjectName registerExternalMBean(Object managedComponent, String groupName) throws Exception {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent, null);
        if (resourceDMBean == null) {
            throw new IllegalArgumentException("No MBean metadata found for " + managedComponent.getClass().getName());
        }
        ObjectName objectName = this.getObjectName(groupName, resourceDMBean.getMBeanName());
        this.register(resourceDMBean, objectName, this.mBeanServer);
        return objectName;
    }

    public void registerMBean(Object managedComponent) throws Exception {
        this.registerMBean(managedComponent, this.groupName);
    }

    public void registerMBean(Object managedComponent, String groupName) throws Exception {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent, null);
        if (resourceDMBean == null) {
            throw new IllegalArgumentException("No MBean metadata found for " + managedComponent.getClass().getName());
        }
        ObjectName objectName = this.getObjectName(groupName, resourceDMBean.getMBeanName());
        this.register(resourceDMBean, objectName, this.mBeanServer);
        this.resourceDMBeans.add(resourceDMBean);
    }

    private void register(ResourceDMBean resourceDMBean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        SecurityActions.registerMBean(resourceDMBean, objectName, mBeanServer);
        if (log.isTraceEnabled()) {
            log.tracef("Registered MBean %s under %s", resourceDMBean, objectName);
        }
        if (this.applicationMetricsRegistry != null) {
            this.applicationMetricsRegistry.register(resourceDMBean);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws Exception {
        if (this.mBeanServer.isRegistered(objectName)) {
            SecurityActions.unregisterMBean(objectName, this.mBeanServer);
            if (log.isTraceEnabled()) {
                log.tracef("Unregistered MBean: %s", objectName);
            }
            if (this.applicationMetricsRegistry != null) {
                this.applicationMetricsRegistry.unregister(objectName);
            }
        } else {
            log.debugf("MBean not registered: %s", objectName);
        }
    }
}

