/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.globalstate.impl.VolatileLocalConfigurationStorage;
import org.infinispan.util.logging.Log;

public class OverlayLocalConfigurationStorage
extends VolatileLocalConfigurationStorage {
    private Set<String> persistentCaches = ConcurrentHashMap.newKeySet();

    @Override
    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
        if (!flags.contains(CacheContainerAdmin.AdminFlag.VOLATILE) && !globalConfiguration.globalState().enabled()) {
            throw Log.CONFIG.globalStateDisabled();
        }
    }

    @Override
    public CompletableFuture<Void> createCache(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        CompletableFuture<Void> future = super.createCache(name, template, configuration, flags);
        if (!flags.contains(CacheContainerAdmin.AdminFlag.VOLATILE)) {
            return future.thenApplyAsync(v -> {
                this.persistentCaches.add(name);
                this.storeAll();
                return v;
            }, this.executor);
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return CompletableFuture.runAsync(() -> {
            if (this.persistentCaches.remove(name)) {
                this.storeAll();
            }
        }, this.executor).thenCompose(v -> super.removeCache(name, flags));
    }

    @Override
    public Map<String, Configuration> loadAll() {
        HashMap<String, Configuration> hashMap;
        FileInputStream fis = new FileInputStream(this.getPersistentFile());
        try {
            HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
            ConfigurationBuilderHolder holder = this.parserRegistry.parse(fis, null);
            for (Map.Entry<String, ConfigurationBuilder> entry : holder.getNamedConfigurationBuilders().entrySet()) {
                String name = entry.getKey();
                Configuration configuration = entry.getValue().build();
                configurations.put(name, configuration);
            }
            hashMap = configurations;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return Collections.emptyMap();
            }
            catch (IOException e) {
                throw new CacheConfigurationException((Exception)e);
            }
        }
        fis.close();
        return hashMap;
    }

    private void storeAll() {
        try {
            GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
            File sharedDirectory = new File(globalConfiguration.globalState().sharedPersistentLocation());
            sharedDirectory.mkdirs();
            File temp = File.createTempFile("caches", null, sharedDirectory);
            HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
            for (String cacheName : this.persistentCaches) {
                configurationMap.put(cacheName, this.configurationManager.getConfiguration(cacheName, true));
            }
            try (FileOutputStream f = new FileOutputStream(temp);){
                this.parserRegistry.serialize((OutputStream)f, null, configurationMap);
            }
            File persistentFile = this.getPersistentFile();
            try {
                Util.renameTempFile((File)temp, (File)this.getPersistentFileLock(), (File)persistentFile);
            }
            catch (Exception e) {
                throw Log.CONFIG.cannotRenamePersistentFile(temp.getAbsolutePath(), persistentFile, e);
            }
        }
        catch (Exception e) {
            throw Log.CONFIG.errorPersistingGlobalConfiguration(e);
        }
    }

    private File getPersistentFile() {
        return new File(this.configurationManager.getGlobalConfiguration().globalState().sharedPersistentLocation(), "caches.xml");
    }

    private File getPersistentFileLock() {
        return new File(this.configurationManager.getGlobalConfiguration().globalState().sharedPersistentLocation(), "caches.xml.lck");
    }
}

