/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.List;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.SecurityActions;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.EmptyAsyncInterceptorChain;
import org.infinispan.interceptors.distribution.BiasedScatteredDistributionInterceptor;
import org.infinispan.interceptors.distribution.DistributionBulkInterceptor;
import org.infinispan.interceptors.distribution.L1LastChanceInterceptor;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;
import org.infinispan.interceptors.distribution.L1TxInterceptor;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.ScatteredDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.interceptors.distribution.VersionedDistributionInterceptor;
import org.infinispan.interceptors.impl.AsyncInterceptorChainImpl;
import org.infinispan.interceptors.impl.BatchingInterceptor;
import org.infinispan.interceptors.impl.BiasedEntryWrappingInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.interceptors.impl.ClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.DistCacheWriterInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.interceptors.impl.GroupingInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.interceptors.impl.IsMarshallableInterceptor;
import org.infinispan.interceptors.impl.NotificationInterceptor;
import org.infinispan.interceptors.impl.PassivationCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationWriterInterceptor;
import org.infinispan.interceptors.impl.PrefetchInterceptor;
import org.infinispan.interceptors.impl.RetryingEntryWrappingInterceptor;
import org.infinispan.interceptors.impl.ScatteredCacheWriterInterceptor;
import org.infinispan.interceptors.impl.TransactionalExceptionEvictionInterceptor;
import org.infinispan.interceptors.impl.TransactionalStoreInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.interceptors.impl.VersionInterceptor;
import org.infinispan.interceptors.impl.VersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderDistributionInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderStateTransferInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderVersionedDistributionInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderVersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.xsite.NonTransactionalBackupInterceptor;
import org.infinispan.interceptors.xsite.OptimisticBackupInterceptor;
import org.infinispan.interceptors.xsite.PessimisticBackupInterceptor;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingInterceptor;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.TransactionSynchronizerInterceptor;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={AsyncInterceptorChain.class})
public class InterceptorChainFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(InterceptorChainFactory.class);

    private AsyncInterceptor createInterceptor(AsyncInterceptor interceptor, Class<? extends AsyncInterceptor> interceptorType) {
        ComponentRef<? extends AsyncInterceptor> chainedInterceptor = this.basicComponentRegistry.getComponent(interceptorType);
        if (chainedInterceptor != null) {
            return chainedInterceptor.wired();
        }
        this.register(interceptorType, interceptor);
        return interceptor;
    }

    private void register(Class<? extends AsyncInterceptor> clazz, AsyncInterceptor chainedInterceptor) {
        try {
            this.basicComponentRegistry.registerComponent(clazz.getName(), chainedInterceptor, true);
            this.basicComponentRegistry.addDynamicDependency(AsyncInterceptorChain.class.getName(), clazz.getName());
        }
        catch (RuntimeException e) {
            log.unableToCreateInterceptor(clazz, e);
            throw e;
        }
    }

    private AsyncInterceptorChain buildInterceptorChain() {
        TransactionMode transactionMode = this.configuration.transaction().transactionMode();
        boolean needsVersionAwareComponents = transactionMode.isTransactional() && Configurations.isTxVersioned(this.configuration);
        AsyncInterceptorChainImpl interceptorChain = new AsyncInterceptorChainImpl(this.basicComponentRegistry);
        boolean invocationBatching = this.configuration.invocationBatching().enabled();
        boolean isTotalOrder = this.configuration.transaction().transactionProtocol().isTotalOrder();
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (cacheMode.needsStateTransfer()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new DistributionBulkInterceptor(), DistributionBulkInterceptor.class), false);
        }
        if (invocationBatching) {
            interceptorChain.appendInterceptor(this.createInterceptor(new BatchingInterceptor(), BatchingInterceptor.class), false);
        }
        interceptorChain.appendInterceptor(this.createInterceptor(new InvocationContextInterceptor(), InvocationContextInterceptor.class), false);
        if (!this.configuration.transaction().transactionMode().isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new VersionInterceptor(), VersionInterceptor.class), false);
        }
        if (this.hasAsyncStore()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new IsMarshallableInterceptor(), IsMarshallableInterceptor.class), false);
        }
        if (this.configuration.jmxStatistics().available()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new CacheMgmtInterceptor(), CacheMgmtInterceptor.class), false);
        }
        if (cacheMode.needsStateTransfer() || cacheMode.isInvalidation() && transactionMode.isTransactional()) {
            if (isTotalOrder) {
                interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderStateTransferInterceptor(), TotalOrderStateTransferInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new StateTransferInterceptor(), StateTransferInterceptor.class), false);
            }
        }
        if (cacheMode.needsStateTransfer()) {
            if (transactionMode.isTransactional()) {
                interceptorChain.appendInterceptor(this.createInterceptor(new TransactionSynchronizerInterceptor(), TransactionSynchronizerInterceptor.class), false);
            }
            if (this.configuration.clustering().partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                interceptorChain.appendInterceptor(this.createInterceptor(new PartitionHandlingInterceptor(), PartitionHandlingInterceptor.class), false);
            }
        }
        if (isTotalOrder) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderInterceptor(), TotalOrderInterceptor.class), false);
        }
        if (transactionMode.isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TxInterceptor(), TxInterceptor.class), false);
        }
        if (!isTotalOrder && !cacheMode.isScattered()) {
            if (transactionMode.isTransactional()) {
                if (this.configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticLockingInterceptor(), PessimisticLockingInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticLockingInterceptor(), OptimisticLockingInterceptor.class), false);
                }
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalLockingInterceptor(), NonTransactionalLockingInterceptor.class), false);
            }
        }
        if (transactionMode.isTransactional() && this.configuration.transaction().notifications()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new NotificationInterceptor(), NotificationInterceptor.class), false);
        }
        if (this.configuration.sites().hasEnabledBackups() && !this.configuration.sites().disableBackups()) {
            if (transactionMode == TransactionMode.TRANSACTIONAL) {
                if (this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticBackupInterceptor(), OptimisticBackupInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticBackupInterceptor(), PessimisticBackupInterceptor.class), false);
                }
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalBackupInterceptor(), NonTransactionalBackupInterceptor.class), false);
            }
        }
        if (this.configuration.clustering().l1().enabled()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new L1LastChanceInterceptor(), L1LastChanceInterceptor.class), false);
        }
        if (this.configuration.clustering().hash().groups().enabled()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new GroupingInterceptor(), GroupingInterceptor.class), false);
        }
        if (cacheMode.isScattered()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new PrefetchInterceptor(), PrefetchInterceptor.class), false);
        }
        if (needsVersionAwareComponents) {
            if (isTotalOrder) {
                interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderVersionedEntryWrappingInterceptor(), TotalOrderVersionedEntryWrappingInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new VersionedEntryWrappingInterceptor(), VersionedEntryWrappingInterceptor.class), false);
            }
        } else if (cacheMode.isScattered()) {
            if (this.configuration.clustering().biasAcquisition() == BiasAcquisition.NEVER) {
                interceptorChain.appendInterceptor(this.createInterceptor(new RetryingEntryWrappingInterceptor(), RetryingEntryWrappingInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new BiasedEntryWrappingInterceptor(), BiasedEntryWrappingInterceptor.class), false);
            }
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(new EntryWrappingInterceptor(), EntryWrappingInterceptor.class), false);
        }
        if (transactionMode.isTransactional() && this.configuration.memory().evictionStrategy().isExceptionBased()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TransactionalExceptionEvictionInterceptor(), TransactionalExceptionEvictionInterceptor.class), false);
        }
        if (this.configuration.persistence().usingStores()) {
            if (this.configuration.persistence().passivation()) {
                if (cacheMode.isClustered()) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PassivationClusteredCacheLoaderInterceptor(), CacheLoaderInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PassivationCacheLoaderInterceptor(), CacheLoaderInterceptor.class), false);
                }
                interceptorChain.appendInterceptor(this.createInterceptor(new PassivationWriterInterceptor(), PassivationWriterInterceptor.class), false);
            } else {
                if (cacheMode.isClustered()) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new ClusteredCacheLoaderInterceptor(), CacheLoaderInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new CacheLoaderInterceptor(), CacheLoaderInterceptor.class), false);
                }
                boolean transactionalStore = this.configuration.persistence().stores().stream().anyMatch(StoreConfiguration::transactional);
                if (transactionalStore && transactionMode.isTransactional()) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new TransactionalStoreInterceptor(), TransactionalStoreInterceptor.class), false);
                }
                switch (cacheMode) {
                    case DIST_SYNC: 
                    case DIST_ASYNC: 
                    case REPL_SYNC: 
                    case REPL_ASYNC: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new DistCacheWriterInterceptor(), DistCacheWriterInterceptor.class), false);
                        break;
                    }
                    case SCATTERED_SYNC: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new ScatteredCacheWriterInterceptor(), ScatteredCacheWriterInterceptor.class), false);
                        break;
                    }
                    default: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new CacheWriterInterceptor(), CacheWriterInterceptor.class), false);
                    }
                }
            }
        }
        if (this.configuration.clustering().l1().enabled()) {
            if (transactionMode.isTransactional()) {
                interceptorChain.appendInterceptor(this.createInterceptor(new L1TxInterceptor(), L1TxInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new L1NonTxInterceptor(), L1NonTxInterceptor.class), false);
            }
        }
        switch (cacheMode) {
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(new InvalidationInterceptor(), InvalidationInterceptor.class), false);
                break;
            }
            case DIST_SYNC: 
            case REPL_SYNC: {
                if (needsVersionAwareComponents) {
                    if (isTotalOrder) {
                        interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderVersionedDistributionInterceptor(), TotalOrderVersionedDistributionInterceptor.class), false);
                        break;
                    }
                    interceptorChain.appendInterceptor(this.createInterceptor(new VersionedDistributionInterceptor(), VersionedDistributionInterceptor.class), false);
                    break;
                }
            }
            case DIST_ASYNC: 
            case REPL_ASYNC: {
                if (transactionMode.isTransactional()) {
                    if (isTotalOrder) {
                        interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderDistributionInterceptor(), TotalOrderDistributionInterceptor.class), false);
                        break;
                    }
                    interceptorChain.appendInterceptor(this.createInterceptor(new TxDistributionInterceptor(), TxDistributionInterceptor.class), false);
                    break;
                }
                if (cacheMode.isDistributed() && Configurations.isEmbeddedMode(this.globalConfiguration)) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new TriangleDistributionInterceptor(), TriangleDistributionInterceptor.class), false);
                    break;
                }
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTxDistributionInterceptor(), NonTxDistributionInterceptor.class), false);
                break;
            }
            case SCATTERED_SYNC: {
                if (this.configuration.clustering().biasAcquisition() != BiasAcquisition.NEVER) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new BiasedScatteredDistributionInterceptor(), BiasedScatteredDistributionInterceptor.class), false);
                    break;
                }
                interceptorChain.appendInterceptor(this.createInterceptor(new ScatteredDistributionInterceptor(), ScatteredDistributionInterceptor.class), false);
                break;
            }
        }
        AsyncInterceptor callInterceptor = this.createInterceptor(new CallInterceptor(), CallInterceptor.class);
        interceptorChain.appendInterceptor(callInterceptor, false);
        log.trace("Finished building default interceptor chain.");
        this.buildCustomInterceptors(interceptorChain, this.configuration.customInterceptors());
        return interceptorChain;
    }

    private void buildCustomInterceptors(AsyncInterceptorChain interceptorChain, CustomInterceptorsConfiguration customInterceptors) {
        for (InterceptorConfiguration config : customInterceptors.interceptors()) {
            boolean added;
            if (interceptorChain.containsInterceptorType(config.asyncInterceptor().getClass())) continue;
            AsyncInterceptor customInterceptor = config.asyncInterceptor();
            SecurityActions.applyProperties(customInterceptor, (Properties)config.properties());
            this.register(customInterceptor.getClass(), customInterceptor);
            if (config.first()) {
                interceptorChain.addInterceptor(customInterceptor, 0);
                continue;
            }
            if (config.last()) {
                interceptorChain.addInterceptorBefore(customInterceptor, CallInterceptor.class);
                continue;
            }
            if (config.index() >= 0) {
                interceptorChain.addInterceptor(customInterceptor, config.index());
                continue;
            }
            if (config.after() != null) {
                added = interceptorChain.addInterceptorAfter(customInterceptor, config.after());
                if (added) continue;
                throw new CacheConfigurationException("Cannot add after class: " + config.after() + " as no such interceptor exists in the default chain");
            }
            if (config.before() != null) {
                added = interceptorChain.addInterceptorBefore(customInterceptor, config.before());
                if (added) continue;
                throw new CacheConfigurationException("Cannot add before class: " + config.before() + " as no such interceptor exists in the default chain");
            }
            if (config.position() != InterceptorConfiguration.Position.OTHER_THAN_FIRST_OR_LAST) continue;
            interceptorChain.addInterceptor(customInterceptor, 1);
        }
    }

    private boolean hasAsyncStore() {
        List<StoreConfiguration> loaderConfigs = this.configuration.persistence().stores();
        for (StoreConfiguration loaderConfig : loaderConfigs) {
            if (!loaderConfig.async().enabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object construct(String componentName) {
        try {
            if (this.configuration.simpleCache()) {
                return EmptyAsyncInterceptorChain.INSTANCE;
            }
            return this.buildInterceptorChain();
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to build interceptor chain", (Throwable)e);
        }
    }

    @Deprecated
    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

