/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={InternalDataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        InternalDataContainer dataContainer;
        ClusteringConfiguration clusteringConfiguration = this.configuration.clustering();
        boolean shouldSegment = clusteringConfiguration.cacheMode().needsStateTransfer();
        int level = this.configuration.locking().concurrencyLevel();
        MemoryConfiguration memoryConfiguration = this.configuration.memory();
        EvictionStrategy strategy = memoryConfiguration.evictionStrategy();
        if (strategy.isExceptionBased() || !strategy.isEnabled()) {
            if (this.configuration.memory().storageType() == StorageType.OFF_HEAP) {
                if (shouldSegment) {
                    int segments = clusteringConfiguration.hash().numSegments();
                    Supplier<Object> mapSupplier = this::createAndStartOffHeapConcurrentMap;
                    if (clusteringConfiguration.l1().enabled()) {
                        return new L1SegmentedDataContainer(mapSupplier, segments);
                    }
                    return new DefaultSegmentedDataContainer(mapSupplier, segments);
                }
                return new OffHeapDataContainer();
            }
            if (shouldSegment) {
                Supplier<Object> mapSupplier = ConcurrentHashMap::new;
                int segments = clusteringConfiguration.hash().numSegments();
                if (clusteringConfiguration.l1().enabled()) {
                    return new L1SegmentedDataContainer(mapSupplier, segments);
                }
                return new DefaultSegmentedDataContainer(mapSupplier, segments);
            }
            return DefaultDataContainer.unBoundedDataContainer(level);
        }
        long thresholdSize = memoryConfiguration.size();
        if (memoryConfiguration.storageType() == StorageType.OFF_HEAP) {
            if (shouldSegment) {
                int segments = clusteringConfiguration.hash().numSegments();
                dataContainer = new SegmentedBoundedOffHeapDataContainer(segments, thresholdSize, memoryConfiguration.evictionType());
            } else {
                dataContainer = new BoundedOffHeapDataContainer(thresholdSize, memoryConfiguration.evictionType());
            }
        } else if (shouldSegment) {
            int segments = clusteringConfiguration.hash().numSegments();
            dataContainer = new BoundedSegmentedDataContainer(segments, thresholdSize, memoryConfiguration.evictionType());
        } else {
            dataContainer = DefaultDataContainer.boundedDataContainer(level, thresholdSize, memoryConfiguration.evictionType());
        }
        memoryConfiguration.heapConfiguration().attributes().attribute(MemoryStorageConfiguration.SIZE).addListener((newSize, old) -> dataContainer.resize((Long)newSize.get()));
        return dataContainer;
    }

    OffHeapConcurrentMap createAndStartOffHeapConcurrentMap() {
        OffHeapEntryFactory entryFactory = this.componentRegistry.getOrCreateComponent(OffHeapEntryFactory.class);
        OffHeapMemoryAllocator memoryAllocator = this.componentRegistry.getOrCreateComponent(OffHeapMemoryAllocator.class);
        return new OffHeapConcurrentMap(memoryAllocator, entryFactory, null);
    }
}

