/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.PlatformMBeanServerLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;

public class GlobalJmxStatisticsConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalJmxStatisticsConfiguration> {
    private final AttributeSet attributes = GlobalJmxStatisticsConfiguration.attributeDefinitionSet();

    GlobalJmxStatisticsConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public GlobalJmxStatisticsConfigurationBuilder withProperties(Properties properties) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).set((Object)new TypedProperties(properties));
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)properties));
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder jmxDomain(String jmxDomain) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.JMX_DOMAIN).set((Object)jmxDomain);
        return this;
    }

    @Deprecated
    public GlobalJmxStatisticsConfigurationBuilder allowDuplicateDomains(Boolean allowDuplicateDomains) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.ALLOW_DUPLICATE_DOMAINS).set((Object)allowDuplicateDomains);
        return this;
    }

    @Deprecated
    public GlobalJmxStatisticsConfigurationBuilder cacheManagerName(String cacheManagerName) {
        this.getGlobalConfig().cacheContainer().name(cacheManagerName);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder mBeanServerLookup(MBeanServerLookup mBeanServerLookupInstance) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.MBEAN_SERVER_LOOKUP).set((Object)mBeanServerLookupInstance);
        return this;
    }

    @Deprecated
    public GlobalJmxStatisticsConfigurationBuilder disable() {
        this.enabled(false);
        return this;
    }

    @Deprecated
    public GlobalJmxStatisticsConfigurationBuilder enable() {
        this.enabled(true);
        return this;
    }

    @Deprecated
    public GlobalJmxStatisticsConfigurationBuilder enabled(boolean enabled) {
        this.getGlobalConfig().cacheContainer().statistics(enabled);
        return this;
    }

    public void validate() {
    }

    public GlobalJmxStatisticsConfiguration create() {
        if (this.getGlobalConfig().cacheContainer().statistics() && this.attributes.attribute(GlobalJmxStatisticsConfiguration.MBEAN_SERVER_LOOKUP).isNull()) {
            this.mBeanServerLookup((MBeanServerLookup)new PlatformMBeanServerLookup());
        }
        return new GlobalJmxStatisticsConfiguration(this.attributes.protect(), this.getGlobalConfig().cacheContainer().name(), this.getGlobalConfig().cacheContainer().statistics());
    }

    public GlobalJmxStatisticsConfigurationBuilder read(GlobalJmxStatisticsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "GlobalJmxStatisticsConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

