/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.parsing.Element;

public class GlobalJmxStatisticsConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> JMX_DOMAIN = AttributeDefinition.builder((String)"domain", (Object)"org.infinispan").immutable().build();
    public static final AttributeDefinition<MBeanServerLookup> MBEAN_SERVER_LOOKUP = AttributeDefinition.builder((String)"mbeanServerLookup", null, MBeanServerLookup.class).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<Boolean> ALLOW_DUPLICATE_DOMAINS = AttributeDefinition.builder((String)"duplicateDomains", (Object)true).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).immutable().initializer(TypedProperties::new).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.JMX.getLocalName());
    private final Attribute<String> jmxDomain;
    private final Attribute<MBeanServerLookup> mBeanServerLookup;
    private final Attribute<Boolean> allowDuplicateDomains;
    private final Attribute<TypedProperties> properties;
    private final String cacheManagerName;
    private final boolean enabled;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalJmxStatisticsConfiguration.class, new AttributeDefinition[]{JMX_DOMAIN, MBEAN_SERVER_LOOKUP, ALLOW_DUPLICATE_DOMAINS, PROPERTIES});
    }

    GlobalJmxStatisticsConfiguration(AttributeSet attributes, String cacheManagerName, boolean enabled) {
        this.attributes = attributes.checkProtection();
        this.jmxDomain = attributes.attribute(JMX_DOMAIN);
        this.mBeanServerLookup = attributes.attribute(MBEAN_SERVER_LOOKUP);
        this.allowDuplicateDomains = attributes.attribute(ALLOW_DUPLICATE_DOMAINS);
        this.properties = attributes.attribute(PROPERTIES);
        this.enabled = enabled;
        this.cacheManagerName = cacheManagerName;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    @Deprecated
    public boolean enabled() {
        return this.enabled;
    }

    public String domain() {
        return (String)this.jmxDomain.get();
    }

    public TypedProperties properties() {
        return (TypedProperties)this.properties.get();
    }

    @Deprecated
    public boolean allowDuplicateDomains() {
        return (Boolean)this.allowDuplicateDomains.get();
    }

    @Deprecated
    public String cacheManagerName() {
        return this.cacheManagerName;
    }

    public MBeanServerLookup mbeanServerLookup() {
        return (MBeanServerLookup)this.mBeanServerLookup.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalJmxStatisticsConfiguration that = (GlobalJmxStatisticsConfiguration)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.cacheManagerName != null ? !this.cacheManagerName.equals(that.cacheManagerName) : that.cacheManagerName != null) {
            return false;
        }
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.cacheManagerName != null ? this.cacheManagerName.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GlobalJmxStatisticsConfiguration{enabled=" + this.enabled + ", cacheManagerName='" + this.cacheManagerName + '\'' + ", attributes=" + this.attributes + '}';
    }
}

