/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Features;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadsConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.Element;

class CacheContainerConfiguration
implements ConfigurationInfo {
    private static final String ZERO_CAPACITY_NODE_FEATURE = "zero-capacity-node";
    static final AttributeDefinition<String> DEFAULT_CACHE = AttributeDefinition.builder((String)"defaultCache", null, String.class).immutable().build();
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", (Object)"DefaultCacheManager").immutable().build();
    static final AttributeDefinition<Boolean> STATISTICS = AttributeDefinition.builder((String)"statistics", (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> ZERO_CAPACITY_NODE = AttributeDefinition.builder((String)"zeroCapacityNode", (Object)Boolean.FALSE).immutable().build();
    static final AttributeDefinition<String> ASYNC_EXECUTOR = AttributeDefinition.builder((String)"asyncExecutor", (Object)"async-pool", String.class).immutable().build();
    static final AttributeDefinition<String> LISTENER_EXECUTOR = AttributeDefinition.builder((String)"listenerExecutor", (Object)"listener-pool", String.class).immutable().build();
    static final AttributeDefinition<String> EXPIRATION_EXECUTOR = AttributeDefinition.builder((String)"expirationExecutor", (Object)"expiration-pool", String.class).immutable().build();
    static final AttributeDefinition<String> PERSISTENCE_EXECUTOR = AttributeDefinition.builder((String)"persistenceExecutor", (Object)"persistence-pool", String.class).immutable().build();
    static final AttributeDefinition<String> STATE_TRANSFER_EXECUTOR = AttributeDefinition.builder((String)"stateTransferExecutor", (Object)"state-transfer-pool", String.class).immutable().build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.CACHE_CONTAINER.getLocalName());
    private final Attribute<String> defaultCache;
    private final Attribute<String> name;
    private final Attribute<Boolean> statistics;
    private final Attribute<Boolean> zeroCapacityNode;
    private final boolean zeroCapacityAvailable;
    private final ThreadsConfiguration threads;
    private final GlobalJmxStatisticsConfiguration globalJmxStatistics;
    private final TransportConfiguration transport;
    private final GlobalSecurityConfiguration security;
    private final SerializationConfiguration serialization;
    private final GlobalStateConfiguration globalState;
    private final ShutdownConfiguration shutdown;
    private final AttributeSet attributes;
    private final List<ConfigurationInfo> children;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CacheContainerConfiguration.class, new AttributeDefinition[]{NAME, STATISTICS, ZERO_CAPACITY_NODE, DEFAULT_CACHE, ASYNC_EXECUTOR, LISTENER_EXECUTOR, EXPIRATION_EXECUTOR, PERSISTENCE_EXECUTOR, STATE_TRANSFER_EXECUTOR});
    }

    CacheContainerConfiguration(AttributeSet attributes, ThreadsConfiguration threadsConfiguration, GlobalJmxStatisticsConfiguration globalJmxStatistics, TransportConfiguration transport, GlobalSecurityConfiguration security, SerializationConfiguration serialization, GlobalStateConfiguration globalState, ShutdownConfiguration shutdown, Features features) {
        this.attributes = attributes.checkProtection();
        this.defaultCache = attributes.attribute(DEFAULT_CACHE);
        this.name = attributes.attribute(NAME);
        this.statistics = attributes.attribute(STATISTICS);
        this.zeroCapacityNode = attributes.attribute(ZERO_CAPACITY_NODE);
        this.threads = threadsConfiguration;
        this.globalJmxStatistics = globalJmxStatistics;
        this.globalState = globalState;
        this.shutdown = shutdown;
        this.security = security;
        this.serialization = serialization;
        this.transport = transport;
        this.zeroCapacityAvailable = features.isAvailable(ZERO_CAPACITY_NODE_FEATURE);
        this.children = Arrays.asList(shutdown, transport, security, serialization, globalJmxStatistics, globalState);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.children;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String defaultCacheName() {
        return (String)this.defaultCache.get();
    }

    public String cacheManagerName() {
        return (String)this.name.get();
    }

    public boolean statistics() {
        return (Boolean)this.statistics.get();
    }

    public boolean getZeroCapacityNode() {
        return this.zeroCapacityAvailable & (Boolean)this.zeroCapacityNode.get();
    }

    public GlobalJmxStatisticsConfiguration globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    public TransportConfiguration transport() {
        return this.transport;
    }

    public GlobalSecurityConfiguration security() {
        return this.security;
    }

    public SerializationConfiguration serialization() {
        return this.serialization;
    }

    public ShutdownConfiguration shutdown() {
        return this.shutdown;
    }

    public String asyncExecutor() {
        return (String)this.attributes.attribute(ASYNC_EXECUTOR).get();
    }

    public String listenerExecutor() {
        return (String)this.attributes.attribute(LISTENER_EXECUTOR).get();
    }

    public String expirationExecutor() {
        return (String)this.attributes.attribute(EXPIRATION_EXECUTOR).get();
    }

    public String persistenceExecutor() {
        return (String)this.attributes.attribute(PERSISTENCE_EXECUTOR).get();
    }

    @Deprecated
    public String stateTransferExecutor() {
        return (String)this.attributes.attribute(STATE_TRANSFER_EXECUTOR).get();
    }

    public GlobalStateConfiguration globalState() {
        return this.globalState;
    }

    public boolean isClustered() {
        return this.transport().transport() != null;
    }

    public ThreadsConfiguration threads() {
        return this.threads;
    }

    public ThreadPoolConfiguration expirationThreadPool() {
        return this.threads.expirationThreadPool();
    }

    public ThreadPoolConfiguration listenerThreadPool() {
        return this.threads.listenerThreadPool();
    }

    public ThreadPoolConfiguration persistenceThreadPool() {
        return this.threads.persistenceThreadPool();
    }

    @Deprecated
    public ThreadPoolConfiguration stateTransferThreadPool() {
        return this.threads.stateTransferThreadPool();
    }

    public ThreadPoolConfiguration asyncThreadPool() {
        return this.threads.asyncThreadPool();
    }

    public String toString() {
        return "CacheContainerConfiguration{zeroCapacityAvailable=" + this.zeroCapacityAvailable + ", threads=" + this.threads + ", globalJmxStatistics=" + this.globalJmxStatistics + ", transport=" + this.transport + ", security=" + this.security + ", serialization=" + this.serialization + ", globalState=" + this.globalState + ", shutdown=" + this.shutdown + ", attributes=" + this.attributes + '}';
    }
}

