/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.L1ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class ClusteringConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements ClusteringConfigurationChildBuilder,
Builder<ClusteringConfiguration>,
ConfigurationBuilderInfo {
    private final HashConfigurationBuilder hashConfigurationBuilder;
    private final L1ConfigurationBuilder l1ConfigurationBuilder;
    private final StateTransferConfigurationBuilder stateTransferConfigurationBuilder;
    private final PartitionHandlingConfigurationBuilder partitionHandlingConfigurationBuilder;
    private final AttributeSet attributes;
    private final List<ConfigurationBuilderInfo> subElements = new ArrayList<ConfigurationBuilderInfo>();

    ClusteringConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = ClusteringConfiguration.attributeDefinitionSet();
        this.hashConfigurationBuilder = new HashConfigurationBuilder(this);
        this.l1ConfigurationBuilder = new L1ConfigurationBuilder(this);
        this.stateTransferConfigurationBuilder = new StateTransferConfigurationBuilder(this);
        this.partitionHandlingConfigurationBuilder = new PartitionHandlingConfigurationBuilder(this);
        this.subElements.addAll(Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder));
    }

    public ElementDefinition<? extends ConfigurationInfo> getElementDefinition() {
        return ClusteringConfiguration.ELEMENT_DEFINITION;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    public ClusteringConfigurationBuilder cacheMode(CacheMode cacheMode) {
        this.attributes.attribute(ClusteringConfiguration.CACHE_MODE).set((Object)cacheMode);
        return this;
    }

    public CacheMode cacheMode() {
        return (CacheMode)((Object)this.attributes.attribute(ClusteringConfiguration.CACHE_MODE).get());
    }

    public ClusteringConfigurationBuilder remoteTimeout(long l) {
        this.attributes.attribute(ClusteringConfiguration.REMOTE_TIMEOUT).set((Object)l);
        return this;
    }

    public ClusteringConfigurationBuilder remoteTimeout(long l, TimeUnit unit) {
        return this.remoteTimeout(unit.toMillis(l));
    }

    public ClusteringConfigurationBuilder invalidationBatchSize(int size) {
        this.attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).set((Object)size);
        return this;
    }

    public ClusteringConfigurationBuilder biasAcquisition(BiasAcquisition biasAcquisition) {
        this.attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).set((Object)biasAcquisition);
        return this;
    }

    public ClusteringConfigurationBuilder biasLifespan(long l, TimeUnit unit) {
        this.attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).set((Object)unit.toMillis(l));
        return this;
    }

    @Override
    public HashConfigurationBuilder hash() {
        return this.hashConfigurationBuilder;
    }

    @Override
    public L1ConfigurationBuilder l1() {
        return this.l1ConfigurationBuilder;
    }

    @Override
    public StateTransferConfigurationBuilder stateTransfer() {
        return this.stateTransferConfigurationBuilder;
    }

    @Override
    public PartitionHandlingConfigurationBuilder partitionHandling() {
        return this.partitionHandlingConfigurationBuilder;
    }

    public void validate() {
        for (Builder builder : Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            builder.validate();
        }
        if (this.cacheMode().isScattered()) {
            if (this.hash().numOwners() != 1 && this.hash().isNumOwnersSet()) {
                throw Log.CONFIG.scatteredCacheNeedsSingleOwner();
            }
            this.hash().numOwners(1);
            TransactionMode transactionMode = this.transaction().transactionMode();
            if (transactionMode != null && transactionMode.isTransactional()) {
                throw Log.CONFIG.scatteredCacheIsNonTransactional();
            }
        }
        if (!this.cacheMode().isScattered() && this.attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).isModified()) {
            throw Log.CONFIG.invalidationBatchSizeAppliesOnNonScattered();
        }
        if (!this.cacheMode().isScattered() && (this.attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).isModified() || this.attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).isModified())) {
            throw Log.CONFIG.biasedReadsAppliesOnlyToScattered();
        }
        if (this.attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).get() == BiasAcquisition.ON_READ) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.cacheMode().isClustered() && globalConfig.transport().transport() == null && !this.builder.template()) {
            throw Log.CONFIG.missingTransportConfiguration();
        }
        for (ConfigurationChildBuilder configurationChildBuilder : Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            configurationChildBuilder.validate(globalConfig);
        }
    }

    public ClusteringConfiguration create() {
        return new ClusteringConfiguration(this.attributes.protect(), this.hashConfigurationBuilder.create(), this.l1ConfigurationBuilder.create(), this.stateTransferConfigurationBuilder.create(), this.partitionHandlingConfigurationBuilder.create());
    }

    public ClusteringConfigurationBuilder read(ClusteringConfiguration template) {
        this.attributes.read(template.attributes());
        this.hashConfigurationBuilder.read(template.hash());
        this.l1ConfigurationBuilder.read(template.l1());
        this.stateTransferConfigurationBuilder.read(template.stateTransfer());
        this.partitionHandlingConfigurationBuilder.read(template.partitionHandling());
        return this;
    }

    public String toString() {
        return "ClusteringConfigurationBuilder [hashConfigurationBuilder=" + this.hashConfigurationBuilder + ", l1ConfigurationBuilder=" + this.l1ConfigurationBuilder + ", stateTransferConfigurationBuilder=" + this.stateTransferConfigurationBuilder + ", partitionHandlingConfigurationBuilder=" + this.partitionHandlingConfigurationBuilder + ", attributes=" + this.attributes + "]";
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

