/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.JavaSerializationEncoder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.EmbeddedRestHotRodTest")
public class EmbeddedRestHotRodTest
extends AbstractInfinispanTest {
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    CompatibilityCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory(CacheMode.LOCAL).setup();
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.cacheFactory.addRegexWhiteList("org.infinispan.*Person");
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testRestPutEmbeddedHotRodGet() throws Exception {
        String key = "1";
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "1");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("<hey>ho</hey>".getBytes(), "text/plain"));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"1"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getHotRodCache().get((Object)"1"));
    }

    public void testEmbeddedPutRestHotRodGet() throws Exception {
        String key = "2";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"2"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "2");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    public void testHotRodPutEmbeddedRestGet() throws Exception {
        String key = "3";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"3", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"3"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "3");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    public void testCustomObjectHotRodPutEmbeddedRestGet() throws Exception {
        String key = "4";
        Person p = new Person("Martin");
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"4", (Object)p));
        AssertJUnit.assertEquals((Object)p, (Object)this.cacheFactory.getEmbeddedCache().get((Object)"4"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "4");
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((String)get.getStatusText(), (int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((Object)p, (Object)new ObjectInputStream(get.getResponseBodyAsStream()).readObject());
    }

    public void testCustomObjectEmbeddedPutHotRodRestGet() throws Exception {
        String key = "5";
        Person p = new Person("Galder");
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"5", (Object)p));
        AssertJUnit.assertEquals((Object)p, (Object)this.cacheFactory.getHotRodCache().get((Object)"5"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "5");
        get.setRequestHeader("Accept", "application/x-java-serialized-object, application/json;q=0.3");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((String)get.getStatusText(), (int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((Object)p, (Object)new ObjectInputStream(get.getResponseBodyAsStream()).readObject());
    }

    public void testCustomObjectEmbeddedPutRestGetAcceptJSONAndXML() throws Exception {
        String key = "6";
        Person p = new Person("Anna");
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"6", (Object)p));
        GetMethod getJson = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "6");
        getJson.setRequestHeader("Accept", "application/json");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getJson);
        AssertJUnit.assertEquals((String)getJson.getStatusText(), (int)200, (int)getJson.getStatusCode());
        AssertJUnit.assertEquals((String)this.asJson(p), (String)getJson.getResponseBodyAsString());
        GetMethod getXml = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "6");
        getXml.setRequestHeader("Accept", "application/xml");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getXml);
        AssertJUnit.assertEquals((String)getXml.getStatusText(), (int)200, (int)getXml.getStatusCode());
        AssertJUnit.assertTrue((boolean)getXml.getResponseBodyAsString().contains("<name>Anna</name>"));
    }

    public void testCustomObjectHotRodPutRestGetAcceptJSONAndXML() throws Exception {
        String key = "7";
        Person p = new Person("Jakub");
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"7", (Object)p));
        GetMethod getJson = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "7");
        getJson.setRequestHeader("Accept", "application/json");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getJson);
        AssertJUnit.assertEquals((String)getJson.getStatusText(), (int)200, (int)getJson.getStatusCode());
        AssertJUnit.assertEquals((String)this.asJson(p), (String)getJson.getResponseBodyAsString());
        GetMethod getXml = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "7");
        getXml.setRequestHeader("Accept", "application/xml");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getXml);
        AssertJUnit.assertEquals((String)getXml.getStatusText(), (int)200, (int)getXml.getStatusCode());
        AssertJUnit.assertTrue((boolean)getXml.getResponseBodyAsString().contains("<name>Jakub</name>"));
    }

    public void testCustomObjectRestPutHotRodEmbeddedGet() throws Exception {
        String key = "77";
        Person p = new Person("Iker");
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "77");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bout);){
            oos.writeObject(p);
        }
        put.setRequestHeader("Content-Type", "application/x-java-serialized-object");
        put.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(bout.toByteArray())));
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)put);
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals((Object)p, (Object)remote.get((Object)"77"));
        AssertJUnit.assertEquals((Object)p, (Object)this.cacheFactory.getEmbeddedCache().getAdvancedCache().withEncoding(IdentityEncoder.class, JavaSerializationEncoder.class).get((Object)"77"));
    }

    public void testHotRodEmbeddedPutRestHeadExpiry() throws Exception {
        String key1 = "8";
        String key2 = "9";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getHotRodCache().put((Object)"8", (Object)"v1", 5L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"9", (Object)"v2", 5L, TimeUnit.SECONDS));
        HeadMethod headKey1 = new HeadMethod(this.cacheFactory.getRestUrl() + "/" + "8");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)headKey1);
        AssertJUnit.assertEquals((int)200, (int)headKey1.getStatusCode());
        Header expires = headKey1.getResponseHeader("Expires");
        AssertJUnit.assertNotNull((Object)expires);
        AssertJUnit.assertTrue((boolean)dateFormat.parse(expires.getValue()).after(new GregorianCalendar(2013, 1, 1).getTime()));
        HeadMethod headKey2 = new HeadMethod(this.cacheFactory.getRestUrl() + "/" + "9");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)headKey2);
        AssertJUnit.assertEquals((int)200, (int)headKey2.getStatusCode());
        AssertJUnit.assertNotNull((Object)headKey2.getResponseHeader("Expires"));
    }

    public void testHotRodEmbeddedPutRestGetExpiry() throws Exception {
        String key = "10";
        String key2 = "11";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getHotRodCache().put((Object)"10", (Object)"v1", 5L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"11", (Object)"v2", 5L, TimeUnit.SECONDS));
        GetMethod get1 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "10");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get1);
        AssertJUnit.assertEquals((int)200, (int)get1.getStatusCode());
        EmbeddedRestHotRodTest.assertDate((HttpMethod)get1, "Expires");
        GetMethod get2 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "11");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get2);
        AssertJUnit.assertEquals((int)200, (int)get2.getStatusCode());
        EmbeddedRestHotRodTest.assertDate((HttpMethod)get2, "Expires");
    }

    public void testHotRodEmbeddedPutRestGetLastModified() throws Exception {
        String key = "12";
        String key2 = "13";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getHotRodCache().put((Object)"12", (Object)"v1", 5L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"13", (Object)"v2", 5L, TimeUnit.SECONDS));
        GetMethod get1 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "12");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get1);
        AssertJUnit.assertEquals((int)200, (int)get1.getStatusCode());
        EmbeddedRestHotRodTest.assertDate((HttpMethod)get1, "Last-Modified");
        GetMethod get2 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "13");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get2);
        AssertJUnit.assertEquals((int)200, (int)get2.getStatusCode());
        EmbeddedRestHotRodTest.assertDate((HttpMethod)get2, "Last-Modified");
    }

    private static void assertDate(HttpMethod method, String header) throws Exception {
        Header dateHeader = method.getResponseHeader(header);
        AssertJUnit.assertNotNull((Object)dateHeader);
        Date parsedDate = dateFormat.parse(dateHeader.getValue());
        AssertJUnit.assertTrue((String)("Parsed date is before this code was written: " + parsedDate), (boolean)parsedDate.after(new GregorianCalendar(2013, 1, 1).getTime()));
    }

    public void testByteArrayHotRodEmbeddedPutRestGet() throws Exception {
        String key1 = "14";
        String key2 = "15";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"14", (Object)"v1".getBytes()));
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"15", (Object)"v2".getBytes()));
        GetMethod getHotRodValue = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "14");
        getHotRodValue.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getHotRodValue);
        AssertJUnit.assertEquals((String)getHotRodValue.getStatusText(), (int)200, (int)getHotRodValue.getStatusCode());
        AssertJUnit.assertEquals((String)"text/plain", (String)getHotRodValue.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertArrayEquals((byte[])"v1".getBytes(), (byte[])getHotRodValue.getResponseBody());
        GetMethod getEmbeddedValue = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "15");
        getEmbeddedValue.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getEmbeddedValue);
        AssertJUnit.assertEquals((String)getEmbeddedValue.getStatusText(), (int)200, (int)getEmbeddedValue.getStatusCode());
        AssertJUnit.assertEquals((String)"text/plain", (String)getEmbeddedValue.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertArrayEquals((byte[])"v2".getBytes(), (byte[])getEmbeddedValue.getResponseBody());
    }

    public void testHotRodEmbeddedPutRestGetWrongAccept() throws Exception {
        String key1 = "16";
        String key2 = "17";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getHotRodCache().put((Object)"16", (Object)"v1"));
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"17", (Object)"v2"));
        HeadMethod getKey1 = new HeadMethod(this.cacheFactory.getRestUrl() + "/" + "16");
        getKey1.setRequestHeader("Accept", "unknown-media-type");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getKey1);
        AssertJUnit.assertEquals((String)getKey1.getStatusText(), (int)406, (int)getKey1.getStatusCode());
        HeadMethod getKey2 = new HeadMethod(this.cacheFactory.getRestUrl() + "/" + "17");
        getKey2.setRequestHeader("Accept", "unknown-media-type");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getKey2);
        AssertJUnit.assertEquals((String)getKey2.getStatusText(), (int)406, (int)getKey2.getStatusCode());
    }

    public void testHotRodEmbeddedPutRestGetCacheControlHeader() throws Exception {
        String key1 = "18";
        String key2 = "19";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getHotRodCache().put((Object)"18", (Object)"v1", 7L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"19", (Object)"v2", 7L, TimeUnit.SECONDS));
        GetMethod getKey1 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "18");
        getKey1.setRequestHeader("Cache-Control", "min-fresh=20");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getKey1);
        AssertJUnit.assertEquals((String)getKey1.getStatusText(), (int)404, (int)getKey1.getStatusCode());
        GetMethod getKey2 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "19");
        getKey2.setRequestHeader("Cache-Control", "min-fresh=20");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getKey2);
        AssertJUnit.assertEquals((String)getKey2.getStatusText(), (int)404, (int)getKey2.getStatusCode());
        getKey1 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "18");
        getKey1.setRequestHeader("Accept", "text/plain");
        getKey1.setRequestHeader("Cache-Control", "min-fresh=3");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getKey1);
        AssertJUnit.assertNotNull((Object)getKey1.getResponseHeader("Cache-Control"));
        AssertJUnit.assertTrue((boolean)getKey1.getResponseHeader("Cache-Control").getValue().contains("max-age"));
        AssertJUnit.assertEquals((String)getKey1.getStatusText(), (int)200, (int)getKey1.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)getKey1.getResponseBodyAsString());
        getKey2 = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "19");
        getKey2.setRequestHeader("Cache-Control", "min-fresh=3");
        getKey2.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)getKey2);
        AssertJUnit.assertTrue((boolean)getKey2.getResponseHeader("Cache-Control").getValue().contains("max-age"));
        AssertJUnit.assertEquals((String)getKey2.getStatusText(), (int)200, (int)getKey2.getStatusCode());
        AssertJUnit.assertEquals((String)"v2", (String)getKey2.getResponseBodyAsString());
    }

    private String asJson(Person p) {
        ObjectNode person = MAPPER.createObjectNode();
        person.put("_type", p.getClass().getName());
        person.put("name", p.name);
        return person.toString();
    }

    static class Person
    implements Serializable {
        final String name;

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

