/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.it.compatibility.CryptoCurrency;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseJsonTest
extends AbstractInfinispanTest {
    RestServer restServer;
    HttpClient restClient;
    private EmbeddedCacheManager cacheManager;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<String, CryptoCurrency> remoteCache;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CACHE_NAME = "indexed";
    HotRodServer hotRodServer;
    private String restEndpoint;

    abstract ConfigurationBuilder getIndexCacheConfiguration();

    abstract RemoteCacheManager createRemoteCacheManager() throws Exception;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        ClassWhiteList classWhiteList = this.cacheManager.getClassWhiteList();
        classWhiteList.addRegexps(new String[]{".*"});
        this.cacheManager.defineConfiguration(CACHE_NAME, this.getIndexCacheConfiguration().build());
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        int restPort = ServerTestingUtil.findFreePort();
        builder.port(restPort);
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)builder.build(), this.cacheManager);
        this.restClient = new HttpClient();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.remoteCacheManager = this.createRemoteCacheManager();
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
        this.restEndpoint = String.format("http://localhost:%s/rest/%s", this.restServer.getPort(), CACHE_NAME);
    }

    abstract String getEntityName();

    private void writeCurrencyViaJson(String key, String description, int rank) throws IOException {
        PutMethod put = new PutMethod(this.restEndpoint + "/" + key);
        ObjectNode currency = MAPPER.createObjectNode();
        currency.put("_type", this.getEntityName());
        currency.put("description", description);
        currency.put("rank", rank);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(currency.toString(), "application/json", "UTF-8"));
        this.restClient.executeMethod((HttpMethod)put);
        System.out.println(put.getResponseBodyAsString());
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
    }

    private CryptoCurrency readCurrencyViaJson(String key) throws IOException {
        GetMethod get = new GetMethod(this.restEndpoint + "/" + key);
        get.setRequestHeader("Accept", "application/json");
        this.restClient.executeMethod((HttpMethod)get);
        String json = get.getResponseBodyAsString();
        JsonNode jsonNode = new ObjectMapper().readTree(json);
        JsonNode description = jsonNode.get("description");
        JsonNode rank = jsonNode.get("rank");
        return new CryptoCurrency(description.asText(), rank.intValue());
    }

    @Test
    public void testRestOnly() throws Exception {
        this.writeCurrencyViaJson("DASH", "Dash", 7);
        this.writeCurrencyViaJson("IOTA", "Iota", 8);
        this.writeCurrencyViaJson("XMR", "Monero", 9);
        CryptoCurrency xmr = this.readCurrencyViaJson("XMR");
        Assert.assertEquals((Object)xmr.getRank(), (Object)9);
        Assert.assertEquals((String)xmr.getDescription(), (String)"Monero");
    }

    @Test
    public void testHotRodInteroperability() throws Exception {
        this.remoteCache.clear();
        this.remoteCache.put((Object)"BTC", (Object)new CryptoCurrency("Bitcoin", 1));
        this.remoteCache.put((Object)"ETH", (Object)new CryptoCurrency("Ethereum", 2));
        this.remoteCache.put((Object)"XRP", (Object)new CryptoCurrency("Ripple", 3));
        this.remoteCache.put((Object)"CAT", (Object)new CryptoCurrency("Catcoin", 618));
        Assert.assertEquals((String)((CryptoCurrency)this.remoteCache.get((Object)"CAT")).getDescription(), (String)"Catcoin");
        Assert.assertEquals((int)this.remoteCache.size(), (int)4);
        Query query = Search.getQueryFactory(this.remoteCache).create("FROM " + this.getEntityName() + " c where c.rank < 10");
        List highRankCoins = query.list();
        Assert.assertEquals((int)highRankCoins.size(), (int)3);
        CryptoCurrency btc = this.readCurrencyViaJson("BTC");
        Assert.assertEquals((String)"Bitcoin", (String)btc.getDescription());
        Assert.assertEquals((Object)1, (Object)btc.getRank());
        this.writeCurrencyViaJson("LTC", "Litecoin", 4);
        query = Search.getQueryFactory(this.remoteCache).create("FROM " + this.getEntityName() + " c  where c.description = 'Litecoin'");
        CryptoCurrency litecoin = (CryptoCurrency)query.list().iterator().next();
        Assert.assertEquals((String)litecoin.getDescription(), (String)"Litecoin");
        AssertJUnit.assertTrue((litecoin.getRank() == 4 ? 1 : 0) != 0);
        Object jsonResult = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).build()).get((Object)"LTC");
        JsonNode jsonNode = new ObjectMapper().readTree((byte[])jsonResult);
        Assert.assertEquals((String)"Litecoin", (String)jsonNode.get("description").asText());
    }

    @AfterClass
    protected void teardown() {
        this.remoteCacheManager.stop();
        if (this.restServer != null) {
            try {
                this.restServer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer});
    }
}

