/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.ByteArrayKeyReplEmbeddedHotRodTest")
public class ByteArrayKeyReplEmbeddedHotRodTest
extends AbstractInfinispanTest {
    CompatibilityCacheFactory<Object, Object> cacheFactory1;
    CompatibilityCacheFactory<Object, Object> cacheFactory2;

    public void testHotRodPutEmbeddedGet() throws Exception {
        byte[] key = "4".getBytes();
        String value = "v1";
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory2.getEmbeddedCache().get((Object)key));
    }

    public void testHotRodReplace() throws Exception {
        byte[] key = "5".getBytes();
        String value1 = "v1";
        String value2 = "v2";
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1"));
        VersionedValue versioned = this.cacheFactory1.getHotRodCache().getVersioned((Object)key);
        AssertJUnit.assertTrue((boolean)this.cacheFactory1.getHotRodCache().replaceWithVersion((Object)key, (Object)"v2", versioned.getVersion()));
    }

    public void testHotRodRemove() throws Exception {
        byte[] key = "7".getBytes();
        String value = "v1";
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1"));
        VersionedValue versioned = this.cacheFactory1.getHotRodCache().getVersioned((Object)key);
        AssertJUnit.assertTrue((boolean)this.cacheFactory1.getHotRodCache().removeWithVersion((Object)key, versioned.getVersion()));
    }

    public void testEmbeddedPutHotRodGet() throws Exception {
        byte[] key = "8".getBytes();
        String value = "v1";
        AssertJUnit.assertNull((Object)this.cacheFactory2.getEmbeddedCache().put((Object)key, (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory1.getHotRodCache().get((Object)key));
    }

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new CompatibilityCacheFactory(CacheMode.REPL_SYNC).setup();
        this.cacheFactory2 = new CompatibilityCacheFactory(CacheMode.REPL_SYNC).setup();
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }
}

