/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.it.compatibility.CryptoCurrency;
import org.infinispan.it.compatibility.JsonIndexingProtobufStoreTest;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.ProtoRegistrationJsonTest")
public class ProtoRegistrationJsonTest
extends JsonIndexingProtobufStoreTest {
    @Override
    protected RemoteCacheManager createRemoteCacheManager() throws IOException {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(new ConfigurationBuilder().addServer().host("localhost").port(this.hotRodServer.getPort()).marshaller((Marshaller)new ProtoStreamMarshaller()).build());
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("crypto.proto").addClass(CryptoCurrency.class).build(serializationContext);
        String metadataCacheEndpoint = String.format("http://localhost:%s/rest/%s", this.restServer.getPort(), "___protobuf_metadata");
        PutMethod put = new PutMethod(metadataCacheEndpoint + "/crypto.proto");
        put.setRequestEntity((RequestEntity)new StringRequestEntity(protoFile, "text/plain", "UTF-8"));
        this.restClient.executeMethod((HttpMethod)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        return remoteCacheManager;
    }
}

