/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.EmbeddedRestHotRodWithStringTest")
public class EmbeddedRestHotRodWithStringTest
extends AbstractInfinispanTest {
    CompatibilityCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory("testCache", (Marshaller)new UTF8StringMarshaller(), CacheMode.LOCAL).setup();
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testRestPutStringHotRodGet() throws Exception {
        String key = "1";
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "1");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("<hey>ho</hey>", "text/plain", "UTF-8"));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getHotRodCache().get((Object)"1"));
        String newKey = "2";
        String newValue = "<let's>go</let's>";
        RemoteCache<String, Object> hotRodCache = this.cacheFactory.getHotRodCache();
        hotRodCache.put((Object)"2", (Object)"<let's>go</let's>");
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "2");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"<let's>go</let's>", (String)get.getResponseBodyAsString());
    }
}

