/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.httpclient.HttpClient;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class CompatibilityCacheFactory<K, V> {
    private static final int DEFAULT_NUM_OWNERS = 2;
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrod;
    private RemoteCacheManager hotrodClient;
    private RestServer rest;
    private MemcachedServer memcached;
    private Cache<K, V> embeddedCache;
    private RemoteCache<K, V> hotrodCache;
    private HttpClient restClient;
    private MemcachedClient memcachedClient;
    private Transcoder transcoder;
    private final String cacheName;
    private final Marshaller marshaller;
    private final CacheMode cacheMode;
    private final int numOwners;
    private final boolean l1Enable;
    private final boolean memcachedWithDecoder;
    private int restPort;

    CompatibilityCacheFactory(CacheMode cacheMode) {
        this(cacheMode, 2, false);
    }

    CompatibilityCacheFactory(CacheMode cacheMode, int numOwners, boolean l1Enable) {
        this("", null, cacheMode, numOwners, l1Enable, null, null);
    }

    CompatibilityCacheFactory(CacheMode cacheMode, int numOwners, boolean l1Enable, Encoder encoder) {
        this("", null, cacheMode, numOwners, l1Enable, null, encoder);
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode) {
        this(cacheName, marshaller, cacheMode, 2, null);
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, Encoder encoder) {
        this(cacheName, marshaller, cacheMode, 2, false, null, encoder);
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, int numOwners, Encoder encoder) {
        this(cacheName, marshaller, cacheMode, numOwners, false, null, encoder);
    }

    public CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, Transcoder transcoder) {
        this(cacheName, marshaller, cacheMode, 2, false, transcoder, null);
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, int numOwners, boolean l1Enable, Transcoder transcoder, Encoder encoder) {
        this.cacheName = cacheName;
        this.marshaller = marshaller;
        this.cacheMode = cacheMode;
        this.numOwners = numOwners;
        this.l1Enable = l1Enable;
        this.transcoder = transcoder;
        this.memcachedWithDecoder = transcoder != null;
    }

    public CompatibilityCacheFactory<K, V> setup() throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache();
        this.createRestMemcachedCaches();
        return this;
    }

    private void createRestMemcachedCaches() throws Exception {
        this.createRestCache();
        this.createMemcachedCache();
    }

    private void createEmbeddedCache() {
        GlobalConfigurationBuilder globalBuilder;
        if (this.cacheMode.isClustered()) {
            globalBuilder = new GlobalConfigurationBuilder();
            globalBuilder.transport().defaultTransport();
        } else {
            globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        }
        ((PrivateGlobalConfigurationBuilder)globalBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(this.cacheMode).compatibility().enable().marshaller(this.marshaller);
        if (this.cacheMode.isDistributed() && this.numOwners != 2) {
            builder.clustering().hash().numOwners(this.numOwners);
        }
        if (this.cacheMode.isDistributed() && this.l1Enable) {
            builder.clustering().l1().enable();
        }
        EmbeddedCacheManager embeddedCacheManager = this.cacheManager = this.cacheMode.isClustered() ? TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalBuilder, (org.infinispan.configuration.cache.ConfigurationBuilder)builder) : TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        if (!this.cacheName.isEmpty()) {
            this.cacheManager.defineConfiguration(this.cacheName, builder.build());
        }
        this.embeddedCache = this.cacheName.isEmpty() ? this.cacheManager.getCache() : this.cacheManager.getCache(this.cacheName);
    }

    private void createHotRodCache() {
        this.createHotRodCache(HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager));
    }

    private void createHotRodCache(HotRodServer server) {
        this.hotrod = server;
        this.hotrodClient = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.hotrod.getPort()).addJavaSerialWhiteList(new String[]{".*Person.*", ".*CustomEvent.*"}).marshaller(this.marshaller).build());
        this.hotrodCache = this.cacheName.isEmpty() ? this.hotrodClient.getCache() : this.hotrodClient.getCache(this.cacheName);
    }

    private void createRestCache() throws Exception {
        RestServer restServer = (RestServer)ServerTestingUtil.startProtocolServer((int)ServerTestingUtil.findFreePort(), p -> {
            RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
            builder.port(p.intValue());
            this.rest = new RestServer();
            this.rest.start((ProtocolServerConfiguration)builder.build(), this.cacheManager);
            return this.rest;
        });
        this.restPort = restServer.getPort();
        this.restClient = new HttpClient();
    }

    private void createMemcachedCache() throws IOException {
        this.memcached = (MemcachedServer)ServerTestingUtil.startProtocolServer((int)ServerTestingUtil.findFreePort(), p -> {
            if (this.memcachedWithDecoder) {
                return MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager, (int)p, (String)this.cacheName);
            }
            return MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager, (int)p);
        });
        this.memcachedClient = this.createMemcachedClient(60000L, this.memcached.getPort());
    }

    private MemcachedClient createMemcachedClient(final long timeout, int port) throws IOException {
        DefaultConnectionFactory cf = new DefaultConnectionFactory(){

            public long getOperationTimeout() {
                return timeout;
            }
        };
        if (this.transcoder != null) {
            cf = new ConnectionFactoryBuilder((ConnectionFactory)cf).setTranscoder(this.transcoder).build();
        }
        return new MemcachedClient((ConnectionFactory)cf, Collections.singletonList(new InetSocketAddress("127.0.0.1", port)));
    }

    public static void killCacheFactories(CompatibilityCacheFactory ... cacheFactories) {
        if (cacheFactories != null) {
            for (CompatibilityCacheFactory cacheFactory : cacheFactories) {
                if (cacheFactory == null) continue;
                cacheFactory.teardown();
            }
        }
    }

    void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.hotrodClient);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrod});
        this.killRestServer(this.rest);
        MemcachedTestingUtil.killMemcachedClient((MemcachedClient)this.memcachedClient);
        MemcachedTestingUtil.killMemcachedServer((MemcachedServer)this.memcached);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    private void killRestServer(RestServer rest) {
        if (rest != null) {
            try {
                rest.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Cache<K, V> getEmbeddedCache() {
        return this.embeddedCache.getAdvancedCache().withEncoding(IdentityEncoder.class);
    }

    public RemoteCache<K, V> getHotRodCache() {
        return this.hotrodCache;
    }

    public HttpClient getRestClient() {
        return this.restClient;
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    int getMemcachedPort() {
        return this.memcached.getPort();
    }

    public String getRestUrl() {
        String restCacheName = this.cacheName.isEmpty() ? "___defaultcache" : this.cacheName;
        return String.format("http://localhost:%s/rest/%s", this.restPort, restCacheName);
    }

    HotRodServer getHotrodServer() {
        return this.hotrod;
    }

    public void registerEncoder(Encoder encoder) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)this.embeddedCache.getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        encoderRegistry.registerEncoder(encoder);
    }
}

